/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.ui;

import com.sun.electric.Main;
import com.sun.electric.database.change.DatabaseChangeListener;
import com.sun.electric.database.change.Undo;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.simulation.Simulation;
import com.sun.electric.tool.user.ActivityLogger;
import com.sun.electric.tool.user.ErrorLogger;
import com.sun.electric.tool.user.Highlighter;
import com.sun.electric.tool.user.Resources;
import com.sun.electric.tool.user.menus.FileMenu;
import com.sun.electric.tool.user.ui.ClickZoomWireListener;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.ExplorerTree;
import com.sun.electric.tool.user.ui.PaletteFrame;
import com.sun.electric.tool.user.ui.TextWindow;
import com.sun.electric.tool.user.ui.TopLevel;
import com.sun.electric.tool.user.ui.WaveformWindow;
import com.sun.electric.tool.user.ui.WindowContent;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.Rectangle;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class WindowFrame {
    private WindowContent content;
    private JTextArea textWnd;
    private JSplitPane js;
    private JInternalFrame jif = null;
    private TopLevel jf = null;
    private InternalWindowsEvents internalWindowsEvents;
    private WindowsEvents windowsEvents;
    public ExplorerTree tree;
    public DefaultMutableTreeNode rootNode;
    public DefaultMutableTreeNode libraryExplorerNode;
    public DefaultMutableTreeNode jobExplorerNode;
    public DefaultMutableTreeNode errorExplorerNode;
    public DefaultMutableTreeNode signalExplorerNode;
    public DefaultMutableTreeNode sweepExplorerNode;
    private DefaultTreeModel treeModel;
    private boolean finished = false;
    private static int windowOffset = 0;
    private static List windowList = new ArrayList();
    private static WindowFrame curWindowFrame = null;
    public static MouseListener curMouseListener = ClickZoomWireListener.theOne;
    public static MouseMotionListener curMouseMotionListener = ClickZoomWireListener.theOne;
    public static MouseWheelListener curMouseWheelListener = ClickZoomWireListener.theOne;
    public static KeyListener curKeyListener = ClickZoomWireListener.theOne;
    private static LibraryTreeUpdater libTreeUpdater = new LibraryTreeUpdater();
    private static final Class view3DClass = Resources.get3DMainClass();
    private static Constructor constructor3DClass = null;
    private static Method showMethod3DClass = null;
    private boolean wantToRedoLibraryTree = false;
    private boolean wantToRedoJobTree = false;
    private boolean wantToRedoErrorTree = false;
    private boolean wantToRedoSignalTree = false;

    private WindowFrame() {
    }

    public static WindowFrame createEditWindow(Cell cell) {
        WindowFrame frame = new WindowFrame();
        if (cell != null && cell.getView().isTextView()) {
            TextWindow tWnd = new TextWindow(cell, frame);
            frame.buildWindowStructure(tWnd, cell, null);
            WindowFrame.setCurrentWindowFrame(frame);
            frame.populateJFrame();
            tWnd.fillScreen();
        } else {
            EditWindow eWnd = EditWindow.CreateElectricDoc(cell, frame);
            frame.buildWindowStructure(eWnd, cell, null);
            WindowFrame.setCurrentWindowFrame(frame);
            frame.populateJFrame();
            eWnd.fillScreen();
        }
        WindowFrame.removeUIBinding(frame.js, KeyStroke.getKeyStroke(117, 0));
        WindowFrame.removeUIBinding(frame.js, KeyStroke.getKeyStroke(119, 0));
        return frame;
    }

    public static WindowFrame create3DViewtWindow(Cell cell, WindowContent view2D) {
        WindowFrame frame = new WindowFrame();
        if (view3DClass == null) {
            System.out.println("3D View plugin not available");
            return frame;
        }
        try {
            if (constructor3DClass == null) {
                constructor3DClass = view3DClass.getDeclaredConstructor(Cell.class, WindowFrame.class, WindowContent.class);
            }
            Object vWnd = constructor3DClass.newInstance(cell, frame, view2D);
            frame.buildWindowStructure((WindowContent)vWnd, cell, null);
            WindowFrame.setCurrentWindowFrame(frame);
            frame.populateJFrame();
        }
        catch (Exception e) {
            System.out.println("Can't open 3D View window: " + e.getMessage());
            ActivityLogger.logException(e);
        }
        return frame;
    }

    public static void show3DHighlight(WindowContent view2D) {
        if (view3DClass == null) {
            return;
        }
        try {
            if (showMethod3DClass == null) {
                showMethod3DClass = view3DClass.getDeclaredMethod("show3DHighlight", WindowContent.class);
            }
            showMethod3DClass.invoke((Object)view3DClass, view2D);
        }
        catch (Exception e) {
            System.out.println("Cannot call 3D plugin method: " + e.getMessage());
            ActivityLogger.logException(e);
        }
    }

    public static WindowFrame createWaveformWindow(Simulation.SimData sd) {
        WindowFrame frame = new WindowFrame();
        WaveformWindow wWnd = new WaveformWindow(sd, frame);
        frame.buildWindowStructure(wWnd, sd.getCell(), null);
        WindowFrame.setCurrentWindowFrame(frame);
        frame.populateJFrame();
        wWnd.fillScreen();
        return frame;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildWindowStructure(WindowContent content, Cell cell, GraphicsConfiguration gc) {
        this.content = content;
        this.rootNode = new DefaultMutableTreeNode("Explorer");
        content.loadExplorerTree(this.rootNode);
        this.treeModel = new DefaultTreeModel(this.rootNode);
        this.tree = ExplorerTree.CreateExplorerTree(this.rootNode, this.treeModel);
        JScrollPane scrolledTree = new JScrollPane(this.tree);
        this.js = new JSplitPane(1);
        this.js.setRightComponent(content.getPanel());
        this.js.setLeftComponent(scrolledTree);
        this.js.setDividerLocation(200);
        String cellDescription = cell == null ? "no cell" : cell.describe();
        this.createJFrame(cellDescription, gc);
        if ((windowOffset += 70) > 300) {
            windowOffset = 0;
        }
        List list = windowList;
        synchronized (list) {
            windowList.add(this);
        }
    }

    private void createJFrame(String title, GraphicsConfiguration gc) {
        Dimension scrnSize = TopLevel.getScreenSize();
        Dimension frameSize = new Dimension(scrnSize.width * 4 / 5, scrnSize.height * 6 / 8);
        if (TopLevel.isMDIMode()) {
            this.jif = new JInternalFrame(title, true, true, true, true);
            this.jif.setSize(frameSize);
            this.jif.setLocation(windowOffset + 150, windowOffset);
            this.jif.setAutoscrolls(true);
            this.jif.setFrameIcon(TopLevel.getFrameIcon());
        } else {
            this.jf = new TopLevel("Electric - " + title, new Rectangle(frameSize), this, gc);
            this.jf.setSize(frameSize);
            this.jf.setLocation(windowOffset + 150, windowOffset);
        }
    }

    public void addJS(JComponent js, int width, int height, int lowX, int lowY) {
        if (TopLevel.isMDIMode()) {
            js.setSize(new Dimension(width, height));
            js.setBorder(new EmptyBorder(0, 0, 0, 0));
            js.setLocation(lowX, lowY);
            js.setVisible(true);
            js.requestFocus();
            js.requestFocusInWindow();
            TopLevel.getDesktop().add((Component)js, 0);
        } else {
            this.jf.getContentPane().add(js);
            if (!Main.BATCHMODE) {
                this.jf.setVisible(true);
            }
        }
    }

    private void populateJFrame() {
        if (TopLevel.isMDIMode()) {
            this.jif.getContentPane().add(this.js);
            this.internalWindowsEvents = new InternalWindowsEvents(this);
            this.jif.addInternalFrameListener(this.internalWindowsEvents);
            this.jif.addInternalFrameListener(TopLevel.getCurrentJFrame().getToolBar());
            this.content.getPanel().addPropertyChangeListener("GoBackEnabled", TopLevel.getCurrentJFrame().getToolBar());
            this.content.getPanel().addPropertyChangeListener("GoForwardEnabled", TopLevel.getCurrentJFrame().getToolBar());
            TopLevel.addToDesktop(this.jif);
        } else {
            this.jf.getContentPane().add(this.js);
            this.windowsEvents = new WindowsEvents(this);
            this.jf.addWindowListener(this.windowsEvents);
            this.jf.addWindowFocusListener(this.windowsEvents);
            this.jf.setWindowFrame(this);
            this.content.getPanel().addPropertyChangeListener("GoBackEnabled", this.jf.getToolBar());
            this.content.getPanel().addPropertyChangeListener("GoForwardEnabled", this.jf.getToolBar());
            if (!Main.BATCHMODE) {
                this.jf.setVisible(true);
            }
        }
    }

    private void depopulateJFrame() {
        Job.checkSwingThread();
        if (TopLevel.isMDIMode()) {
            this.jif.getContentPane().remove(this.js);
            this.jif.removeInternalFrameListener(this.internalWindowsEvents);
            this.jif.removeInternalFrameListener(TopLevel.getCurrentJFrame().getToolBar());
            this.content.getPanel().removePropertyChangeListener(TopLevel.getCurrentJFrame().getToolBar());
        } else {
            this.jf.getContentPane().remove(this.js);
            this.jf.removeWindowListener(this.windowsEvents);
            this.jf.removeWindowFocusListener(this.windowsEvents);
            this.jf.setWindowFrame(null);
            this.content.getPanel().removePropertyChangeListener("GoBackEnabled", this.jf.getToolBar());
            this.content.getPanel().removePropertyChangeListener("GoForwardEnabled", this.jf.getToolBar());
        }
    }

    public void setCellWindow(Cell cell) {
        if (cell != null && cell.getView().isTextView()) {
            if (!(this.getContent() instanceof TextWindow)) {
                this.getContent().finished();
                this.content = new TextWindow(cell, this);
                int i = this.js.getDividerLocation();
                this.js.setRightComponent(this.content.getPanel());
                this.js.setDividerLocation(i);
                this.content.fillScreen();
                return;
            }
        } else if (!(this.getContent() instanceof EditWindow)) {
            this.getContent().finished();
            this.content = EditWindow.CreateElectricDoc(cell, this);
            int i = this.js.getDividerLocation();
            this.js.setRightComponent(this.content.getPanel());
            this.js.setDividerLocation(i);
            this.content.fillScreen();
            return;
        }
        this.content.setCell(cell, VarContext.globalContext);
        this.currentCellChanged();
    }

    public void moveEditWindow(GraphicsConfiguration gc) {
        if (TopLevel.isMDIMode()) {
            return;
        }
        this.jf.setVisible(false);
        this.depopulateJFrame();
        TopLevel oldFrame = this.jf;
        oldFrame.finished();
        Cell cell = this.content.getCell();
        String cellDescription = cell == null ? "no cell" : cell.describe();
        this.createJFrame(cellDescription, gc);
        this.populateJFrame();
        this.content.fireCellHistoryStatus();
    }

    public static void wantToRedoLibraryTree() {
    }

    public static void wantToRedoJobTree() {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    WindowFrame.wantToRedoJobTree();
                }
            });
            return;
        }
        Iterator it = WindowFrame.getWindows();
        while (it.hasNext()) {
            WindowFrame wf = (WindowFrame)it.next();
            wf.wantToRedoJobTree = true;
            wf.redoExplorerTreeIfRequested();
        }
    }

    public static void wantToRedoErrorTree() {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    WindowFrame.wantToRedoErrorTree();
                }
            });
            return;
        }
        Iterator it = WindowFrame.getWindows();
        while (it.hasNext()) {
            WindowFrame wf = (WindowFrame)it.next();
            wf.wantToRedoErrorTree = true;
            wf.redoExplorerTreeIfRequested();
        }
    }

    public void wantToRedoSignalTree() {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    WindowFrame.this.wantToRedoSignalTree();
                }
            });
            return;
        }
        this.wantToRedoSignalTree = true;
        this.content.loadExplorerTree(this.rootNode);
        this.redoExplorerTreeIfRequested();
    }

    public void redoExplorerTreeIfRequested() {
        Job.checkSwingThread();
        if (!(this.wantToRedoLibraryTree || this.wantToRedoJobTree || this.wantToRedoErrorTree || this.wantToRedoSignalTree)) {
            return;
        }
        HashMap expanded = new HashMap();
        this.recursivelyCache(expanded, new TreePath(this.rootNode), true);
        if (this.wantToRedoLibraryTree) {
            this.libraryExplorerNode = ExplorerTree.makeLibraryTree();
        }
        if (this.wantToRedoJobTree) {
            this.jobExplorerNode = Job.getExplorerTree();
        }
        if (this.wantToRedoErrorTree) {
            this.errorExplorerNode = ErrorLogger.getExplorerTree();
        }
        this.wantToRedoSignalTree = false;
        this.wantToRedoErrorTree = false;
        this.wantToRedoJobTree = false;
        this.wantToRedoLibraryTree = false;
        this.rootNode.removeAllChildren();
        if (this.libraryExplorerNode != null) {
            this.rootNode.add(this.libraryExplorerNode);
        }
        if (this.signalExplorerNode != null) {
            this.rootNode.add(this.signalExplorerNode);
        }
        if (this.sweepExplorerNode != null) {
            this.rootNode.add(this.sweepExplorerNode);
        }
        this.rootNode.add(this.jobExplorerNode);
        this.rootNode.add(this.errorExplorerNode);
        this.tree.treeDidChange();
        this.treeModel.reload();
        this.recursivelyCache(expanded, new TreePath(this.rootNode), false);
    }

    private void recursivelyCache(HashMap expanded, TreePath path, boolean cache) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
        Object obj = node.getUserObject();
        int numChildren = node.getChildCount();
        if (numChildren == 0) {
            return;
        }
        if (cache) {
            if (this.tree.isExpanded(path)) {
                expanded.put(obj, obj);
            }
        } else if (expanded.get(obj) != null) {
            this.tree.expandPath(path);
        }
        for (int i = 0; i < numChildren; ++i) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)node.getChildAt(i);
            TreePath descentPath = path.pathByAddingChild(child);
            if (descentPath == null) continue;
            this.recursivelyCache(expanded, descentPath, cache);
        }
    }

    public WindowContent getContent() {
        return this.content;
    }

    public static WindowFrame getCurrentWindowFrame() {
        return WindowFrame.getCurrentWindowFrame(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WindowFrame getCurrentWindowFrame(boolean makeNewFrame) {
        List list = windowList;
        synchronized (list) {
            if (curWindowFrame == null && makeNewFrame) {
                Iterator it = windowList.iterator();
                while (it.hasNext()) {
                    curWindowFrame = (WindowFrame)it.next();
                }
                if (curWindowFrame == null) {
                    curWindowFrame = WindowFrame.createEditWindow(null);
                }
            }
            return curWindowFrame;
        }
    }

    public static void setListener(EventListener listener) {
        curMouseListener = (MouseListener)listener;
        curMouseMotionListener = (MouseMotionListener)listener;
        curMouseWheelListener = (MouseWheelListener)listener;
        curKeyListener = (KeyListener)listener;
    }

    public static EventListener getListener() {
        return curMouseListener;
    }

    public static Cell getCurrentCell() {
        if (Main.BATCHMODE) {
            Library lib = Library.getCurrent();
            if (lib == null) {
                return null;
            }
            return lib.getCurCell();
        }
        WindowFrame wf = WindowFrame.getCurrentWindowFrame(false);
        if (wf == null) {
            return null;
        }
        return wf.getContent().getCell();
    }

    public static Cell needCurCell() {
        Cell curCell = WindowFrame.getCurrentCell();
        if (curCell == null) {
            System.out.println("There is no current cell for this operation.  To create one, use the 'New Cell' command from the 'Cell' menu.");
        }
        return curCell;
    }

    public void setCursor(Cursor cursor) {
        if (!TopLevel.isMDIMode()) {
            this.jf.setCursor(cursor);
        }
        this.js.setCursor(cursor);
        this.content.getPanel().setCursor(cursor);
    }

    public static void removeLibraryReferences(Library lib) {
        Iterator it = WindowFrame.getWindows();
        while (it.hasNext()) {
            WindowFrame wf = (WindowFrame)it.next();
            WindowContent content = wf.getContent();
            Cell cell = content.getCell();
            if (cell != null && cell.getLibrary() == lib) {
                content.setCell(null, null);
            }
            content.fullRepaint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setCurrentWindowFrame(WindowFrame wf) {
        List list = windowList;
        synchronized (list) {
            if (wf.finished) {
                return;
            }
            curWindowFrame = wf;
            windowList.remove(wf);
            windowList.add(wf);
        }
        if (wf != null) {
            Highlighter highlighter;
            wf.currentCellChanged();
            if (wf.getContent() != null && (highlighter = wf.getContent().getHighlighter()) != null) {
                highlighter.gainedFocus();
            }
        }
        WindowFrame.wantToRedoTitleNames();
    }

    private void currentCellChanged() {
        if (this != WindowFrame.getCurrentWindowFrame(false)) {
            return;
        }
        Cell cell = this.getContent().getCell();
        if (cell != null) {
            cell.getLibrary().setCurCell(cell);
            PaletteFrame.autoTechnologySwitch(cell);
        }
    }

    public static void wantToRedoTitleNames() {
        Iterator it = WindowFrame.getWindows();
        while (it.hasNext()) {
            WindowFrame w = (WindowFrame)it.next();
            WindowContent content = w.getContent();
            if (content == null) continue;
            content.setWindowTitle();
        }
    }

    public void setWindowSize(Rectangle frameRect) {
        Dimension frameSize = new Dimension(frameRect.width, frameRect.height);
        if (TopLevel.isMDIMode()) {
            this.jif.setSize(frameSize);
            this.jif.setLocation(frameRect.x, frameRect.y);
        } else {
            this.jf.setSize(frameSize);
            this.jf.setLocation(frameRect.x, frameRect.y);
            this.jf.validate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finished() {
        if (TopLevel.isMDIMode()) {
            this.jif.setVisible(false);
        }
        List list = windowList;
        synchronized (list) {
            if (windowList.size() <= 1 && !TopLevel.isMDIMode() && TopLevel.getOperatingSystem() != TopLevel.OS.MACINTOSH) {
                FileMenu.quitCommand();
                return;
            }
            windowList.remove(this);
            this.finished = true;
            if (curWindowFrame == this) {
                curWindowFrame = null;
            }
        }
        this.content.finished();
        if (!TopLevel.isMDIMode()) {
            this.jf.finished();
        }
    }

    public WaveformWindow getWaveformWindow() {
        return (WaveformWindow)this.content;
    }

    public JTextArea getTextEditWindow() {
        return this.textWnd;
    }

    public ExplorerTree getExplorerTree() {
        return this.tree;
    }

    public TopLevel getFrame() {
        if (TopLevel.isMDIMode()) {
            return TopLevel.getCurrentJFrame();
        }
        return this.jf;
    }

    public boolean generatedEvent(AWTEvent e) {
        if (e instanceof InternalFrameEvent) {
            JInternalFrame source = ((InternalFrameEvent)e).getInternalFrame();
            return source == this.jif;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getNumWindows() {
        List list = windowList;
        synchronized (list) {
            return windowList.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Iterator getWindows() {
        ArrayList listCopy = new ArrayList();
        List list = windowList;
        synchronized (list) {
            listCopy.addAll(windowList);
        }
        return listCopy.iterator();
    }

    public String composeTitle(Cell cell, String prefix, int pageNo) {
        StringBuffer title = new StringBuffer();
        if (cell != null) {
            title.append(prefix + cell.libDescribe());
            if (cell.isMultiPage()) {
                title.append(" - Page " + (pageNo + 1));
            }
            if (cell.getLibrary() != Library.getCurrent()) {
                title.append(" - Current library: " + Library.getCurrent().getName());
            }
        } else {
            title.append("***NONE***");
        }
        return title.toString();
    }

    public void setTitle(String title) {
        String curTitle = this.getTitle();
        if (title.equals(curTitle)) {
            return;
        }
        if (TopLevel.isMDIMode()) {
            if (this.jif != null) {
                this.jif.setTitle(title);
            }
        } else if (this.jf != null) {
            this.jf.setTitle(title);
        }
    }

    public String getTitle() {
        if (TopLevel.isMDIMode()) {
            if (this.jif != null) {
                return this.jif.getTitle();
            }
        } else if (this.jf != null) {
            return this.jf.getTitle();
        }
        return "";
    }

    private static void removeUIBinding(JComponent comp, KeyStroke key) {
        WindowFrame.removeUIBinding(comp.getInputMap(1), key);
        WindowFrame.removeUIBinding(comp.getInputMap(0), key);
        WindowFrame.removeUIBinding(comp.getInputMap(2), key);
    }

    private static void removeUIBinding(InputMap map, KeyStroke key) {
        if (map == null) {
            return;
        }
        map.remove(key);
        WindowFrame.removeUIBinding(map.getParent(), key);
    }

    private static class LibraryTreeUpdater
    implements DatabaseChangeListener {
        private LibraryTreeUpdater() {
            Undo.addDatabaseChangeListener(this);
        }

        private void updateLibraryTrees() {
            Iterator it = WindowFrame.getWindows();
            while (it.hasNext()) {
                WindowFrame frame = (WindowFrame)it.next();
                frame.wantToRedoLibraryTree = true;
                frame.redoExplorerTreeIfRequested();
            }
        }

        public void databaseEndChangeBatch(Undo.ChangeBatch batch) {
            boolean changed = false;
            Iterator it = batch.getChanges();
            while (it.hasNext()) {
                Undo.Change change = (Undo.Change)it.next();
                if (change.getType() != Undo.Type.LIBRARYKILL && change.getType() != Undo.Type.LIBRARYNEW && change.getType() != Undo.Type.CELLKILL && change.getType() != Undo.Type.CELLNEW && change.getType() != Undo.Type.CELLGROUPMOD && (change.getType() != Undo.Type.OBJECTRENAME || !(change.getObject() instanceof Cell)) && (change.getType() != Undo.Type.VARIABLENEW || !(change.getObject() instanceof Cell) || ((Variable)change.getO1()).getKey() != Cell.MULTIPAGE_COUNT_KEY)) continue;
                changed = true;
                break;
            }
            if (changed) {
                this.updateLibraryTrees();
            }
        }

        public void databaseChanged(Undo.Change evt) {
        }

        public boolean isGUIListener() {
            return true;
        }
    }

    static class InternalWindowsEvents
    extends InternalFrameAdapter {
        WeakReference wf;

        InternalWindowsEvents(WindowFrame wf) {
            this.wf = new WeakReference<WindowFrame>(wf);
        }

        public void internalFrameClosing(InternalFrameEvent evt) {
            ((WindowFrame)this.wf.get()).finished();
        }

        public void internalFrameActivated(InternalFrameEvent evt) {
            WindowFrame.setCurrentWindowFrame((WindowFrame)this.wf.get());
        }
    }

    static class WindowsEvents
    extends WindowAdapter {
        WeakReference wf;

        WindowsEvents(WindowFrame wf) {
            this.wf = new WeakReference<WindowFrame>(wf);
        }

        public void windowActivated(WindowEvent evt) {
            WindowFrame.setCurrentWindowFrame((WindowFrame)this.wf.get());
        }

        public void windowClosing(WindowEvent evt) {
            ((WindowFrame)this.wf.get()).finished();
        }
    }
}

