/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs;

import com.sun.electric.database.change.DatabaseChangeListener;
import com.sun.electric.database.change.Undo;
import com.sun.electric.database.geometry.DBMath;
import com.sun.electric.database.geometry.EGraphics;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.prototype.ArcProto;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Connection;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.SizeOffset;
import com.sun.electric.technology.TransistorSize;
import com.sun.electric.technology.technologies.Artwork;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.technology.technologies.MoCMOS;
import com.sun.electric.technology.technologies.Schematics;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.user.Highlight;
import com.sun.electric.tool.user.HighlightListener;
import com.sun.electric.tool.user.Highlighter;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.dialogs.Attributes;
import com.sun.electric.tool.user.dialogs.AttributesTable;
import com.sun.electric.tool.user.dialogs.EDialog;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.TopLevel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public class GetInfoNode
extends EDialog
implements HighlightListener,
DatabaseChangeListener {
    private static GetInfoNode theDialog = null;
    private NodeInst shownNode = null;
    private PortProto shownPort = null;
    private double initialXPos;
    private double initialYPos;
    private String initialXSize;
    private String initialYSize;
    private boolean initialMirrorX;
    private boolean initialMirrorY;
    private int initialRotation;
    private int initialPopupIndex;
    private Variable.Code initialListPopupEntry;
    private boolean initialEasyToSelect;
    private boolean initialInvisibleOutsideCell;
    private boolean initialLocked;
    private boolean initialExpansion;
    private String initialName;
    private String initialTextField;
    private String initialPopupEntry;
    private String initialListTextField;
    private DefaultListModel listModel;
    private JList list;
    private List allAttributes;
    private List portObjects;
    private boolean bigger;
    private boolean scalableTrans;
    private boolean swapXY;
    private AttributesTable attributesTable;
    private EditWindow wnd;
    private boolean changingValues = false;
    private static Preferences prefs = Preferences.userNodeForPackage(GetInfoNode.class);
    private JButton apply;
    private JRadioButton attributes;
    private JButton attributesButton;
    private JButton cancel;
    private JCheckBox easyToSelect;
    private JRadioButton expanded;
    private ButtonGroup expansion;
    private JCheckBox invisibleOutsideCell;
    private JLabel jLabel1;
    private JLabel jLabel3;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JTextField listEdit;
    private JLabel listEditLabel;
    private JLabel listEval;
    private JLabel listEvalLabel;
    private JScrollPane listPane;
    private JComboBox listPopup;
    private JLabel listPopupLabel;
    private JCheckBox locked;
    private JCheckBox mirrorX;
    private JCheckBox mirrorY;
    private JButton more;
    private JPanel moreStuffBottom;
    private JPanel moreStuffTop;
    private JTextField name;
    private JButton ok;
    private JComboBox popup;
    private JLabel popupLabel;
    private JRadioButton ports;
    private JTextField rotation;
    private JButton see;
    private ButtonGroup selection;
    private JTextField textField;
    private JLabel textFieldLabel;
    private JLabel type;
    private JRadioButton unexpanded;
    private JTextField xPos;
    private JTextField xSize;
    private JLabel xsizeLabel;
    private JTextField yPos;
    private JTextField ySize;
    private JLabel ysizeLabel;

    public static void showDialog() {
        if (theDialog == null) {
            TopLevel jf = TopLevel.isMDIMode() ? TopLevel.getCurrentJFrame() : null;
            theDialog = new GetInfoNode((Frame)jf, false);
        }
        theDialog.loadInfo();
        if (!theDialog.isVisible()) {
            theDialog.pack();
        }
        theDialog.setVisible(true);
    }

    public void highlightChanged(Highlighter which) {
        if (!this.isVisible()) {
            return;
        }
        this.loadInfo();
    }

    public void highlighterLostFocus(Highlighter highlighterGainedFocus) {
        if (!this.isVisible()) {
            return;
        }
        this.loadInfo();
    }

    public void databaseEndChangeBatch(Undo.ChangeBatch batch) {
        if (!this.isVisible()) {
            return;
        }
        boolean reload = false;
        Iterator it = batch.getChanges();
        while (it.hasNext()) {
            Undo.Change change = (Undo.Change)it.next();
            ElectricObject obj = change.getObject();
            if (obj != this.shownNode && obj != this.shownPort) continue;
            reload = true;
            break;
        }
        if (reload) {
            this.loadInfo();
        }
    }

    public void databaseChanged(Undo.Change change) {
    }

    public boolean isGUIListener() {
        return true;
    }

    private GetInfoNode(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.getRootPane().setDefaultButton(this.ok);
        this.setLocation(100, 50);
        Undo.addDatabaseChangeListener(this);
        this.bigger = prefs.getBoolean("GetInfoNode-bigger", false);
        int buttonSelected = prefs.getInt("GetInfoNode-buttonSelected", 0);
        if (!this.bigger) {
            this.getContentPane().remove(this.moreStuffTop);
            this.getContentPane().remove(this.listPane);
            this.getContentPane().remove(this.moreStuffBottom);
            this.more.setText("More");
            this.pack();
        } else {
            this.more.setText("Less");
        }
        this.listModel = new DefaultListModel();
        this.list = new JList(this.listModel);
        this.list.setSelectionMode(0);
        this.listPane.setViewportView(this.list);
        this.list.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                GetInfoNode.this.listClick();
            }
        });
        this.allAttributes = new ArrayList();
        this.portObjects = new ArrayList();
        this.attributesTable = new AttributesTable(null, true, false, false);
        Iterator it = Variable.Code.getCodes();
        while (it.hasNext()) {
            this.listPopup.addItem(it.next());
        }
        if (buttonSelected == 0) {
            this.ports.setSelected(true);
        }
        if (buttonSelected == 1) {
            this.attributes.setSelected(true);
        }
        this.loadInfo();
        this.finishInitialization();
    }

    protected void escapePressed() {
        this.cancelActionPerformed(null);
    }

    protected void loadInfo() {
        Variable var;
        EditWindow curWnd = EditWindow.getCurrent();
        if (this.wnd != curWnd && curWnd != null) {
            if (this.wnd != null) {
                this.wnd.getHighlighter().removeHighlightListener(this);
            }
            curWnd.getHighlighter().addHighlightListener(this);
            this.wnd = curWnd;
        }
        NodeInst ni = null;
        PortProto pp = null;
        int nodeCount = 0;
        if (this.wnd != null) {
            Iterator it = this.wnd.getHighlighter().getHighlights().iterator();
            while (it.hasNext()) {
                Highlight h = (Highlight)it.next();
                if (h.getType() != Highlight.Type.EOBJ) continue;
                ElectricObject eobj = h.getElectricObject();
                if (eobj instanceof PortInst) {
                    pp = ((PortInst)eobj).getPortProto();
                    eobj = ((PortInst)eobj).getNodeInst();
                }
                if (!(eobj instanceof NodeInst)) continue;
                ni = (NodeInst)eobj;
                ++nodeCount;
            }
        }
        if (nodeCount > 1) {
            ni = null;
        }
        if (ni == null) {
            if (this.shownNode != null) {
                this.type.setText("");
                this.name.setEditable(false);
                this.name.setText("");
                this.xSize.setEditable(false);
                this.xSize.setText("");
                this.ySize.setEditable(false);
                this.ySize.setText("");
                this.xPos.setEditable(false);
                this.xPos.setText("");
                this.yPos.setEditable(false);
                this.yPos.setText("");
                this.rotation.setEditable(false);
                this.rotation.setText("");
                this.mirrorX.setEnabled(false);
                this.mirrorX.setSelected(false);
                this.mirrorY.setEnabled(false);
                this.mirrorY.setSelected(false);
                this.apply.setEnabled(false);
                this.expanded.setEnabled(false);
                this.unexpanded.setEnabled(false);
                this.easyToSelect.setEnabled(false);
                this.easyToSelect.setSelected(false);
                this.invisibleOutsideCell.setEnabled(false);
                this.invisibleOutsideCell.setSelected(false);
                this.textFieldLabel.setText("");
                this.textField.setText("");
                this.textField.setEditable(false);
                this.popupLabel.setText("");
                this.popup.removeAllItems();
                this.popup.setEnabled(false);
                this.ports.setEnabled(false);
                this.attributes.setEnabled(false);
                this.attributesTable.setElectricObject(null);
                this.attributesTable.setEnabled(false);
                this.listPane.setEnabled(false);
                this.listModel.clear();
                this.locked.setEnabled(false);
                this.locked.setSelected(false);
                this.see.setEnabled(false);
                this.attributesButton.setEnabled(false);
                this.listEditLabel.setText("");
                this.listEdit.setEditable(false);
                this.listEdit.setText("");
                this.listPopupLabel.setText("");
                this.listPopup.setEnabled(false);
                this.listPopup.removeAllItems();
                this.shownNode = null;
                this.shownPort = null;
            }
            return;
        }
        this.shownNode = ni;
        this.shownPort = pp;
        this.focusClearOnTextField(this.name);
        NodeProto np = ni.getProto();
        this.name.setEditable(true);
        boolean sizeEditable = true;
        this.xPos.setEditable(true);
        this.yPos.setEditable(true);
        this.rotation.setEditable(true);
        this.mirrorX.setEnabled(true);
        this.mirrorY.setEnabled(true);
        this.apply.setEnabled(true);
        this.initialName = ni.getName();
        this.initialXPos = ni.getAnchorCenterX();
        this.initialYPos = ni.getAnchorCenterY();
        double initXSize = ni.getXSizeWithMirror();
        double initYSize = ni.getYSizeWithMirror();
        this.initialRotation = ni.getAngle();
        this.swapXY = false;
        if (this.initialRotation == 900 || this.initialRotation == 2700) {
            this.swapXY = true;
        }
        this.type.setText(np.describe());
        this.name.setText(this.initialName);
        this.xPos.setText(TextUtils.formatDouble(this.initialXPos));
        this.yPos.setText(TextUtils.formatDouble(this.initialYPos));
        boolean realMirrorX = initXSize < 0.0;
        boolean realMirrorY = initYSize < 0.0;
        SizeOffset so = ni.getSizeOffset();
        if (this.swapXY) {
            this.xSize.setText(TextUtils.formatDouble(Math.abs(initYSize) - so.getLowYOffset() - so.getHighYOffset()));
            this.ySize.setText(TextUtils.formatDouble(Math.abs(initXSize) - so.getLowXOffset() - so.getHighXOffset()));
            this.initialMirrorX = realMirrorY;
            this.initialMirrorY = realMirrorX;
        } else {
            this.xSize.setText(TextUtils.formatDouble(Math.abs(initXSize) - so.getLowXOffset() - so.getHighXOffset()));
            this.ySize.setText(TextUtils.formatDouble(Math.abs(initYSize) - so.getLowYOffset() - so.getHighYOffset()));
            this.initialMirrorX = realMirrorX;
            this.initialMirrorY = realMirrorY;
        }
        this.initialXSize = this.xSize.getText();
        this.initialYSize = this.ySize.getText();
        this.mirrorX.setSelected(this.initialMirrorX);
        this.mirrorY.setSelected(this.initialMirrorY);
        this.rotation.setText(TextUtils.formatDouble((double)this.initialRotation / 10.0));
        TransistorSize transSize = ni.getTransistorSize(null);
        if (transSize != null) {
            this.xsizeLabel.setText("Width:");
            this.ysizeLabel.setText("Length:");
            double width = transSize.getDoubleWidth();
            if (width == 0.0 && transSize.getWidth() != null) {
                this.xSize.setText(transSize.getWidth().toString());
            } else {
                this.xSize.setText(TextUtils.formatDouble(width));
            }
            double length = transSize.getDoubleLength();
            if (length == 0.0 && transSize.getLength() != null) {
                this.ySize.setText(transSize.getLength().toString());
            } else {
                this.ySize.setText(TextUtils.formatDouble(length));
            }
            this.initialXSize = this.xSize.getText();
            this.initialYSize = this.ySize.getText();
        } else {
            this.xsizeLabel.setText("X size:");
            this.ysizeLabel.setText("Y size:");
        }
        this.easyToSelect.setEnabled(true);
        this.invisibleOutsideCell.setEnabled(true);
        this.ports.setEnabled(true);
        this.attributes.setEnabled(true);
        this.attributesTable.setEnabled(true);
        this.listPane.setEnabled(true);
        this.locked.setEnabled(true);
        this.attributesButton.setEnabled(true);
        this.allAttributes.clear();
        Iterator it = ni.getVariables();
        while (it.hasNext()) {
            Variable var2 = (Variable)it.next();
            String name = var2.getKey().getName();
            if (!name.startsWith("ATTR_")) continue;
            AttValPair avp = new AttValPair();
            avp.key = var2.getKey();
            avp.trueName = var2.getTrueName();
            avp.value = var2.getObject().toString();
            avp.code = var2.isCode();
            this.allAttributes.add(avp);
        }
        this.attributes.setEnabled(this.allAttributes.size() != 0);
        this.attributesTable.setEnabled(this.allAttributes.size() != 0);
        this.attributesTable.setElectricObject(ni);
        this.showProperList();
        this.textFieldLabel.setText("");
        this.textField.setText("");
        this.textField.setEditable(false);
        this.popupLabel.setText("");
        this.popup.removeAllItems();
        this.popup.setEnabled(false);
        boolean holdsOutline = false;
        Point2D[] outline = ni.getTrace();
        if (outline != null) {
            holdsOutline = true;
            sizeEditable = false;
        }
        this.initialTextField = null;
        boolean lengthEditable = false;
        if (ni.isSerpentineTransistor()) {
            lengthEditable = true;
        }
        if (np instanceof Cell) {
            this.expanded.setEnabled(true);
            this.unexpanded.setEnabled(true);
            this.initialExpansion = ni.isExpanded();
            if (this.initialExpansion) {
                this.expanded.setSelected(true);
            } else {
                this.unexpanded.setSelected(true);
            }
            sizeEditable = false;
        } else {
            this.expanded.setEnabled(false);
            this.unexpanded.setEnabled(false);
        }
        if (sizeEditable) {
            this.xSize.setEditable(true);
            this.ySize.setEditable(true);
        } else {
            this.xSize.setEditable(false);
            this.ySize.setEditable(lengthEditable);
        }
        this.initialInvisibleOutsideCell = ni.isVisInside();
        this.invisibleOutsideCell.setSelected(this.initialInvisibleOutsideCell);
        this.initialEasyToSelect = !ni.isHardSelect();
        this.easyToSelect.setSelected(this.initialEasyToSelect);
        if (np instanceof Cell && !User.isEasySelectionOfCellInstances()) {
            this.easyToSelect.setEnabled(false);
        }
        this.initialLocked = ni.isLocked();
        this.locked.setSelected(this.initialLocked);
        PrimitiveNode.Function fun = ni.getFunction();
        if (!(np != Schematics.tech.transistorNode && np != Schematics.tech.transistor4Node || ni.isFET())) {
            this.textField.setEditable(true);
            this.textFieldLabel.setText("Area:");
            TransistorSize d = ni.getTransistorSize(null);
            this.initialTextField = Double.toString(d.getDoubleWidth());
            this.textField.setText(this.initialTextField);
            this.popupLabel.setText("Transistor type:");
            this.popup.addItem(fun.getName());
        }
        this.scalableTrans = false;
        if (np instanceof PrimitiveNode && np.getTechnology() == MoCMOS.tech && (np.getName().equals("P-Transistor-Scalable") || np.getName().equals("N-Transistor-Scalable"))) {
            this.scalableTrans = true;
        }
        if (this.scalableTrans) {
            this.popupLabel.setText("Contacts:");
            this.popup.addItem("Top & Bottom / normal spacing");
            this.popup.addItem("Top & Bottom / half-unit closer");
            this.popup.addItem("Only Bottom / normal spacing");
            this.popup.addItem("Only Bottom / half-unit closer");
            this.popup.addItem("None");
            var = ni.getVar(MoCMOS.TRANS_CONTACT, String.class);
            int numContacts = 2;
            boolean insetContacts = false;
            if (var != null) {
                String pt = (String)var.getObject();
                for (int i = 0; i < pt.length(); ++i) {
                    char chr = pt.charAt(i);
                    if (chr == '0' || chr == '1' || chr == '2') {
                        numContacts = chr - 48;
                        continue;
                    }
                    if (chr != 'i' && chr != 'I') continue;
                    insetContacts = true;
                }
            }
            this.initialPopupIndex = (2 - numContacts) * 2;
            if (insetContacts && numContacts > 0) {
                ++this.initialPopupIndex;
            }
            this.popup.setSelectedIndex(this.initialPopupIndex);
            this.popup.setEnabled(true);
            this.textFieldLabel.setText("Width:");
            var = ni.getVar(Schematics.ATTR_WIDTH);
            double width = ni.getXSize() - so.getLowXOffset() - so.getHighXOffset();
            if (var != null) {
                width = TextUtils.atof(var.getPureValue(-1));
            }
            this.initialTextField = Double.toString(width);
            this.textField.setEditable(true);
            this.textField.setText(this.initialTextField);
        }
        if (fun == PrimitiveNode.Function.RESIST) {
            this.textFieldLabel.setText("Resistance:");
            var = ni.getVar(Schematics.SCHEM_RESISTANCE);
            this.initialTextField = var == null ? "0" : new String(var.getObject().toString());
            this.textField.setEditable(true);
            this.textField.setText(this.initialTextField);
        }
        if (fun == PrimitiveNode.Function.CAPAC || fun == PrimitiveNode.Function.ECAPAC) {
            if (fun == PrimitiveNode.Function.ECAPAC) {
                this.textFieldLabel.setText("Electrolytic cap:");
            } else {
                this.textFieldLabel.setText("Capacitance:");
            }
            var = ni.getVar(Schematics.SCHEM_CAPACITANCE);
            this.initialTextField = var == null ? "0" : new String(var.getObject().toString());
            this.textField.setEditable(true);
            this.textField.setText(this.initialTextField);
        }
        if (fun == PrimitiveNode.Function.INDUCT) {
            this.textFieldLabel.setText("Inductance:");
            var = ni.getVar(Schematics.SCHEM_INDUCTANCE);
            this.initialTextField = var == null ? "0" : new String(var.getObject().toString());
            this.textField.setEditable(true);
            this.textField.setText(this.initialTextField);
        }
        if (np == Schematics.tech.bboxNode) {
            this.textFieldLabel.setText("Function:");
            var = ni.getVar(Schematics.SCHEM_FUNCTION);
            this.initialTextField = var == null ? "" : new String(var.getObject().toString());
            this.textField.setEditable(true);
            this.textField.setText(this.initialTextField);
        }
        if (fun.isFlipFlop()) {
            this.popupLabel.setText("Flip-flop type:");
            this.popup.addItem(fun.getName());
        }
        if (np == Schematics.tech.globalNode) {
            this.textFieldLabel.setText("Global name:");
            var = ni.getVar(Schematics.SCHEM_GLOBAL_NAME);
            this.initialTextField = var == null ? "" : new String(var.getObject().toString());
            this.textField.setEditable(true);
            this.textField.setText(this.initialTextField);
            this.popupLabel.setText("Characteristics:");
            List characteristics = PortCharacteristic.getOrderedCharacteristics();
            Iterator it2 = characteristics.iterator();
            while (it2.hasNext()) {
                PortCharacteristic ch = (PortCharacteristic)it2.next();
                this.popup.addItem(ch.getName());
            }
            PortCharacteristic ch = PortCharacteristic.findCharacteristic(ni.getTechSpecific());
            this.initialPopupEntry = ch.getName();
            this.popup.setSelectedItem(this.initialPopupEntry);
            this.popup.setEnabled(true);
        }
        if (np instanceof PrimitiveNode && np.getTechnology() == Artwork.tech) {
            this.popupLabel.setText("Color:");
            int[] colors = EGraphics.getColorIndices();
            for (int i = 0; i < colors.length; ++i) {
                this.popup.addItem(EGraphics.getColorIndexName(colors[i]));
            }
            int index = 6;
            Variable var3 = ni.getVar(Artwork.ART_COLOR);
            if (var3 != null) {
                index = (Integer)var3.getObject();
            }
            this.initialPopupEntry = EGraphics.getColorIndexName(index);
            this.popup.setSelectedItem(this.initialPopupEntry);
            this.popup.setEnabled(true);
        }
        if (np == Artwork.tech.circleNode || np == Artwork.tech.thickCircleNode) {
            double[] arcData = ni.getArcDegrees();
            double start = DBMath.round(arcData[0] * 180.0 / Math.PI);
            double curvature = DBMath.round(arcData[1] * 180.0 / Math.PI);
            if (start != 0.0) {
                this.textFieldLabel.setText("Offset angle / Degrees of circle:");
                this.initialTextField = new String(start + " / " + curvature);
            } else {
                this.textFieldLabel.setText("Degrees of circle:");
                this.initialTextField = curvature == 0.0 ? "360" : new String(Double.toString(curvature));
            }
            this.textField.setEditable(true);
            this.textField.setText(this.initialTextField);
        }
        this.focusOnTextField(this.name);
    }

    private void showProperList() {
        this.listModel.clear();
        this.portObjects.clear();
        if (this.ports.isSelected()) {
            NodeProto np = this.shownNode.getProto();
            Iterator it = this.shownNode.getPortInsts();
            while (it.hasNext()) {
                Export e;
                Connection con;
                PortInst pi = (PortInst)it.next();
                PortProto pp = pi.getPortProto();
                PortCharacteristic ch = pp.getCharacteristic();
                String description = ch == PortCharacteristic.UNKNOWN ? "Port " : ch.getName() + " port ";
                description = description + pp.getName() + " connects to";
                ArcProto[] connList = pp.getBasePort().getConnections();
                int count = 0;
                for (int i = 0; i < connList.length; ++i) {
                    ArcProto ap = connList[i];
                    if ((np instanceof Cell || np.getTechnology() != Generic.tech) && ap.getTechnology() == Generic.tech) continue;
                    if (count > 0) {
                        description = description + ",";
                    }
                    description = description + " " + ap.getName();
                    ++count;
                }
                boolean moreInfo = false;
                if (pp == this.shownPort) {
                    moreInfo = true;
                }
                Iterator aIt = this.shownNode.getConnections();
                while (aIt.hasNext()) {
                    con = (Connection)aIt.next();
                    if (con.getPortInst() != pi) continue;
                    moreInfo = true;
                    break;
                }
                Iterator eIt = this.shownNode.getExports();
                while (eIt.hasNext()) {
                    e = (Export)eIt.next();
                    if (e.getOriginalPort() != pi) continue;
                    moreInfo = true;
                    break;
                }
                if (moreInfo) {
                    description = description + ":";
                }
                this.listModel.addElement(description);
                this.portObjects.add(null);
                if (pp == this.shownPort) {
                    this.listModel.addElement("  Highlighted port");
                    this.portObjects.add(null);
                }
                aIt = this.shownNode.getConnections();
                while (aIt.hasNext()) {
                    con = (Connection)aIt.next();
                    if (con.getPortInst() != pi) continue;
                    ArcInst ai = con.getArc();
                    description = "  Connected at (" + con.getLocation().getX() + "," + con.getLocation().getY() + ") to " + ai.describe() + " arc";
                    this.listModel.addElement(description);
                    this.portObjects.add(ai);
                }
                eIt = this.shownNode.getExports();
                while (eIt.hasNext()) {
                    e = (Export)eIt.next();
                    if (e.getOriginalPort() != pi) continue;
                    description = "  Available as " + e.getCharacteristic().getName() + " export '" + e.getName() + "'";
                    this.listModel.addElement(description);
                    this.portObjects.add(null);
                }
            }
            this.see.setEnabled(true);
            this.listEdit.setEditable(false);
            this.listPopup.setEnabled(false);
            this.listEdit.setText("");
            this.listEditLabel.setText("");
            this.listPopupLabel.setText("");
            this.listEvalLabel.setText("");
            this.listEval.setText("");
            this.listPane.setViewportView(this.list);
            this.list.setSelectedIndex(0);
            this.listClick();
        }
        if (this.attributes.isSelected()) {
            this.listPane.setViewportView(this.attributesTable);
        }
    }

    private void listClick() {
        int index = this.list.getSelectedIndex();
        if (this.attributes.isSelected()) {
            AttValPair avp = (AttValPair)this.allAttributes.get(index);
            this.listEditLabel.setText("Attribute '" + avp.trueName + "'");
            this.initialListTextField = new String(avp.value);
            this.listEdit.setText(this.initialListTextField);
            if (avp.code) {
                this.initialListPopupEntry = Variable.Code.JAVA;
                this.listEvalLabel.setText("Evaluation:");
                Variable var = this.shownNode.getVar(avp.key);
                this.listEval.setText(var.describe(-1, VarContext.globalContext, this.shownNode));
            } else {
                this.initialListPopupEntry = Variable.Code.NONE;
                this.listEvalLabel.setText("");
                this.listEval.setText("");
            }
            this.listPopup.setSelectedItem(this.initialListPopupEntry);
        }
    }

    private void initComponents() {
        this.expansion = new ButtonGroup();
        this.selection = new ButtonGroup();
        this.jLabel1 = new JLabel();
        this.name = new JTextField();
        this.cancel = new JButton();
        this.ok = new JButton();
        this.type = new JLabel();
        this.jLabel3 = new JLabel();
        this.xsizeLabel = new JLabel();
        this.xSize = new JTextField();
        this.ysizeLabel = new JLabel();
        this.ySize = new JTextField();
        this.jLabel6 = new JLabel();
        this.xPos = new JTextField();
        this.jLabel7 = new JLabel();
        this.yPos = new JTextField();
        this.jLabel8 = new JLabel();
        this.rotation = new JTextField();
        this.mirrorX = new JCheckBox();
        this.more = new JButton();
        this.apply = new JButton();
        this.mirrorY = new JCheckBox();
        this.moreStuffTop = new JPanel();
        this.expanded = new JRadioButton();
        this.unexpanded = new JRadioButton();
        this.easyToSelect = new JCheckBox();
        this.invisibleOutsideCell = new JCheckBox();
        this.textFieldLabel = new JLabel();
        this.textField = new JTextField();
        this.popupLabel = new JLabel();
        this.popup = new JComboBox();
        this.ports = new JRadioButton();
        this.attributes = new JRadioButton();
        this.moreStuffBottom = new JPanel();
        this.locked = new JCheckBox();
        this.see = new JButton();
        this.attributesButton = new JButton();
        this.listEditLabel = new JLabel();
        this.listEdit = new JTextField();
        this.listPopupLabel = new JLabel();
        this.listPopup = new JComboBox();
        this.listEvalLabel = new JLabel();
        this.listEval = new JLabel();
        this.listPane = new JScrollPane();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Node Properties");
        this.setName("");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                GetInfoNode.this.closeDialog(evt);
            }
        });
        this.jLabel1.setText("Type:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.jLabel1, gridBagConstraints);
        this.name.setPreferredSize(new Dimension(250, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.name, gridBagConstraints);
        this.cancel.setText("Cancel");
        this.cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GetInfoNode.this.cancelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.cancel, gridBagConstraints);
        this.ok.setText("OK");
        this.ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GetInfoNode.this.okActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.ok, gridBagConstraints);
        this.type.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.type, gridBagConstraints);
        this.jLabel3.setText("Name:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.getContentPane().add((Component)this.jLabel3, gridBagConstraints);
        this.xsizeLabel.setText("X size:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.getContentPane().add((Component)this.xsizeLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.xSize, gridBagConstraints);
        this.ysizeLabel.setText("Y size:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.getContentPane().add((Component)this.ysizeLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.ySize, gridBagConstraints);
        this.jLabel6.setText("X position:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.getContentPane().add((Component)this.jLabel6, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.xPos, gridBagConstraints);
        this.jLabel7.setText("Y position:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.getContentPane().add((Component)this.jLabel7, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.yPos, gridBagConstraints);
        this.jLabel8.setText("Rotation:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.getContentPane().add((Component)this.jLabel8, gridBagConstraints);
        this.rotation.setColumns(6);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        gridBagConstraints.anchor = 17;
        this.getContentPane().add((Component)this.rotation, gridBagConstraints);
        this.mirrorX.setText("Mirror X");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.mirrorX, gridBagConstraints);
        this.more.setText("More");
        this.more.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GetInfoNode.this.moreActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.more, gridBagConstraints);
        this.apply.setText("Apply");
        this.apply.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GetInfoNode.this.applyActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.apply, gridBagConstraints);
        this.mirrorY.setText("Mirror Y");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.mirrorY, gridBagConstraints);
        this.moreStuffTop.setLayout(new GridBagLayout());
        this.expanded.setText("Expanded");
        this.expansion.add(this.expanded);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.moreStuffTop.add((Component)this.expanded, gridBagConstraints);
        this.unexpanded.setText("Unexpanded");
        this.expansion.add(this.unexpanded);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.moreStuffTop.add((Component)this.unexpanded, gridBagConstraints);
        this.easyToSelect.setText("Easy to Select");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.moreStuffTop.add((Component)this.easyToSelect, gridBagConstraints);
        this.invisibleOutsideCell.setText("Invisible Outside Cell");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.moreStuffTop.add((Component)this.invisibleOutsideCell, gridBagConstraints);
        this.textFieldLabel.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.moreStuffTop.add((Component)this.textFieldLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.moreStuffTop.add((Component)this.textField, gridBagConstraints);
        this.popupLabel.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.moreStuffTop.add((Component)this.popupLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.moreStuffTop.add((Component)this.popup, gridBagConstraints);
        this.ports.setText("Ports:");
        this.selection.add(this.ports);
        this.ports.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GetInfoNode.this.portsActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(4, 4, 0, 4);
        this.moreStuffTop.add((Component)this.ports, gridBagConstraints);
        this.attributes.setText("Attributes:");
        this.selection.add(this.attributes);
        this.attributes.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GetInfoNode.this.attributesActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(4, 4, 0, 4);
        this.moreStuffTop.add((Component)this.attributes, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)this.moreStuffTop, gridBagConstraints);
        this.moreStuffBottom.setLayout(new GridBagLayout());
        this.locked.setText("Locked");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.moreStuffBottom.add((Component)this.locked, gridBagConstraints);
        this.see.setText("See");
        this.see.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GetInfoNode.this.seeActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.moreStuffBottom.add((Component)this.see, gridBagConstraints);
        this.attributesButton.setText("Attributes");
        this.attributesButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GetInfoNode.this.attributesButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.moreStuffBottom.add((Component)this.attributesButton, gridBagConstraints);
        this.listEditLabel.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.moreStuffBottom.add((Component)this.listEditLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.moreStuffBottom.add((Component)this.listEdit, gridBagConstraints);
        this.listPopupLabel.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.moreStuffBottom.add((Component)this.listPopupLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.moreStuffBottom.add((Component)this.listPopup, gridBagConstraints);
        this.listEvalLabel.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.moreStuffBottom.add((Component)this.listEvalLabel, gridBagConstraints);
        this.listEval.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.moreStuffBottom.add((Component)this.listEval, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)this.moreStuffBottom, gridBagConstraints);
        this.listPane.setMinimumSize(new Dimension(200, 100));
        this.listPane.setPreferredSize(new Dimension(200, 100));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.getContentPane().add((Component)this.listPane, gridBagConstraints);
        this.pack();
    }

    private void attributesButtonActionPerformed(ActionEvent evt) {
        Attributes.showDialog();
    }

    private void moreActionPerformed(ActionEvent evt) {
        boolean bl = this.bigger = !this.bigger;
        if (this.bigger) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 6;
            gridBagConstraints.gridwidth = 4;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            this.getContentPane().add((Component)this.moreStuffTop, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 7;
            gridBagConstraints.gridwidth = 4;
            gridBagConstraints.fill = 1;
            gridBagConstraints.insets = new Insets(0, 4, 4, 4);
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            this.getContentPane().add((Component)this.listPane, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 8;
            gridBagConstraints.gridwidth = 4;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            this.getContentPane().add((Component)this.moreStuffBottom, gridBagConstraints);
            this.more.setText("Less");
        } else {
            this.getContentPane().remove(this.moreStuffTop);
            this.getContentPane().remove(this.listPane);
            this.getContentPane().remove(this.moreStuffBottom);
            this.more.setText("More");
        }
        this.pack();
    }

    private void seeActionPerformed(ActionEvent evt) {
        if (!GetInfoNode.theDialog.ports.isSelected()) {
            return;
        }
        int currentIndex = GetInfoNode.theDialog.list.getSelectedIndex();
        ArcInst ai = (ArcInst)GetInfoNode.theDialog.portObjects.get(currentIndex);
        if (ai == null) {
            return;
        }
        NodeInst ni = this.shownNode;
        if (this.wnd != null) {
            Highlighter highlighter = this.wnd.getHighlighter();
            highlighter.clear();
            highlighter.addElectricObject(ni, ni.getParent());
            highlighter.addElectricObject(ai, ai.getParent());
            highlighter.finished();
        }
    }

    private void attributesActionPerformed(ActionEvent evt) {
        theDialog.showProperList();
    }

    private void portsActionPerformed(ActionEvent evt) {
        theDialog.showProperList();
    }

    private void applyActionPerformed(ActionEvent evt) {
        if (this.shownNode == null) {
            return;
        }
        ChangeNode job = new ChangeNode(this.shownNode, this);
        this.attributesTable.applyChanges();
    }

    private void okActionPerformed(ActionEvent evt) {
        this.applyActionPerformed(evt);
        this.closeDialog(null);
    }

    private void cancelActionPerformed(ActionEvent evt) {
        this.closeDialog(null);
    }

    private void closeDialog(WindowEvent evt) {
        prefs.putBoolean("GetInfoNode-bigger", this.bigger);
        if (this.ports.isSelected()) {
            prefs.putInt("GetInfoNode-buttonSelected", 0);
        }
        if (this.attributes.isSelected()) {
            prefs.putInt("GetInfoNode-buttonSelected", 1);
        }
        this.setVisible(false);
    }

    private static class ChangeNode
    extends Job {
        NodeInst ni;
        GetInfoNode dialog;

        protected ChangeNode(NodeInst ni, GetInfoNode dialog) {
            super("Modify Node", User.tool, Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.ni = ni;
            this.dialog = dialog;
            this.startJob();
        }

        public boolean doIt() {
            String currentColorName;
            PrimitiveNode.Function fun;
            String currentTextField;
            boolean currentLocked;
            boolean currentInvisibleOutsideCell;
            boolean currentEasyToSelect;
            boolean currentExpansion;
            boolean changed = false;
            NodeProto np = this.ni.getProto();
            this.dialog.changingValues = true;
            String currentName = this.dialog.name.getText().trim();
            if (!currentName.equals(this.dialog.initialName)) {
                this.dialog.initialName = new String(currentName);
                if (currentName.length() == 0) {
                    currentName = null;
                }
                this.ni.setName(currentName);
                changed = true;
            }
            if (np instanceof Cell && (currentExpansion = this.dialog.expanded.isSelected()) != this.dialog.initialExpansion) {
                if (currentExpansion) {
                    this.ni.setExpanded();
                } else {
                    this.ni.clearExpanded();
                }
                this.dialog.initialExpansion = currentExpansion;
                changed = true;
            }
            if ((currentEasyToSelect = this.dialog.easyToSelect.isSelected()) != this.dialog.initialEasyToSelect) {
                if (currentEasyToSelect) {
                    this.ni.clearHardSelect();
                } else {
                    this.ni.setHardSelect();
                }
                this.dialog.initialEasyToSelect = currentEasyToSelect;
            }
            if ((currentInvisibleOutsideCell = this.dialog.invisibleOutsideCell.isSelected()) != this.dialog.initialInvisibleOutsideCell) {
                if (currentInvisibleOutsideCell) {
                    this.ni.setVisInside();
                } else {
                    this.ni.clearVisInside();
                }
                this.dialog.initialInvisibleOutsideCell = currentInvisibleOutsideCell;
                changed = true;
            }
            if ((currentLocked = this.dialog.locked.isSelected()) != this.dialog.initialLocked) {
                if (currentLocked) {
                    this.ni.setLocked();
                } else {
                    this.ni.clearLocked();
                }
                this.dialog.initialLocked = currentLocked;
            }
            if (this.dialog.scalableTrans) {
                int index = this.dialog.popup.getSelectedIndex();
                if (index != this.dialog.initialPopupIndex) {
                    int numContacts = 2 - index / 2;
                    boolean inset = (index & 1) != 0;
                    String contactInfo = String.valueOf(numContacts);
                    if (inset) {
                        contactInfo = contactInfo + "i";
                    }
                    this.ni.newVar(MoCMOS.TRANS_CONTACT, (Object)contactInfo);
                }
                if (!(currentTextField = this.dialog.textField.getText()).equals(this.dialog.initialTextField)) {
                    double width = TextUtils.atof(currentTextField);
                    Variable oldVar = this.ni.getVar(Schematics.ATTR_WIDTH);
                    Variable var = this.ni.updateVar(Schematics.ATTR_WIDTH, (Object)new Double(width));
                    if (var != null && oldVar == null) {
                        var.setDisplay(true);
                        var.getTextDescriptor().setDispPart(TextDescriptor.DispPos.NAMEVALUE);
                    }
                    this.dialog.initialTextField = currentTextField;
                }
            }
            if (!((fun = this.ni.getFunction()) != PrimitiveNode.Function.DIODE && fun != PrimitiveNode.Function.DIODEZ || (currentTextField = this.dialog.textField.getText()).equals(this.dialog.initialTextField))) {
                Variable var = this.ni.updateVar(Schematics.SCHEM_DIODE, (Object)currentTextField);
                if (var != null) {
                    var.setDisplay(true);
                }
                this.dialog.initialTextField = currentTextField;
                changed = true;
            }
            if (fun == PrimitiveNode.Function.RESIST && !(currentTextField = this.dialog.textField.getText()).equals(this.dialog.initialTextField)) {
                Variable var = this.ni.updateVar(Schematics.SCHEM_RESISTANCE, (Object)currentTextField);
                if (var != null) {
                    var.setDisplay(true);
                }
                this.dialog.initialTextField = currentTextField;
                changed = true;
            }
            if (!(fun != PrimitiveNode.Function.CAPAC && fun != PrimitiveNode.Function.ECAPAC || (currentTextField = this.dialog.textField.getText()).equals(this.dialog.initialTextField))) {
                Variable var = this.ni.updateVar(Schematics.SCHEM_CAPACITANCE, (Object)currentTextField);
                if (var != null) {
                    var.setDisplay(true);
                }
                this.dialog.initialTextField = currentTextField;
                changed = true;
            }
            if (fun == PrimitiveNode.Function.INDUCT && !(currentTextField = this.dialog.textField.getText()).equals(this.dialog.initialTextField)) {
                Variable var = this.ni.updateVar(Schematics.SCHEM_INDUCTANCE, (Object)currentTextField);
                if (var != null) {
                    var.setDisplay(true);
                }
                this.dialog.initialTextField = currentTextField;
                changed = true;
            }
            if (np == Schematics.tech.bboxNode && !(currentTextField = this.dialog.textField.getText()).equals(this.dialog.initialTextField)) {
                Variable var = this.ni.updateVar(Schematics.SCHEM_FUNCTION, (Object)currentTextField);
                if (var != null) {
                    var.setDisplay(true);
                }
                this.dialog.initialTextField = currentTextField;
                changed = true;
            }
            if (np == Schematics.tech.globalNode) {
                String currentCharacteristic;
                currentTextField = this.dialog.textField.getText();
                if (!currentTextField.equals(this.dialog.initialTextField)) {
                    Variable var = this.ni.updateVar(Schematics.SCHEM_GLOBAL_NAME, (Object)currentTextField);
                    if (var != null) {
                        var.setDisplay(true);
                    }
                    this.dialog.initialTextField = currentTextField;
                    changed = true;
                }
                if (!(currentCharacteristic = (String)this.dialog.popup.getSelectedItem()).equals(this.dialog.initialPopupEntry)) {
                    PortCharacteristic ch = PortCharacteristic.findCharacteristic(currentCharacteristic);
                    this.ni.setTechSpecific(ch.getBits());
                    this.dialog.initialPopupEntry = currentCharacteristic;
                    changed = true;
                }
            }
            if (np instanceof PrimitiveNode && np.getTechnology() == Artwork.tech && !(currentColorName = (String)this.dialog.popup.getSelectedItem()).equals(this.dialog.initialPopupEntry)) {
                int value = EGraphics.findColorIndex(currentColorName);
                this.ni.newVar(Artwork.ART_COLOR, (Object)new Integer(value));
                this.dialog.initialPopupEntry = currentColorName;
                changed = true;
            }
            if (!(np != Artwork.tech.circleNode && np != Artwork.tech.thickCircleNode || (currentTextField = this.dialog.textField.getText()).equals(this.dialog.initialTextField))) {
                double start = 0.0;
                double curvature = TextUtils.atof(currentTextField) * Math.PI / 180.0;
                int slashPos = currentTextField.indexOf(47);
                if (slashPos >= 0) {
                    start = curvature;
                    curvature = TextUtils.atof(currentTextField.substring(slashPos + 1)) * Math.PI / 180.0;
                }
                this.ni.setArcDegrees(start, curvature);
                this.dialog.initialTextField = currentTextField;
                changed = true;
            }
            SizeOffset so = this.ni.getSizeOffset();
            double currentXPos = TextUtils.atof(this.dialog.xPos.getText(), new Double(this.dialog.initialXPos));
            double currentYPos = TextUtils.atof(this.dialog.yPos.getText(), new Double(this.dialog.initialYPos));
            double currentXSize = 0.0;
            double currentYSize = 0.0;
            double initXSize = 0.0;
            double initYSize = 0.0;
            if (this.dialog.swapXY) {
                currentXSize = TextUtils.atof(this.dialog.ySize.getText(), new Double(this.ni.getXSize() - (so.getLowXOffset() + so.getHighXOffset())));
                currentYSize = TextUtils.atof(this.dialog.xSize.getText(), new Double(this.ni.getYSize() - (so.getLowYOffset() + so.getHighYOffset())));
                initXSize = TextUtils.atof(this.dialog.initialYSize, new Double(currentXSize));
                initYSize = TextUtils.atof(this.dialog.initialXSize, new Double(currentYSize));
                currentXSize += so.getLowXOffset() + so.getHighXOffset();
                currentYSize += so.getLowYOffset() + so.getHighYOffset();
                initXSize += so.getLowXOffset() + so.getHighXOffset();
                initYSize += so.getLowYOffset() + so.getHighYOffset();
                if (this.dialog.mirrorX.isSelected()) {
                    currentYSize = -currentYSize;
                }
                if (this.dialog.mirrorY.isSelected()) {
                    currentXSize = -currentXSize;
                }
                if (this.dialog.initialMirrorX) {
                    initYSize = -initYSize;
                }
                if (this.dialog.initialMirrorY) {
                    initXSize = -initXSize;
                }
            } else {
                currentXSize = TextUtils.atof(this.dialog.xSize.getText(), new Double(this.ni.getXSize() - (so.getLowXOffset() + so.getHighXOffset())));
                currentYSize = TextUtils.atof(this.dialog.ySize.getText(), new Double(this.ni.getYSize() - (so.getLowYOffset() + so.getHighYOffset())));
                initXSize = TextUtils.atof(this.dialog.initialXSize, new Double(currentXSize));
                initYSize = TextUtils.atof(this.dialog.initialYSize, new Double(currentYSize));
                currentXSize += so.getLowXOffset() + so.getHighXOffset();
                currentYSize += so.getLowYOffset() + so.getHighYOffset();
                initXSize += so.getLowXOffset() + so.getHighXOffset();
                initYSize += so.getLowYOffset() + so.getHighYOffset();
                if (this.dialog.mirrorX.isSelected()) {
                    currentXSize = -currentXSize;
                }
                if (this.dialog.mirrorY.isSelected()) {
                    currentYSize = -currentYSize;
                }
                if (this.dialog.initialMirrorX) {
                    initXSize = -initXSize;
                }
                if (this.dialog.initialMirrorY) {
                    initYSize = -initYSize;
                }
            }
            if (this.ni.getTransistorSize(null) != null) {
                if (np == Schematics.tech.transistorNode || np == Schematics.tech.transistor4Node) {
                    if (this.ni.isFET()) {
                        double w = TextUtils.atof(this.dialog.xSize.getText(), null);
                        Object width = w == 0.0 ? this.dialog.xSize.getText() : new Double(w);
                        double l = TextUtils.atof(this.dialog.ySize.getText(), null);
                        Object length = l == 0.0 ? this.dialog.ySize.getText() : new Double(l);
                        this.ni.setTransistorSize(width, length);
                    }
                } else if (this.ni.isSerpentineTransistor()) {
                    double initialLength = this.ni.getSerpentineTransistorLength();
                    double length = TextUtils.atof(this.dialog.ySize.getText(), new Double(initialLength));
                    if (length != initialLength) {
                        this.ni.setSerpentineTransistorLength(length);
                    }
                } else {
                    double initialWidth = this.ni.getTransistorSize(null).getDoubleWidth();
                    double initialLength = this.ni.getTransistorSize(null).getDoubleLength();
                    double width = TextUtils.atof(this.dialog.xSize.getText(), new Double(initialWidth));
                    double length = TextUtils.atof(this.dialog.ySize.getText(), new Double(initialLength));
                    if (!DBMath.doublesEqual(width, initialWidth) || !DBMath.doublesEqual(length, initialLength)) {
                        this.ni.setTransistorSize(width, length);
                    }
                }
                currentXSize = initXSize = this.ni.getXSize();
                currentYSize = initYSize = this.ni.getYSize();
                if (this.dialog.swapXY) {
                    if (this.dialog.mirrorX.isSelected()) {
                        currentYSize = -currentYSize;
                    }
                    if (this.dialog.mirrorY.isSelected()) {
                        currentXSize = -currentXSize;
                    }
                    if (this.dialog.initialMirrorX) {
                        initYSize = -initYSize;
                    }
                    if (this.dialog.initialMirrorY) {
                        initXSize = -initXSize;
                    }
                } else {
                    if (this.dialog.mirrorX.isSelected()) {
                        currentXSize = -currentXSize;
                    }
                    if (this.dialog.mirrorY.isSelected()) {
                        currentYSize = -currentYSize;
                    }
                    if (this.dialog.initialMirrorX) {
                        initXSize = -initXSize;
                    }
                    if (this.dialog.initialMirrorY) {
                        initYSize = -initYSize;
                    }
                }
            }
            int currentRotation = (int)(TextUtils.atof(this.dialog.rotation.getText(), new Double(this.dialog.initialRotation)) * 10.0);
            if (!(DBMath.doublesEqual(currentXPos, this.dialog.initialXPos) && DBMath.doublesEqual(currentYPos, this.dialog.initialYPos) && DBMath.doublesEqual(currentXSize, initXSize) && DBMath.doublesEqual(currentYSize, initYSize) && currentRotation == this.dialog.initialRotation && !changed)) {
                this.ni.modifyInstance(DBMath.round(currentXPos - this.dialog.initialXPos), DBMath.round(currentYPos - this.dialog.initialYPos), DBMath.round(currentXSize - initXSize), DBMath.round(currentYSize - initYSize), currentRotation - this.dialog.initialRotation);
                this.dialog.initialXPos = currentXPos;
                this.dialog.initialYPos = currentYPos;
                this.dialog.initialXSize = this.dialog.xSize.getText();
                this.dialog.initialYSize = this.dialog.ySize.getText();
                this.dialog.initialMirrorX = this.dialog.mirrorX.isSelected();
                this.dialog.initialMirrorY = this.dialog.mirrorY.isSelected();
                this.dialog.initialRotation = currentRotation;
            }
            this.dialog.changingValues = false;
            return true;
        }
    }

    private static class AttValPair {
        Variable.Key key;
        String trueName;
        String value;
        String eval;
        boolean code;

        private AttValPair() {
        }
    }
}

