/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.routing;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.prototype.ArcProto;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.technology.PrimitiveArc;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.SizeOffset;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.tool.routing.InteractiveRouter;
import com.sun.electric.tool.routing.Route;
import com.sun.electric.tool.routing.RouteElementArc;
import com.sun.electric.tool.routing.RouteElementPort;
import com.sun.electric.tool.routing.VerticalRoute;
import com.sun.electric.tool.user.User;
import java.awt.geom.Point2D;

public class SimpleWirer
extends InteractiveRouter {
    public String toString() {
        return "SimpleWirer";
    }

    protected boolean planRoute(Route route, Cell cell, RouteElementPort endRE, Point2D startLoc, Point2D endLoc, Point2D clicked, VerticalRoute vroute, boolean contactsOnEndObj) {
        RouteElementPort startRE = route.getEnd();
        PortProto startPort = startRE.getPortProto();
        PortProto endPort = endRE.getPortProto();
        ArcProto useArc = SimpleWirer.getArcToUse(startPort, endPort);
        Point2D cornerLoc = null;
        if (startLoc.getX() == endLoc.getX() || startLoc.getY() == endLoc.getY() || useArc != null && useArc.getAngleIncrement() == 0) {
            cornerLoc = contactsOnEndObj ? endLoc : startLoc;
        } else {
            Point2D.Double pin1 = new Point2D.Double(startLoc.getX(), endLoc.getY());
            Point2D.Double pin2 = new Point2D.Double(endLoc.getX(), startLoc.getY());
            int clickedQuad = SimpleWirer.findQuadrant(endLoc, clicked);
            int pin1Quad = SimpleWirer.findQuadrant(endLoc, pin1);
            int pin2Quad = SimpleWirer.findQuadrant(endLoc, pin2);
            int oppositeQuad = (clickedQuad + 2) % 4;
            if (pin2Quad == clickedQuad) {
                pin1 = pin2;
            } else if (pin1Quad != clickedQuad && pin1Quad == oppositeQuad) {
                pin1 = pin2;
            }
            cornerLoc = pin1;
        }
        if (useArc == null) {
            if (User.tool.getCurrentArcProto() == Generic.tech.universal_arc) {
                useArc = Generic.tech.universal_arc;
            } else {
                route.add(endRE);
                route.setEnd(endRE);
                vroute.buildRoute(route, cell, startRE, endRE, startLoc, endLoc, cornerLoc);
                return true;
            }
        }
        route.add(endRE);
        route.setEnd(endRE);
        if (route.replaceBisectPin(startRE, endRE)) {
            route.remove(startRE);
            return true;
        }
        if (route.replaceBisectPin(endRE, startRE)) {
            route.remove(endRE);
            route.setEnd(startRE);
            return true;
        }
        double width = SimpleWirer.getArcWidthToUse(startRE, useArc);
        double width2 = SimpleWirer.getArcWidthToUse(endRE, useArc);
        if (width2 > width) {
            width = width2;
        }
        if (useArc.getAngleIncrement() == 0) {
            RouteElementArc arcRE = RouteElementArc.newArc(cell, useArc, width, startRE, endRE, startLoc, endLoc, null, null, null);
            route.add(arcRE);
            return true;
        }
        if (startLoc.getX() == endLoc.getX() || startLoc.getY() == endLoc.getY()) {
            RouteElementArc arcRE = RouteElementArc.newArc(cell, useArc, width, startRE, endRE, startLoc, endLoc, null, null, null);
            route.add(arcRE);
        } else {
            PrimitiveNode pn = ((PrimitiveArc)useArc).findOverridablePinProto();
            SizeOffset so = pn.getProtoSizeOffset();
            double defwidth = pn.getDefWidth() - so.getHighXOffset() - so.getLowXOffset();
            double defheight = pn.getDefHeight() - so.getHighYOffset() - so.getLowYOffset();
            RouteElementPort pinRE = RouteElementPort.newNode(cell, pn, pn.getPort(0), cornerLoc, defwidth, defheight);
            RouteElementArc arcRE1 = RouteElementArc.newArc(cell, useArc, width, startRE, pinRE, startLoc, cornerLoc, null, null, null);
            RouteElementArc arcRE2 = RouteElementArc.newArc(cell, useArc, width, pinRE, endRE, cornerLoc, endLoc, null, null, null);
            route.add(pinRE);
            route.add(arcRE1);
            route.add(arcRE2);
        }
        return true;
    }

    protected static int findQuadrant(Point2D refPoint, Point2D pt) {
        double angle = Math.atan((pt.getY() - refPoint.getY()) / (pt.getX() - refPoint.getX()));
        if (pt.getX() < refPoint.getX()) {
            angle += Math.PI;
        }
        if (angle > -0.7853981633974483 && angle <= 0.7853981633974483) {
            return 0;
        }
        if (angle > 0.7853981633974483 && angle <= 2.356194490192345) {
            return 1;
        }
        if (angle > 2.356194490192345 && angle <= 3.9269908169872414) {
            return 2;
        }
        return 3;
    }
}

