/*
 * EDMA: Entorno de Desarrollo Modular y Abierto
 * Object Oriented and Componetware Framework
 * Copyright (C) 1998, 2002, 2003, 2004, 2005, 2006, 2007, 2008, 2010, 2013
 *    David Martnez Oliveira
 *
 * This file is part of EDMA.
 *
 * EDMA is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * EDMA is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with EDMA.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "tclass.h"
#include "ttypes.h"
#include "classrt.h"
#include "multiidf.h"

static CLASSID
_lea_create_class (EPChar name)
{
  CLASSID cid;

  cid = edma_idf_get_free_class_id (EDMA_LOCAL_CLASS);

  edma_idf_set_class_name (cid, name);
  edma_idf_set_class_namespace (cid, "LOCAL");
  edma_idf_set_class_version (cid, 0, 0);

  return cid;
}


CLASSID
lea_create_class (EPChar name)
{
  CLASSID cid;

  cid = _lea_create_class (name);

  edma_idf_set_class_attribs (cid, 0, 0, 0);
  return cid;
}


CLASSID
lea_create_proxy (EPChar name)
{
  CLASSID cid;

  cid = _lea_create_class (name);
  edma_add_local_class_property (cid, "obj", DT_EOBJECT, E_L, 0);

  edma_idf_set_class_attribs (cid, 1, 0, 0);

  return cid;
}

CLASSID
lea_create_parser (EPChar name)
{
  CLASSID cid;

  cid = _lea_create_class (name);

  edma_idf_set_class_attribs (cid, 0, 1, 0);

  return cid;
}

CLASSID
lea_create_handler (EPChar name)
{
  CLASSID cid;

  cid = _lea_create_class (name);

  edma_idf_set_class_attribs (cid, 0, 0, 1);

  return cid;
}


int
lea_add_property (CLASSID cid, EPChar name, ESint32 type)
{
  return edma_add_local_class_property (cid, name, type, E_L, 0);
}

int
lea_add_method (CLASSID cid, EPChar name, EPChar sig, PPROC func)
{
  return edma_add_local_class_method (cid, name, sig, func, 0, 0, 0);
}

int
lea_add_virtual_method (CLASSID cid, EPChar name, EPChar sig, PPROC func)
{
  return edma_add_local_class_method (cid, name, sig, func, 1, 0, 0);
}


int
lea_add_static_method (CLASSID cid, EPChar name, EPChar sig, PPROC func)
{
  return edma_add_local_class_method (cid, name, sig, func, 0, 1, 0);
}


int
lea_add_abstract_method (CLASSID cid, EPChar name, EPChar sig)
{
  return edma_add_local_class_method (cid, name, sig, NULL, 1, 0, 1);
}


int 
lea_add_super (CLASSID cid, EPChar cname)
{
  return edma_add_local_class_superclass_by_name (cid, cname, "SUPER", "INNER");
}


int
lea_add_parse_method (CLASSID cid, PPROC func)
{
  return edma_add_local_class_method (cid, "Parse", "U32", func, 0, 0, 0);
}

int
lea_add_handler_get_class (CLASSID cid, PPROC func)
{
  return edma_add_local_class_method (cid, "GetClass", "Z", func, 0, 0, 0);
}



int
lea_finish_class (CLASSID cid)
{
  
  edma_idf_set_class_id (cid);
  return 0;
}
