;;;MusicGlyph
(let ((tag "MusicGlyph")(choice #f))

(set! choice (RadioBoxMenu
(cons (_ "rests") (list 
    (cons (_ "0") "rests.0")
    (cons (_ "1") "rests.1")
    (cons (_ "0o") "rests.0o")
    (cons (_ "1o") "rests.1o")
    (cons (_ "M3") "rests.M3")
    (cons (_ "M2") "rests.M2")
    (cons (_ "M1") "rests.M1")
    (cons (_ "M1o") "rests.M1o")
    (cons (_ "2") "rests.2")
    (cons (_ "2classical") "rests.2classical")
    (cons (_ "3") "rests.3")
    (cons (_ "4") "rests.4")
    (cons (_ "5") "rests.5")
    (cons (_ "6") "rests.6")
    (cons (_ "7") "rests.7")
))
(cons (_ "accidentals") (list 
    (cons (_ "sharp") "accidentals.sharp")
    (cons (_ "sharp.arrowup") "accidentals.sharp.arrowup")
    (cons (_ "sharp.arrowdown") "accidentals.sharp.arrowdown")
    (cons (_ "sharp.arrowboth") "accidentals.sharp.arrowboth")
    (cons (_ "sharp.slashslash.stem") "accidentals.sharp.slashslash.stem")
    (cons (_ "sharp.slashslashslash.stemstem") "accidentals.sharp.slashslashslash.stemstem")
    (cons (_ "sharp.slashslashslash.stem") "accidentals.sharp.slashslashslash.stem")
    (cons (_ "sharp.slashslash.stemstemstem") "accidentals.sharp.slashslash.stemstemstem")
    (cons (_ "natural") "accidentals.natural")
    (cons (_ "natural.arrowup") "accidentals.natural.arrowup")
    (cons (_ "natural.arrowdown") "accidentals.natural.arrowdown")
    (cons (_ "natural.arrowboth") "accidentals.natural.arrowboth")
    (cons (_ "flat") "accidentals.flat")
    (cons (_ "flat.arrowup") "accidentals.flat.arrowup")
    (cons (_ "flat.arrowdown") "accidentals.flat.arrowdown")
    (cons (_ "flat.arrowboth") "accidentals.flat.arrowboth")
    (cons (_ "flat.slash") "accidentals.flat.slash")
    (cons (_ "flat.slashslash") "accidentals.flat.slashslash")
    (cons (_ "mirroredflat.flat") "accidentals.mirroredflat.flat")
    (cons (_ "mirroredflat") "accidentals.mirroredflat")
    (cons (_ "mirroredflat.backslash") "accidentals.mirroredflat.backslash")
    (cons (_ "flatflat") "accidentals.flatflat")
    (cons (_ "flatflat.slash") "accidentals.flatflat.slash")
    (cons (_ "doublesharp") "accidentals.doublesharp")
    (cons (_ "rightparen") "accidentals.rightparen")
    (cons (_ "leftparen") "accidentals.leftparen")
))
(cons (_ "arrowheads") (list 
    (cons (_ "open.01") "arrowheads.open.01")
    (cons (_ "open.0M1") "arrowheads.open.0M1")
    (cons (_ "open.11") "arrowheads.open.11")
    (cons (_ "open.1M1") "arrowheads.open.1M1")
    (cons (_ "close.01") "arrowheads.close.01")
    (cons (_ "close.0M1") "arrowheads.close.0M1")
    (cons (_ "close.11") "arrowheads.close.11")
    (cons (_ "close.1M1") "arrowheads.close.1M1")
))
(cons (_ "dots") (list 
    (cons (_ "dot") "dots.dot")
))
(cons (_ "scripts") (list 
    (cons (_ "ufermata") "scripts.ufermata")
    (cons (_ "dfermata") "scripts.dfermata")
    (cons (_ "ushortfermata") "scripts.ushortfermata")
    (cons (_ "dshortfermata") "scripts.dshortfermata")
    (cons (_ "ulongfermata") "scripts.ulongfermata")
    (cons (_ "dlongfermata") "scripts.dlongfermata")
    (cons (_ "uverylongfermata") "scripts.uverylongfermata")
    (cons (_ "dverylongfermata") "scripts.dverylongfermata")
    (cons (_ "thumb") "scripts.thumb")
    (cons (_ "sforzato") "scripts.sforzato")
    (cons (_ "espr") "scripts.espr")
    (cons (_ "staccato") "scripts.staccato")
    (cons (_ "ustaccatissimo") "scripts.ustaccatissimo")
    (cons (_ "dstaccatissimo") "scripts.dstaccatissimo")
    (cons (_ "tenuto") "scripts.tenuto")
    (cons (_ "uportato") "scripts.uportato")
    (cons (_ "dportato") "scripts.dportato")
    (cons (_ "umarcato") "scripts.umarcato")
    (cons (_ "dmarcato") "scripts.dmarcato")
))
(cons (_ "more scripts") (list     
    (cons (_ "open") "scripts.open")
    (cons (_ "halfopen") "scripts.halfopen")
    (cons (_ "halfopenvertical") "scripts.halfopenvertical")
    (cons (_ "stopped") "scripts.stopped")
    (cons (_ "upbow") "scripts.upbow")
    (cons (_ "downbow") "scripts.downbow")
    (cons (_ "reverseturn") "scripts.reverseturn")
    (cons (_ "turn") "scripts.turn")
    (cons (_ "trill") "scripts.trill")
    (cons (_ "upedalheel") "scripts.upedalheel")
    (cons (_ "dpedalheel") "scripts.dpedalheel")
    (cons (_ "upedaltoe") "scripts.upedaltoe")
    (cons (_ "dpedaltoe") "scripts.dpedaltoe")
    (cons (_ "flageolet") "scripts.flageolet")
    (cons (_ "segno") "scripts.segno")
    (cons (_ "varsegno") "scripts.varsegno")
    (cons (_ "coda") "scripts.coda")
    (cons (_ "varcoda") "scripts.varcoda")
    (cons (_ "rcomma") "scripts.rcomma")
    (cons (_ "lcomma") "scripts.lcomma")
    (cons (_ "rvarcomma") "scripts.rvarcomma")
    (cons (_ "lvarcomma") "scripts.lvarcomma")
    ))
(cons (_ "and more scripts") (list 
    (cons (_ "arpeggio") "scripts.arpeggio")
    (cons (_ "trill_element") "scripts.trill_element")
    (cons (_ "arpeggio.arrow.M1") "scripts.arpeggio.arrow.M1")
    (cons (_ "arpeggio.arrow.1") "scripts.arpeggio.arrow.1")
    (cons (_ "trilelement") "scripts.trilelement")
    (cons (_ "prall") "scripts.prall")
    (cons (_ "mordent") "scripts.mordent")
    (cons (_ "prallprall") "scripts.prallprall")
    (cons (_ "prallmordent") "scripts.prallmordent")
    (cons (_ "upprall") "scripts.upprall")
    (cons (_ "upmordent") "scripts.upmordent")
    (cons (_ "pralldown") "scripts.pralldown")
    (cons (_ "downprall") "scripts.downprall")
    (cons (_ "downmordent") "scripts.downmordent")
    (cons (_ "prallup") "scripts.prallup")
    (cons (_ "lineprall") "scripts.lineprall")
    (cons (_ "caesura.curved") "scripts.caesura.curved")
    (cons (_ "caesura.straight") "scripts.caesura.straight")
    (cons (_ "tickmark") "scripts.tickmark")
    (cons (_ "snappizzicato") "scripts.snappizzicato")

    (cons (_ "ictus") "scripts.ictus")
    (cons (_ "uaccentus") "scripts.uaccentus")
    (cons (_ "daccentus") "scripts.daccentus")
    (cons (_ "usemicirculus") "scripts.usemicirculus")
    (cons (_ "dsemicirculus") "scripts.dsemicirculus")
    (cons (_ "circulus") "scripts.circulus")
    (cons (_ "augmentum") "scripts.augmentum")
    (cons (_ "usignumcongruentiae") "scripts.usignumcongruentiae")
    (cons (_ "dsignumcongruentiae") "scripts.dsignumcongruentiae")
    (cons (_ "barline.kievan") "scripts.barline.kievan")
))

(cons (_ "clefs") (list 
    (cons (_ "C") "clefs.C")
    (cons (_ "C_change") "clefs.C_change")
    (cons (_ "F") "clefs.F")
    (cons (_ "F_change") "clefs.F_change")
    (cons (_ "G") "clefs.G")
    (cons (_ "G_change") "clefs.G_change")
    (cons (_ "percussion") "clefs.percussion")
    (cons (_ "percussion_change") "clefs.percussion_change")
    (cons (_ "tab") "clefs.tab")
    (cons (_ "tab_change") "clefs.tab_change")
))
(cons (_ "more clefs") (list 
    (cons (_ "vaticana.do") "clefs.vaticana.do")
    (cons (_ "vaticana.do_change") "clefs.vaticana.do_change")
    (cons (_ "vaticana.fa") "clefs.vaticana.fa")
    (cons (_ "vaticana.fa_change") "clefs.vaticana.fa_change")
    (cons (_ "medicaea.do") "clefs.medicaea.do")
    (cons (_ "medicaea.do_change") "clefs.medicaea.do_change")
    (cons (_ "medicaea.fa") "clefs.medicaea.fa")
    (cons (_ "medicaea.fa_change") "clefs.medicaea.fa_change")
    (cons (_ "neomensural.c") "clefs.neomensural.c")
    (cons (_ "neomensural.c_change") "clefs.neomensural.c_change")
    (cons (_ "petrucci.c1") "clefs.petrucci.c1")
    (cons (_ "petrucci.c1_change") "clefs.petrucci.c1_change")
    (cons (_ "petrucci.c2") "clefs.petrucci.c2")
    (cons (_ "petrucci.c2_change") "clefs.petrucci.c2_change")
    (cons (_ "petrucci.c3") "clefs.petrucci.c3")
    (cons (_ "petrucci.c3_change") "clefs.petrucci.c3_change")
    (cons (_ "petrucci.c4") "clefs.petrucci.c4")
    (cons (_ "petrucci.c4_change") "clefs.petrucci.c4_change")
    (cons (_ "petrucci.c5") "clefs.petrucci.c5")
    (cons (_ "petrucci.c5_change") "clefs.petrucci.c5_change")
    ))
(cons (_ "more clefs") (list 
    (cons (_ "mensural.c") "clefs.mensural.c")
    (cons (_ "mensural.c_change") "clefs.mensural.c_change")
    (cons (_ "blackmensural.c") "clefs.blackmensural.c")
    (cons (_ "blackmensural.c_change") "clefs.blackmensural.c_change")
    (cons (_ "petrucci.f") "clefs.petrucci.f")
    (cons (_ "petrucci.f_change") "clefs.petrucci.f_change")
    (cons (_ "mensural.f") "clefs.mensural.f")
    (cons (_ "mensural.f_change") "clefs.mensural.f_change")
    (cons (_ "petrucci.g") "clefs.petrucci.g")
    (cons (_ "petrucci.g_change") "clefs.petrucci.g_change")
    (cons (_ "mensural.g") "clefs.mensural.g")
    (cons (_ "mensural.g_change") "clefs.mensural.g_change")
    (cons (_ "hufnagel.do") "clefs.hufnagel.do")
    (cons (_ "hufnagel.do_change") "clefs.hufnagel.do_change")
    (cons (_ "hufnagel.fa") "clefs.hufnagel.fa")
    (cons (_ "hufnagel.fa_change") "clefs.hufnagel.fa_change")
    (cons (_ "hufnagel.do.fa") "clefs.hufnagel.do.fa")
    (cons (_ "hufnagel.do.fa_change") "clefs.hufnagel.do.fa_change")
    (cons (_ "kievan.do") "clefs.kievan.do")
    (cons (_ "kievan.do_change") "clefs.kievan.do_change")
))
(cons (_ "timesig") (list 
    (cons (_ "C44") "timesig.C44")
    (cons (_ "C22") "timesig.C22")
))
(cons (_ "mensural timesig") (list 
    (cons (_ "mensural44") "timesig.mensural44")
    (cons (_ "mensural22") "timesig.mensural22")
    (cons (_ "mensural32") "timesig.mensural32")
    (cons (_ "mensural64") "timesig.mensural64")
    (cons (_ "mensural94") "timesig.mensural94")
    (cons (_ "mensural34") "timesig.mensural34")
    (cons (_ "mensural68") "timesig.mensural68")
    (cons (_ "mensural98") "timesig.mensural98")
    (cons (_ "mensural48") "timesig.mensural48")
    (cons (_ "mensural68alt") "timesig.mensural68alt")
    (cons (_ "mensural24") "timesig.mensural24")
    (cons (_ "neomensural44") "timesig.neomensural44")
    (cons (_ "neomensural22") "timesig.neomensural22")
    (cons (_ "neomensural32") "timesig.neomensural32")
    (cons (_ "neomensural64") "timesig.neomensural64")
    (cons (_ "neomensural94") "timesig.neomensural94")
    (cons (_ "neomensural34") "timesig.neomensural34")
    (cons (_ "neomensural68") "timesig.neomensural68")
    (cons (_ "neomensural98") "timesig.neomensural98")
    (cons (_ "neomensural48") "timesig.neomensural48")
    (cons (_ "neomensural68alt") "timesig.neomensural68alt")
    (cons (_ "neomensural24") "timesig.neomensural24")
))
(cons (_ "pedal") (list 
    (cons (_ "*") "pedal.*")
    (cons (_ "M") "pedal.M")
    (cons (_ ".") "pedal..")
    (cons (_ "P") "pedal.P")
    (cons (_ "d") "pedal.d")
    (cons (_ "e") "pedal.e")
    (cons (_ "Ped") "pedal.Ped")
))
(cons (_ "brackettips") (list 
    (cons (_ "up") "brackettips.up")
    (cons (_ "down") "brackettips.down")
))
(cons (_ "accordion") (list 
    (cons (_ "discant") "accordion.discant")
    (cons (_ "dot") "accordion.dot")
    (cons (_ "freebass") "accordion.freebass")
    (cons (_ "stdbass") "accordion.stdbass")
    (cons (_ "bayanbass") "accordion.bayanbass")
    (cons (_ "oldEE") "accordion.oldEE")
    (cons (_ "push") "accordion.push")
    (cons (_ "pull") "accordion.pull")
))
(cons (_ "ties") (list 
    (cons (_ "lyric.short") "ties.lyric.short")
    (cons (_ "lyric.default") "ties.lyric.default")
))
(cons (_ "noteheads") (list 
    (cons (_ "uM2") "noteheads.uM2")
    (cons (_ "dM2") "noteheads.dM2")
    (cons (_ "sM1") "noteheads.sM1")
    (cons (_ "sM1double") "noteheads.sM1double")
    (cons (_ "s0") "noteheads.s0")
    (cons (_ "s1") "noteheads.s1")
    (cons (_ "s2") "noteheads.s2")
    (cons (_ "s0diamond") "noteheads.s0diamond")
    (cons (_ "s1diamond") "noteheads.s1diamond")
    (cons (_ "s2diamond") "noteheads.s2diamond")
    (cons (_ "s0triangle") "noteheads.s0triangle")
    (cons (_ "d1triangle") "noteheads.d1triangle")
    (cons (_ "u1triangle") "noteheads.u1triangle")
    (cons (_ "u2triangle") "noteheads.u2triangle")
    (cons (_ "d2triangle") "noteheads.d2triangle")
    (cons (_ "s0slash") "noteheads.s0slash")
    (cons (_ "s1slash") "noteheads.s1slash")
    (cons (_ "s2slash") "noteheads.s2slash")
    (cons (_ "s0cross") "noteheads.s0cross")
    (cons (_ "s1cross") "noteheads.s1cross")
    (cons (_ "s2cross") "noteheads.s2cross")
    (cons (_ "s2xcircle") "noteheads.s2xcircle")
    (cons (_ "s0do") "noteheads.s0do")
    (cons (_ "d1do") "noteheads.d1do")
    (cons (_ "u1do") "noteheads.u1do")
    (cons (_ "d2do") "noteheads.d2do")
    (cons (_ "u2do") "noteheads.u2do")
    (cons (_ "s0doThin") "noteheads.s0doThin")
    (cons (_ "d1doThin") "noteheads.d1doThin")
    (cons (_ "u1doThin") "noteheads.u1doThin")
    (cons (_ "d2doThin") "noteheads.d2doThin")
    (cons (_ "u2doThin") "noteheads.u2doThin")
    (cons (_ "s0re") "noteheads.s0re")
    (cons (_ "u1re") "noteheads.u1re")
    (cons (_ "d1re") "noteheads.d1re")
    (cons (_ "u2re") "noteheads.u2re")
    (cons (_ "d2re") "noteheads.d2re")
    ))
(cons (_ "noteheads") (list 
    (cons (_ "s0reThin") "noteheads.s0reThin")
    (cons (_ "u1reThin") "noteheads.u1reThin")
    (cons (_ "d1reThin") "noteheads.d1reThin")
    (cons (_ "u2reThin") "noteheads.u2reThin")
    (cons (_ "d2reThin") "noteheads.d2reThin")
    (cons (_ "s0mi") "noteheads.s0mi")
    (cons (_ "s1mi") "noteheads.s1mi")
    (cons (_ "s2mi") "noteheads.s2mi")
    (cons (_ "s0miMirror") "noteheads.s0miMirror")
    (cons (_ "s1miMirror") "noteheads.s1miMirror")
    (cons (_ "s2miMirror") "noteheads.s2miMirror")
    (cons (_ "s0miThin") "noteheads.s0miThin")
    (cons (_ "s1miThin") "noteheads.s1miThin")
    (cons (_ "s2miThin") "noteheads.s2miThin")
    (cons (_ "u0fa") "noteheads.u0fa")
    (cons (_ "d0fa") "noteheads.d0fa")
    (cons (_ "u1fa") "noteheads.u1fa")
    (cons (_ "d1fa") "noteheads.d1fa")
    (cons (_ "u2fa") "noteheads.u2fa")
    (cons (_ "d2fa") "noteheads.d2fa")
    (cons (_ "u0faThin") "noteheads.u0faThin")
    (cons (_ "d0faThin") "noteheads.d0faThin")
    (cons (_ "u1faThin") "noteheads.u1faThin")
    (cons (_ "d1faThin") "noteheads.d1faThin")
    (cons (_ "u2faThin") "noteheads.u2faThin")
    (cons (_ "d2faThin") "noteheads.d2faThin")
    (cons (_ "s0sol") "noteheads.s0sol")
    (cons (_ "s1sol") "noteheads.s1sol")
    (cons (_ "s2sol") "noteheads.s2sol")
    (cons (_ "s0la") "noteheads.s0la")
    (cons (_ "s1la") "noteheads.s1la")
    (cons (_ "s2la") "noteheads.s2la")
    (cons (_ "s0laThin") "noteheads.s0laThin")
    (cons (_ "s1laThin") "noteheads.s1laThin")
    (cons (_ "s2laThin") "noteheads.s2laThin")
    (cons (_ "s0ti") "noteheads.s0ti")
    (cons (_ "u1ti") "noteheads.u1ti")
    (cons (_ "d1ti") "noteheads.d1ti")
    (cons (_ "u2ti") "noteheads.u2ti")
    (cons (_ "d2ti") "noteheads.d2ti")
    (cons (_ "s0tiThin") "noteheads.s0tiThin")
    (cons (_ "u1tiThin") "noteheads.u1tiThin")
    (cons (_ "d1tiThin") "noteheads.d1tiThin")
    (cons (_ "u2tiThin") "noteheads.u2tiThin")
    (cons (_ "d2tiThin") "noteheads.d2tiThin")
    ))
(cons (_ "Funk noteheads") (list 
    (cons (_ "u0doFunk") "noteheads.u0doFunk")
    (cons (_ "d0doFunk") "noteheads.d0doFunk")
    (cons (_ "u1doFunk") "noteheads.u1doFunk")
    (cons (_ "d1doFunk") "noteheads.d1doFunk")
    (cons (_ "u2doFunk") "noteheads.u2doFunk")
    (cons (_ "d2doFunk") "noteheads.d2doFunk")
    (cons (_ "u0reFunk") "noteheads.u0reFunk")
    (cons (_ "d0reFunk") "noteheads.d0reFunk")
    (cons (_ "u1reFunk") "noteheads.u1reFunk")
    (cons (_ "d1reFunk") "noteheads.d1reFunk")
    (cons (_ "u2reFunk") "noteheads.u2reFunk")
    (cons (_ "d2reFunk") "noteheads.d2reFunk")
    (cons (_ "u0miFunk") "noteheads.u0miFunk")
    (cons (_ "d0miFunk") "noteheads.d0miFunk")
    (cons (_ "u1miFunk") "noteheads.u1miFunk")
    (cons (_ "d1miFunk") "noteheads.d1miFunk")
    (cons (_ "s2miFunk") "noteheads.s2miFunk")
    (cons (_ "u0faFunk") "noteheads.u0faFunk")
    (cons (_ "d0faFunk") "noteheads.d0faFunk")
        ))
(cons (_ "Funk noteheads") (list 
    (cons (_ "u1faFunk") "noteheads.u1faFunk")
    (cons (_ "d1faFunk") "noteheads.d1faFunk")
    (cons (_ "u2faFunk") "noteheads.u2faFunk")
    (cons (_ "d2faFunk") "noteheads.d2faFunk")
    (cons (_ "s0solFunk") "noteheads.s0solFunk")
    (cons (_ "s1solFunk") "noteheads.s1solFunk")
    (cons (_ "s2solFunk") "noteheads.s2solFunk")
    (cons (_ "s0laFunk") "noteheads.s0laFunk")
    (cons (_ "s1laFunk") "noteheads.s1laFunk")
    (cons (_ "s2laFunk") "noteheads.s2laFunk")
    (cons (_ "u0tiFunk") "noteheads.u0tiFunk")
    (cons (_ "d0tiFunk") "noteheads.d0tiFunk")
    (cons (_ "u1tiFunk") "noteheads.u1tiFunk")
    (cons (_ "d1tiFunk") "noteheads.d1tiFunk")
    (cons (_ "u2tiFunk") "noteheads.u2tiFunk")
    (cons (_ "d2tiFunk") "noteheads.d2tiFunk")
    ))
(cons (_ "Walker noteheads") (list     
    (cons (_ "s0doWalker") "noteheads.s0doWalker")
    (cons (_ "u1doWalker") "noteheads.u1doWalker")
    (cons (_ "d1doWalker") "noteheads.d1doWalker")
    (cons (_ "u2doWalker") "noteheads.u2doWalker")
    (cons (_ "d2doWalker") "noteheads.d2doWalker")
    (cons (_ "s0reWalker") "noteheads.s0reWalker")
    (cons (_ "u1reWalker") "noteheads.u1reWalker")
    (cons (_ "d1reWalker") "noteheads.d1reWalker")
    (cons (_ "u2reWalker") "noteheads.u2reWalker")
    (cons (_ "d2reWalker") "noteheads.d2reWalker")
    (cons (_ "s0miWalker") "noteheads.s0miWalker")
    (cons (_ "s1miWalker") "noteheads.s1miWalker")
    (cons (_ "s2miWalker") "noteheads.s2miWalker")
    (cons (_ "s0faWalker") "noteheads.s0faWalker")
    (cons (_ "u1faWalker") "noteheads.u1faWalker")
    (cons (_ "d1faWalker") "noteheads.d1faWalker")
    (cons (_ "u2faWalker") "noteheads.u2faWalker")
    (cons (_ "d2faWalker") "noteheads.d2faWalker")
    (cons (_ "s0laWalker") "noteheads.s0laWalker")
    (cons (_ "s1laWalker") "noteheads.s1laWalker")
    (cons (_ "s2laWalker") "noteheads.s2laWalker")
    (cons (_ "s0tiWalker") "noteheads.s0tiWalker")
    (cons (_ "u1tiWalker") "noteheads.u1tiWalker")
    (cons (_ "d1tiWalker") "noteheads.d1tiWalker")
    (cons (_ "u2tiWalker") "noteheads.u2tiWalker")
    (cons (_ "d2tiWalker") "noteheads.d2tiWalker")
))
(cons (_ "mensural noteheads") (list 
    (cons (_ "uM3neomensural") "noteheads.uM3neomensural")
    (cons (_ "dM3neomensural") "noteheads.dM3neomensural")
    (cons (_ "uM2neomensural") "noteheads.uM2neomensural")
    (cons (_ "dM2neomensural") "noteheads.dM2neomensural")
    (cons (_ "sM1neomensural") "noteheads.sM1neomensural")
    (cons (_ "urM3neomensural") "noteheads.urM3neomensural")
    (cons (_ "drM3neomensural") "noteheads.drM3neomensural")
    (cons (_ "urM2neomensural") "noteheads.urM2neomensural")
    (cons (_ "drM2neomensural") "noteheads.drM2neomensural")
    (cons (_ "srM1neomensural") "noteheads.srM1neomensural")
    (cons (_ "s0neomensural") "noteheads.s0neomensural")
    (cons (_ "s1neomensural") "noteheads.s1neomensural")
    (cons (_ "s2neomensural") "noteheads.s2neomensural")
    (cons (_ "s0harmonic") "noteheads.s0harmonic")
    (cons (_ "s2harmonic") "noteheads.s2harmonic")
    (cons (_ "uM3mensural") "noteheads.uM3mensural")
    (cons (_ "dM3mensural") "noteheads.dM3mensural")
    (cons (_ "sM3ligmensural") "noteheads.sM3ligmensural")
    (cons (_ "uM2mensural") "noteheads.uM2mensural")
    (cons (_ "dM2mensural") "noteheads.dM2mensural")
    (cons (_ "sM2ligmensural") "noteheads.sM2ligmensural")
    (cons (_ "sM1mensural") "noteheads.sM1mensural")
    (cons (_ "urM3mensural") "noteheads.urM3mensural")
    (cons (_ "drM3mensural") "noteheads.drM3mensural")
    (cons (_ "srM3ligmensural") "noteheads.srM3ligmensural")
    (cons (_ "urM2mensural") "noteheads.urM2mensural")
    (cons (_ "drM2mensural") "noteheads.drM2mensural")
    (cons (_ "srM2ligmensural") "noteheads.srM2ligmensural")
    ))
(cons (_ "more mensural noteheads") (list 
    (cons (_ "srM1mensural") "noteheads.srM1mensural")
    (cons (_ "uM3semimensural") "noteheads.uM3semimensural")
    (cons (_ "dM3semimensural") "noteheads.dM3semimensural")
    (cons (_ "sM3semiligmensural") "noteheads.sM3semiligmensural")
    (cons (_ "uM2semimensural") "noteheads.uM2semimensural")
    (cons (_ "dM2semimensural") "noteheads.dM2semimensural")
    (cons (_ "sM2semiligmensural") "noteheads.sM2semiligmensural")
    (cons (_ "sM1semimensural") "noteheads.sM1semimensural")
    (cons (_ "urM3semimensural") "noteheads.urM3semimensural")
    (cons (_ "drM3semimensural") "noteheads.drM3semimensural")
    (cons (_ "srM3semiligmensural") "noteheads.srM3semiligmensural")
    (cons (_ "urM2semimensural") "noteheads.urM2semimensural")
    (cons (_ "drM2semimensural") "noteheads.drM2semimensural")
    (cons (_ "srM2semiligmensural") "noteheads.srM2semiligmensural")
    (cons (_ "srM1semimensural") "noteheads.srM1semimensural")
    (cons (_ "uM3blackmensural") "noteheads.uM3blackmensural")
    (cons (_ "dM3blackmensural") "noteheads.dM3blackmensural")
    (cons (_ "sM3blackligmensural") "noteheads.sM3blackligmensural")
    (cons (_ "uM2blackmensural") "noteheads.uM2blackmensural")
    (cons (_ "dM2blackmensural") "noteheads.dM2blackmensural")
    (cons (_ "sM2blackligmensural") "noteheads.sM2blackligmensural")
    (cons (_ "sM1blackmensural") "noteheads.sM1blackmensural")
    (cons (_ "s0mensural") "noteheads.s0mensural")
    (cons (_ "s1mensural") "noteheads.s1mensural")
    (cons (_ "s2mensural") "noteheads.s2mensural")
    (cons (_ "s0blackmensural") "noteheads.s0blackmensural")
    ))
(cons (_ "ancient noteheads") (list 
    (cons (_ "s0petrucci") "noteheads.s0petrucci")
    (cons (_ "s1petrucci") "noteheads.s1petrucci")
    (cons (_ "s2petrucci") "noteheads.s2petrucci")
    (cons (_ "s0blackpetrucci") "noteheads.s0blackpetrucci")
    (cons (_ "s1blackpetrucci") "noteheads.s1blackpetrucci")
    (cons (_ "s2blackpetrucci") "noteheads.s2blackpetrucci")
    (cons (_ "svaticana.punctum") "noteheads.svaticana.punctum")
    (cons (_ "svaticana.punctum.cavum") "noteheads.svaticana.punctum.cavum")
    (cons (_ "svaticana.linea.punctum") "noteheads.svaticana.linea.punctum")
    (cons (_ "svaticana.linea.punctum.cavum") "noteheads.svaticana.linea.punctum.cavum")
    (cons (_ "svaticana.inclinatum") "noteheads.svaticana.inclinatum")
    (cons (_ "svaticana.lpes") "noteheads.svaticana.lpes")
    (cons (_ "svaticana.vlpes") "noteheads.svaticana.vlpes")
    (cons (_ "svaticana.upes") "noteheads.svaticana.upes")
    (cons (_ "svaticana.vupes") "noteheads.svaticana.vupes")
    (cons (_ "svaticana.plica") "noteheads.svaticana.plica")
    (cons (_ "svaticana.vplica") "noteheads.svaticana.vplica")
    (cons (_ "svaticana.epiphonus") "noteheads.svaticana.epiphonus")
    (cons (_ "svaticana.vepiphonus") "noteheads.svaticana.vepiphonus")
    (cons (_ "svaticana.reverse.plica") "noteheads.svaticana.reverse.plica")
    (cons (_ "svaticana.reverse.vplica") "noteheads.svaticana.reverse.vplica")
    (cons (_ "svaticana.inner.cephalicus") "noteheads.svaticana.inner.cephalicus")
    (cons (_ "svaticana.cephalicus") "noteheads.svaticana.cephalicus")
    (cons (_ "svaticana.quilisma") "noteheads.svaticana.quilisma")
        ))
(cons (_ "more ancient noteheads") (list 
    (cons (_ "ssolesmes.incl.parvum") "noteheads.ssolesmes.incl.parvum")
    (cons (_ "ssolesmes.auct.asc") "noteheads.ssolesmes.auct.asc")
    (cons (_ "ssolesmes.auct.desc") "noteheads.ssolesmes.auct.desc")
    (cons (_ "ssolesmes.incl.auctum") "noteheads.ssolesmes.incl.auctum")
    (cons (_ "ssolesmes.stropha") "noteheads.ssolesmes.stropha")
    (cons (_ "ssolesmes.stropha.aucta") "noteheads.ssolesmes.stropha.aucta")
    (cons (_ "ssolesmes.oriscus") "noteheads.ssolesmes.oriscus")
    (cons (_ "smedicaea.inclinatum") "noteheads.smedicaea.inclinatum")
    (cons (_ "smedicaea.punctum") "noteheads.smedicaea.punctum")
    (cons (_ "smedicaea.rvirga") "noteheads.smedicaea.rvirga")
    (cons (_ "smedicaea.virga") "noteheads.smedicaea.virga")
    (cons (_ "shufnagel.punctum") "noteheads.shufnagel.punctum")
    (cons (_ "shufnagel.virga") "noteheads.shufnagel.virga")
    (cons (_ "shufnagel.lpes") "noteheads.shufnagel.lpes")
    ))
(cons (_ "kievan noteheads") (list 
    (cons (_ "sM2kievan") "noteheads.sM2kievan")
    (cons (_ "sM1kievan") "noteheads.sM1kievan")
    (cons (_ "s0kievan") "noteheads.s0kievan")
    (cons (_ "d2kievan") "noteheads.d2kievan")
    (cons (_ "u2kievan") "noteheads.u2kievan")
    (cons (_ "s1kievan") "noteheads.s1kievan")
    (cons (_ "sr1kievan") "noteheads.sr1kievan")
    (cons (_ "d3kievan") "noteheads.d3kievan")
    (cons (_ "u3kievan") "noteheads.u3kievan")
))

(cons (_ "flags") (list 
    (cons (_ "u3") "flags.u3")
    (cons (_ "u4") "flags.u4")
    (cons (_ "u5") "flags.u5")
    (cons (_ "u6") "flags.u6")
    (cons (_ "u7") "flags.u7")
    (cons (_ "d3") "flags.d3")
    (cons (_ "d4") "flags.d4")
    (cons (_ "d5") "flags.d5")
    (cons (_ "d6") "flags.d6")
    (cons (_ "d7") "flags.d7")
    (cons (_ "ugrace") "flags.ugrace")
    (cons (_ "dgrace") "flags.dgrace")
))
(cons (_ "rests") (list 
    (cons (_ "M3neomensural") "rests.M3neomensural")
    (cons (_ "M2neomensural") "rests.M2neomensural")
    (cons (_ "M1neomensural") "rests.M1neomensural")
    (cons (_ "0neomensural") "rests.0neomensural")
    (cons (_ "1neomensural") "rests.1neomensural")
    (cons (_ "2neomensural") "rests.2neomensural")
    (cons (_ "3neomensural") "rests.3neomensural")
    (cons (_ "4neomensural") "rests.4neomensural")
    (cons (_ "M3mensural") "rests.M3mensural")
    (cons (_ "M2mensural") "rests.M2mensural")
    (cons (_ "M1mensural") "rests.M1mensural")
    (cons (_ "0mensural") "rests.0mensural")
    (cons (_ "1mensural") "rests.1mensural")
    (cons (_ "2mensural") "rests.2mensural")
    (cons (_ "3mensural") "rests.3mensural")
    (cons (_ "4mensural") "rests.4mensural")
))

(cons (_ "custodes") (list 
    (cons (_ "hufnagel.u0") "custodes.hufnagel.u0")
    (cons (_ "hufnagel.u1") "custodes.hufnagel.u1")
    (cons (_ "hufnagel.u2") "custodes.hufnagel.u2")
    (cons (_ "hufnagel.d0") "custodes.hufnagel.d0")
    (cons (_ "hufnagel.d1") "custodes.hufnagel.d1")
    (cons (_ "hufnagel.d2") "custodes.hufnagel.d2")
    (cons (_ "medicaea.u0") "custodes.medicaea.u0")
    (cons (_ "medicaea.u1") "custodes.medicaea.u1")
    (cons (_ "medicaea.u2") "custodes.medicaea.u2")
    (cons (_ "medicaea.d0") "custodes.medicaea.d0")
    (cons (_ "medicaea.d1") "custodes.medicaea.d1")
    (cons (_ "medicaea.d2") "custodes.medicaea.d2")
    (cons (_ "vaticana.u0") "custodes.vaticana.u0")
    (cons (_ "vaticana.u1") "custodes.vaticana.u1")
    (cons (_ "vaticana.u2") "custodes.vaticana.u2")
    (cons (_ "vaticana.d0") "custodes.vaticana.d0")
    (cons (_ "vaticana.d1") "custodes.vaticana.d1")
    (cons (_ "vaticana.d2") "custodes.vaticana.d2")
    (cons (_ "mensural.u0") "custodes.mensural.u0")
    (cons (_ "mensural.u1") "custodes.mensural.u1")
    (cons (_ "mensural.u2") "custodes.mensural.u2")
    (cons (_ "mensural.d0") "custodes.mensural.d0")
    (cons (_ "mensural.d1") "custodes.mensural.d1")
    (cons (_ "mensural.d2") "custodes.mensural.d2")
))
(cons (_ "accidentals") (list 
    (cons (_ "medicaeaM1") "accidentals.medicaeaM1")
    (cons (_ "vaticanaM1") "accidentals.vaticanaM1")
    (cons (_ "vaticana0") "accidentals.vaticana0")
    (cons (_ "mensural1") "accidentals.mensural1")
    (cons (_ "mensuralM1") "accidentals.mensuralM1")
    (cons (_ "hufnagelM1") "accidentals.hufnagelM1")
    (cons (_ "kievan1") "accidentals.kievan1")
    (cons (_ "kievanM1") "accidentals.kievanM1")
))
(cons (_ "flags") (list 
    (cons (_ "mensuralu03") "flags.mensuralu03")
    (cons (_ "mensuralu13") "flags.mensuralu13")
    (cons (_ "mensuralu23") "flags.mensuralu23")
    (cons (_ "mensurald03") "flags.mensurald03")
    (cons (_ "mensurald13") "flags.mensurald13")
    (cons (_ "mensurald23") "flags.mensurald23")
    (cons (_ "mensuralu04") "flags.mensuralu04")
    (cons (_ "mensuralu14") "flags.mensuralu14")
    (cons (_ "mensuralu24") "flags.mensuralu24")
    (cons (_ "mensurald04") "flags.mensurald04")
    (cons (_ "mensurald14") "flags.mensurald14")
    (cons (_ "mensurald24") "flags.mensurald24")
    (cons (_ "mensuralu05") "flags.mensuralu05")
    (cons (_ "mensuralu15") "flags.mensuralu15")
    (cons (_ "mensuralu25") "flags.mensuralu25")
    (cons (_ "mensurald05") "flags.mensurald05")
    (cons (_ "mensurald15") "flags.mensurald15")
    (cons (_ "mensurald25") "flags.mensurald25")
    (cons (_ "mensuralu06") "flags.mensuralu06")
    (cons (_ "mensuralu16") "flags.mensuralu16")
    (cons (_ "mensuralu26") "flags.mensuralu26")
    (cons (_ "mensurald06") "flags.mensurald06")
    (cons (_ "mensurald16") "flags.mensurald16")
    (cons (_ "mensurald26") "flags.mensurald26")
))

(cons (_ "dots") (list 
    (cons (_ "dotvaticana") "dots.dotvaticana")
    (cons (_ "dotkievan") "dots.dotkievan")
))

(cons (_ "...") (list 
    (cons (_ "space") "space")
    (cons (_ "plus") "plus")
    (cons (_ "comma") "comma")
    (cons (_ "hyphen") "hyphen")
    (cons (_ "period") "period")
    (cons (_ "zero") "zero")
    (cons (_ "one") "one")
    (cons (_ "two") "two")
    (cons (_ "three") "three")
    (cons (_ "four") "four")
    (cons (_ "five") "five")
    (cons (_ "six") "six")
    (cons (_ "seven") "seven")
    (cons (_ "eight") "eight")
    (cons (_ "nine") "nine")
    (cons (_ "f") "f")
    (cons (_ "m") "m")
    (cons (_ "p") "p")
    (cons (_ "r") "r")
    (cons (_ "s") "s")
    (cons (_ "z") "z")
))
))
(if choice
    (set! choice (RadioBoxMenuList choice)))
(if choice
    (begin
        (StandAloneDirectiveProto (cons tag (string-append "^\\markup {\\musicglyph #\"" choice "\"} ")) #f #f choice)
        (d-DirectivePut-standalone-prefix tag "<>")
   	 (d-SetSaved #f))))
   
