// Copyright (C) 2000 Open Source Telecom Corporation.
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software 
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

#include <server.h>

#ifdef	CCXX_NAMESPACES
namespace ost {
#endif

#define	MWI_INDEX_SIZE	793

typedef struct	_mwi
{
	struct _mwi *byport;
	struct _mwi *next;
	char	number[16];
	unsigned count;
	unsigned prior;
	bool purge;
}	mwidata_t;

class MWI : private Module, protected Mutex, protected Keydata, protected Sync
{
protected:
	mwidata_t	*freelist;
	mwidata_t	*index[MWI_INDEX_SIZE];
	mwidata_t	**byport;
	volatile	bool updated;

	modtype_t getType(void)
		{return MODULE_NOTIFY;};

	char *getName(void)
		{return "mwi";};

	char *getSyncName(void)
		{return "mwi";};

	bool isScheduled(void)
		{return updated;};

	void schedule(void)
		{saveDatabase();};	

	void saveDatabase(void);
	mwidata_t *getNumber(const char *key);
	mwidata_t *addNumber(const char *key);
	void delNumber(const char *key);
	mwidata_t *addLink(unsigned id, const char *key);
	mwidata_t *getLink(unsigned id, const char *key);
	void delLink(unsigned id, const char *key);
	mwidata_t *getFirst(unsigned id);

	char *dispatch(Trunk *trunk);

	MWI();
	~MWI();
};

#ifdef	CCXX_NAMESPACES
};
#endif
