/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.decorator;

import java.util.BitSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Vector;
import javax.swing.event.EventListenerList;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.decorator.Filter;
import org.jdesktop.swingx.decorator.PipelineEvent;
import org.jdesktop.swingx.decorator.PipelineListener;
import org.jdesktop.swingx.decorator.ShuttleSorter;
import org.jdesktop.swingx.decorator.SortController;
import org.jdesktop.swingx.decorator.SortKey;
import org.jdesktop.swingx.decorator.SortOrder;
import org.jdesktop.swingx.decorator.Sorter;

public class FilterPipeline {
    protected EventListenerList listenerList = new EventListenerList();
    private ComponentAdapter adapter = null;
    private Sorter sorter = null;
    private final Filter[] filters;
    private SortController sortController;

    public FilterPipeline() {
        this(new Filter[0]);
    }

    public FilterPipeline(Filter ... inList) {
        this.filters = this.reorderSorters(inList, this.locateSorters(inList));
        this.assignFilters();
    }

    private void assignFilters() {
        for (int i = 0; i < this.filters.length; ++i) {
            this.filters[i].assign(this, i);
        }
    }

    protected void setSorter(Sorter sorter) {
        Sorter oldSorter = this.getSorter();
        if (oldSorter == sorter) {
            return;
        }
        if (oldSorter != null) {
            oldSorter.assign((FilterPipeline)null);
        }
        this.sorter = sorter;
        if (sorter != null) {
            sorter.assign((FilterPipeline)null);
            sorter.assign(this);
            if (this.adapter != null) {
                sorter.assign(this.adapter);
                sorter.refresh();
            }
        }
        if (sorter == null && this.isAssigned()) {
            this.fireContentsChanged();
        }
    }

    protected Sorter getSorter() {
        return this.sorter;
    }

    public SortController getSortController() {
        if (this.sortController == null) {
            this.sortController = this.createDefaultSortController();
        }
        return this.sortController;
    }

    protected SortController createDefaultSortController() {
        return new SorterBasedSortController();
    }

    public final void assign(ComponentAdapter adapter) {
        if (adapter == null) {
            throw new IllegalArgumentException("null adapter");
        }
        if (this.adapter == null) {
            this.adapter = adapter;
            for (int i = 0; i < this.filters.length; ++i) {
                this.filters[i].assign(adapter);
            }
            if (this.sorter != null) {
                this.sorter.assign(adapter);
            }
            this.flush();
        } else if (this.adapter != adapter) {
            throw new IllegalStateException("Can't bind to a different adapter");
        }
    }

    public boolean isAssigned() {
        return this.adapter != null;
    }

    boolean contains(Filter filter) {
        return filter.equals(this.sorter) || filter.order >= 0 && this.filters.length > 0 && this.filters[filter.order] == filter;
    }

    Filter first() {
        return this.filters.length > 0 ? this.filters[0] : null;
    }

    Filter last() {
        if (this.sorter != null) {
            return this.sorter;
        }
        return this.filters.length > 0 ? this.filters[this.filters.length - 1] : null;
    }

    Filter next(Filter filter) {
        if (this.last().equals(filter)) {
            return null;
        }
        return filter.order + 1 < this.filters.length ? this.filters[filter.order + 1] : this.getSorter();
    }

    Filter previous(Filter filter) {
        if (filter.equals(this.sorter)) {
            return this.filters.length > 0 ? this.filters[this.filters.length - 1] : null;
        }
        return this.first().equals(filter) ? null : this.filters[filter.order - 1];
    }

    protected void filterChanged(Filter filter) {
        Filter next = this.next(filter);
        if (next == null) {
            this.fireContentsChanged();
        } else {
            next.refresh();
        }
    }

    public int getInputSize() {
        return this.isAssigned() ? this.adapter.getRowCount() : 0;
    }

    int getInputSize(Filter filter) {
        Filter previous = this.previous(filter);
        if (previous != null) {
            return previous.getSize();
        }
        return this.getInputSize();
    }

    public int getOutputSize() {
        if (!this.isAssigned()) {
            return 0;
        }
        Filter last = this.last();
        return last == null ? this.adapter.getRowCount() : last.getSize();
    }

    public int convertRowIndexToModel(int row) {
        Filter last = this.last();
        return last == null ? row : last.convertRowIndexToModel(row);
    }

    public int convertRowIndexToView(int row) {
        Filter last = this.last();
        return last == null ? row : last.convertRowIndexToView(row);
    }

    public Object getValueAt(int row, int column) {
        Filter last = this.last();
        return last == null ? null : last.getValueAt(row, column);
    }

    public void setValueAt(Object aValue, int row, int column) {
        Filter last = this.last();
        if (last != null) {
            last.setValueAt(aValue, row, column);
        }
    }

    public boolean isCellEditable(int row, int column) {
        Filter last = this.last();
        return last == null ? false : last.isCellEditable(row, column);
    }

    public void flush() {
        if (this.filters != null && this.filters.length > 0) {
            this.filters[0].refresh();
        } else if (this.sorter != null) {
            this.sorter.refresh();
        }
    }

    public void addPipelineListener(PipelineListener l) {
        this.listenerList.add(PipelineListener.class, l);
    }

    public void removePipelineListener(PipelineListener l) {
        this.listenerList.remove(PipelineListener.class, l);
    }

    public PipelineListener[] getPipelineListeners() {
        return (PipelineListener[])this.listenerList.getListeners(PipelineListener.class);
    }

    protected void fireContentsChanged() {
        Object[] listeners = this.listenerList.getListenerList();
        PipelineEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != PipelineListener.class) continue;
            if (e == null) {
                e = new PipelineEvent(this, 0);
            }
            ((PipelineListener)listeners[i + 1]).contentsChanged(e);
        }
    }

    protected void fireSortOrderChanged() {
        Object[] listeners = this.listenerList.getListenerList();
        PipelineEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != PipelineListener.class) continue;
            if (e == null) {
                e = new PipelineEvent(this, 1);
            }
            ((PipelineListener)listeners[i + 1]).contentsChanged(e);
        }
    }

    private List locateSorters(Filter[] inList) {
        BitSet sortableColumns = new BitSet();
        Vector<Integer> sorterLocations = new Vector<Integer>();
        for (int i = 0; i < inList.length; ++i) {
            if (!(inList[i] instanceof Sorter)) continue;
            int columnIndex = inList[i].getColumnIndex();
            if (columnIndex < 0) {
                throw new IndexOutOfBoundsException("Negative column index for filter: " + inList[i]);
            }
            if (sortableColumns.get(columnIndex)) {
                throw new IllegalArgumentException("Filter " + i + " attempting to overwrite sorter for column " + columnIndex);
            }
            sortableColumns.set(columnIndex);
            sorterLocations.add(i);
        }
        return sorterLocations;
    }

    private Filter[] reorderSorters(Filter[] inList, List sorterLocations) {
        if (inList.length == 0) {
            return new Filter[]{new IdentityFilter()};
        }
        Filter[] outList = (Filter[])inList.clone();
        int max = sorterLocations.size() - 1;
        for (int i = 0; i <= max; ++i) {
            int orig = (Integer)sorterLocations.get(max - i);
            int copy = (Integer)sorterLocations.get(i);
            outList[copy] = inList[orig];
        }
        return outList;
    }

    public class IdentityFilter
    extends Filter {
        public void refresh() {
            super.refresh();
        }

        protected void init() {
        }

        protected void reset() {
        }

        protected void filter() {
        }

        public int getSize() {
            return this.getInputSize();
        }

        protected int mapTowardModel(int row) {
            return row;
        }

        protected int mapTowardView(int row) {
            return row;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class SorterBasedSortController
    implements SortController {
        protected SorterBasedSortController() {
        }

        @Override
        public void toggleSortOrder(int column) {
            this.toggleSortOrder(column, null);
        }

        @Override
        public void toggleSortOrder(int column, Comparator comparator) {
            Sorter currentSorter = FilterPipeline.this.getSorter();
            if (currentSorter != null && currentSorter.getColumnIndex() == column) {
                currentSorter.toggle();
            } else {
                FilterPipeline.this.setSorter(this.createDefaultSorter(new SortKey(SortOrder.ASCENDING, column, comparator)));
            }
        }

        @Override
        public void setSortKeys(List<? extends SortKey> keys) {
            if (keys == null || keys.isEmpty()) {
                FilterPipeline.this.setSorter(null);
                return;
            }
            SortKey sortKey = SortKey.getFirstSortingKey(keys);
            if (sortKey == null) {
                return;
            }
            Sorter sorter = FilterPipeline.this.getSorter();
            if (sorter == null) {
                sorter = this.createDefaultSorter();
            }
            sorter.setSortKey(sortKey);
            FilterPipeline.this.setSorter(sorter);
        }

        protected Sorter createDefaultSorter(SortKey sortKey) {
            Sorter sorter = this.createDefaultSorter();
            sorter.setSortKey(sortKey);
            return sorter;
        }

        protected Sorter createDefaultSorter() {
            return new ShuttleSorter();
        }

        @Override
        public List<? extends SortKey> getSortKeys() {
            Sorter sorter = FilterPipeline.this.getSorter();
            if (sorter == null) {
                return Collections.EMPTY_LIST;
            }
            return Collections.singletonList(sorter.getSortKey());
        }

        @Override
        public SortOrder getSortOrder(int column) {
            Sorter sorter = FilterPipeline.this.getSorter();
            if (sorter == null || sorter.getColumnIndex() != column) {
                return SortOrder.UNSORTED;
            }
            return sorter.getSortOrder();
        }
    }
}

