/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.modbus.net;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import net.wimpi.modbus.io.ModbusTCPRTUTransport;
import net.wimpi.modbus.io.ModbusTCPTransport;
import net.wimpi.modbus.io.ModbusTransport;
import net.wimpi.modbus.net.ModbusSlaveConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TCPMasterConnection
implements ModbusSlaveConnection {
    private static final Logger logger = LoggerFactory.getLogger(TCPMasterConnection.class);
    private Socket m_Socket;
    private int m_Timeout = 3000;
    private boolean m_Connected;
    private InetAddress m_Address;
    private int m_Port = 502;
    private ModbusTCPTransport m_ModbusTransport;
    private int m_ConnectTimeoutMillis;
    private boolean rtuEncoded;

    public TCPMasterConnection(InetAddress adr) {
        this.m_Address = adr;
    }

    public TCPMasterConnection(InetAddress adr, int port) {
        this(adr);
        this.setPort(port);
    }

    public TCPMasterConnection(InetAddress adr, int port, int connectTimeoutMillis, boolean rtuEncoded) {
        this(adr, port);
        this.setConnectTimeoutMillis(connectTimeoutMillis);
        this.rtuEncoded = rtuEncoded;
    }

    @Override
    public synchronized boolean connect() throws Exception {
        if (!this.isConnected()) {
            logger.debug("connect()");
            this.m_Socket = new Socket();
            this.m_Socket.connect(new InetSocketAddress(this.m_Address, this.m_Port), this.m_ConnectTimeoutMillis);
            this.setTimeout(this.m_Timeout);
            this.m_Socket.setReuseAddress(true);
            this.m_Socket.setSoLinger(true, 1);
            this.m_Socket.setKeepAlive(true);
            this.prepareTransport();
            this.m_Connected = true;
        }
        return this.m_Connected;
    }

    public void close() {
        if (this.m_Connected) {
            try {
                this.m_ModbusTransport.close();
            }
            catch (IOException ex) {
                logger.warn("close()", (Throwable)ex);
            }
            this.m_Connected = false;
        }
    }

    public ModbusTransport getModbusTransport() {
        return this.m_ModbusTransport;
    }

    private void prepareTransport() throws IOException {
        if (this.m_ModbusTransport == null) {
            this.m_ModbusTransport = this.rtuEncoded ? new ModbusTCPRTUTransport(this.m_Socket) : new ModbusTCPTransport(this.m_Socket);
        } else {
            this.m_ModbusTransport.setSocket(this.m_Socket);
        }
    }

    public int getTimeout() {
        return this.m_Timeout;
    }

    public void setTimeout(int timeout) {
        this.m_Timeout = timeout;
        if (this.m_Socket != null) {
            try {
                this.m_Socket.setSoTimeout(this.m_Timeout);
            }
            catch (IOException ex) {
                logger.warn("Could not set socket timeout on connection {} {}: {}", new Object[]{this.getAddress(), this.getPort(), ex.getMessage()});
            }
        }
    }

    public int getPort() {
        return this.m_Port;
    }

    public void setPort(int port) {
        this.m_Port = port;
    }

    public InetAddress getAddress() {
        return this.m_Address;
    }

    public void setAddress(InetAddress adr) {
        this.m_Address = adr;
    }

    @Override
    public boolean isConnected() {
        if (this.m_Connected && this.m_Socket != null && (!this.m_Socket.isConnected() || this.m_Socket.isClosed() || this.m_Socket.isInputShutdown() || this.m_Socket.isOutputShutdown())) {
            this.close();
        }
        return this.m_Connected;
    }

    @Override
    public void resetConnection() {
        this.close();
    }

    public String toString() {
        return "TCPMasterConnection [m_Socket=" + this.m_Socket + ", m_Timeout=" + this.m_Timeout + ", m_Connected=" + this.m_Connected + ", m_Address=" + this.m_Address + ", m_Port=" + this.m_Port + ", m_ModbusTransport=" + this.m_ModbusTransport + ", m_ConnectTimeoutMillis=" + this.m_ConnectTimeoutMillis + ", rtuEncoded=" + this.rtuEncoded + "]";
    }

    public int getConnectTimeoutMillis() {
        return this.m_ConnectTimeoutMillis;
    }

    public void setConnectTimeoutMillis(int m_ConnectTimeoutMillis) {
        this.m_ConnectTimeoutMillis = m_ConnectTimeoutMillis;
    }
}

