/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.spec.html5;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import nu.validator.datatype.AbstractDatatype;
import nu.validator.datatype.Html5DatatypeLibrary;
import nu.validator.htmlparser.common.XmlViolationPolicy;
import nu.validator.htmlparser.sax.HtmlParser;
import nu.validator.saxtree.DocumentFragment;
import nu.validator.saxtree.TreeBuilder;
import nu.validator.xml.AttributesImpl;
import nu.validator.xml.EmptyAttributes;
import org.relaxng.datatype.DatatypeException;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public final class Html5AttributeDatatypeBuilder
implements ContentHandler {
    private static final String NS = "http://www.w3.org/1999/xhtml";
    private State state = State.AWAITING_WIKI_BODY;
    private Class currentClass = null;
    private int depth = 0;
    private StringBuilder stringBuilder = new StringBuilder();
    private Html5DatatypeLibrary datatypeLibrary = new Html5DatatypeLibrary();
    private TreeBuilder treeBuilder;
    private Map<Class, DocumentFragment> adviceByClass = new HashMap<Class, DocumentFragment>();

    public static Map<Class, DocumentFragment> parseSyntaxDescriptions() throws IOException, SAXException {
        HtmlParser parser = new HtmlParser(XmlViolationPolicy.ALTER_INFOSET);
        Html5AttributeDatatypeBuilder handler = new Html5AttributeDatatypeBuilder();
        parser.setContentHandler(handler);
        InputSource in = new InputSource(Html5AttributeDatatypeBuilder.class.getClassLoader().getResourceAsStream("nu/validator/localentities/files/syntax-descriptions"));
        parser.parse(in);
        return handler.getAdvice();
    }

    public static void main(String[] args) throws IOException, SAXException {
        Html5AttributeDatatypeBuilder.parseSyntaxDescriptions();
    }

    private Html5AttributeDatatypeBuilder() {
    }

    @Override
    public void startDocument() throws SAXException {
        this.state = State.AWAITING_WIKI_BODY;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        switch (this.state.ordinal()) {
            case 0: {
                if ("wiki-body".equals(atts.getValue("", "id"))) {
                    this.state = State.AWAITING_H3;
                }
                return;
            }
            case 1: {
                if ("h3" == localName && NS == uri) {
                    this.depth = 0;
                    this.state = State.IN_HEADLINE;
                }
                return;
            }
            case 2: {
                this.stringBuilder.setLength(0);
                ++this.depth;
                return;
            }
            case 3: {
                if (NS == uri && "p" == localName) {
                    this.treeBuilder.startElement(NS, "dd", "dd", EmptyAttributes.EMPTY_ATTRIBUTES);
                    this.state = State.IN_P;
                } else {
                    this.state = State.AWAITING_H3;
                }
                return;
            }
            case 4: {
                ++this.depth;
                String href = null;
                if (NS == uri && "a" == localName && (href = atts.getValue("", "href")) != null) {
                    AttributesImpl ai = new AttributesImpl();
                    ai.addAttribute("href", href);
                    this.treeBuilder.startElement(uri, localName, qName, ai);
                    break;
                }
                this.treeBuilder.startElement(uri, localName, qName, EmptyAttributes.EMPTY_ATTRIBUTES);
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        switch (this.state.ordinal()) {
            case 0: 
            case 1: {
                return;
            }
            case 2: {
                if (this.depth == 0) {
                    try {
                        String name = this.stringBuilder.toString();
                        AbstractDatatype datatype = (AbstractDatatype)this.datatypeLibrary.createDatatype(name);
                        this.currentClass = datatype.getClass();
                        this.treeBuilder = new TreeBuilder(true, true);
                        this.treeBuilder.startElement(NS, "dt", "dt", EmptyAttributes.EMPTY_ATTRIBUTES);
                        String dt = "Syntax of " + datatype.getName() + ":";
                        this.treeBuilder.characters(dt.toCharArray(), 0, dt.length());
                        this.treeBuilder.endElement(NS, "dt", "dt");
                        this.state = State.AWAITING_P;
                    }
                    catch (DatatypeException e) {
                        System.out.println(String.format("Warning: No datatype class for \"%s\".", this.stringBuilder.toString().trim()));
                        this.state = State.AWAITING_H3;
                    }
                } else {
                    --this.depth;
                }
                return;
            }
            case 3: {
                this.state = State.AWAITING_H3;
                return;
            }
            case 4: {
                if (this.depth == 0) {
                    this.treeBuilder.endElement(NS, "dt", "dt");
                    this.adviceByClass.put(this.currentClass, (DocumentFragment)this.treeBuilder.getRoot());
                    this.state = State.AWAITING_H3;
                } else {
                    --this.depth;
                    this.treeBuilder.endElement(uri, localName, qName);
                }
                return;
            }
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        switch (this.state.ordinal()) {
            case 2: {
                this.stringBuilder.append(ch, start, length);
                return;
            }
            case 4: {
                this.treeBuilder.characters(ch, start, length);
                return;
            }
        }
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    private Map<Class, DocumentFragment> getAdvice() {
        return this.adviceByClass;
    }

    private static enum State {
        AWAITING_WIKI_BODY,
        AWAITING_H3,
        IN_HEADLINE,
        AWAITING_P,
        IN_P;

    }
}

