/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.servlet;

import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import java.util.TreeMap;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public class TreeDumpContentHandler
implements ContentHandler,
LexicalHandler {
    private final Writer writer;
    private int level = 0;
    private boolean inCharacters = false;
    private boolean close;

    public TreeDumpContentHandler(Writer writer, boolean close) {
        this.writer = writer;
        this.close = close;
    }

    public TreeDumpContentHandler(Writer writer) {
        this(writer, true);
    }

    private void printLead() throws IOException {
        if (this.inCharacters) {
            this.writer.write("\"\n");
            this.inCharacters = false;
        }
        this.writer.write("| ");
        for (int i = 0; i < this.level; ++i) {
            this.writer.write("  ");
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        try {
            if (!this.inCharacters) {
                this.printLead();
                this.writer.write(34);
                this.inCharacters = true;
            }
            this.writer.write(ch, start, length);
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        try {
            if (this.inCharacters) {
                this.writer.write("\"\n");
                this.inCharacters = false;
            }
            --this.level;
            if ("http://www.w3.org/1999/xhtml" == uri && "template".equals(localName)) {
                --this.level;
            }
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        try {
            this.printLead();
            this.writer.write(60);
            if ("http://www.w3.org/1998/Math/MathML" == uri) {
                this.writer.write("math ");
            } else if ("http://www.w3.org/2000/svg" == uri) {
                this.writer.write("svg ");
            } else if ("http://www.w3.org/1999/xhtml" != uri) {
                this.writer.write("otherns ");
            }
            this.writer.write(localName);
            this.writer.write(">\n");
            ++this.level;
            if ("http://www.w3.org/1999/xhtml" == uri && "template".equals(localName)) {
                this.printLead();
                this.writer.write("content\n");
                ++this.level;
            }
            TreeMap<String, String> map = new TreeMap<String, String>();
            for (int i = 0; i < atts.getLength(); ++i) {
                String ns = atts.getURI(i);
                String name = "http://www.w3.org/1999/xlink" == ns ? "xlink " + atts.getLocalName(i) : ("http://www.w3.org/XML/1998/namespace" == ns ? "xml " + atts.getLocalName(i) : ("http://www.w3.org/2000/xmlns/" == ns ? "xmlns " + atts.getLocalName(i) : ("" != uri ? atts.getLocalName(i) : "otherns " + atts.getLocalName(i))));
                map.put(name, atts.getValue(i));
            }
            for (Map.Entry entry : map.entrySet()) {
                this.printLead();
                this.writer.write((String)entry.getKey());
                this.writer.write("=\"");
                this.writer.write((String)entry.getValue());
                this.writer.write("\"\n");
            }
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void comment(char[] ch, int offset, int len) throws SAXException {
        try {
            this.printLead();
            this.writer.write("<!-- ");
            this.writer.write(ch, offset, len);
            this.writer.write(" -->\n");
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void startDTD(String name, String publicIdentifier, String systemIdentifier) throws SAXException {
        try {
            this.printLead();
            this.writer.write("<!DOCTYPE ");
            this.writer.write(name);
            if (publicIdentifier.length() > 0 || systemIdentifier.length() > 0) {
                this.writer.write(32);
                this.writer.write(34);
                this.writer.write(publicIdentifier);
                this.writer.write(34);
                this.writer.write(32);
                this.writer.write(34);
                this.writer.write(systemIdentifier);
                this.writer.write(34);
            }
            this.writer.write(">\n");
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void endDocument() throws SAXException {
        try {
            if (this.inCharacters) {
                this.writer.write("\"\n");
                this.inCharacters = false;
            }
            if (this.close) {
                this.writer.flush();
                this.writer.close();
            }
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    @Override
    public void startEntity(String arg0) throws SAXException {
    }

    @Override
    public void endCDATA() throws SAXException {
    }

    @Override
    public void endDTD() throws SAXException {
    }

    @Override
    public void endEntity(String arg0) throws SAXException {
    }

    @Override
    public void startCDATA() throws SAXException {
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
    }

    @Override
    public void startDocument() throws SAXException {
    }
}

