/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.table;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.event.EventListenerList;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import org.jdesktop.swingx.event.TableColumnModelExtListener;
import org.jdesktop.swingx.table.TableColumnExt;
import org.jdesktop.swingx.table.TableColumnModelExt;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultTableColumnModelExt
extends DefaultTableColumnModel
implements TableColumnModelExt {
    private static final String IGNORE_EVENT = "TableColumnModelExt.ignoreEvent";
    private List<TableColumn> initialColumns = new ArrayList<TableColumn>();
    private List<TableColumn> currentColumns = new ArrayList<TableColumn>();
    private VisibilityListener visibilityListener = new VisibilityListener();

    @Override
    public List<TableColumn> getColumns(boolean includeHidden) {
        if (includeHidden) {
            return new ArrayList<TableColumn>(this.initialColumns);
        }
        return Collections.list(this.getColumns());
    }

    @Override
    public int getColumnCount(boolean includeHidden) {
        if (includeHidden) {
            return this.initialColumns.size();
        }
        return this.getColumnCount();
    }

    @Override
    public TableColumnExt getColumnExt(Object identifier) {
        for (TableColumn column : this.initialColumns) {
            if (!(column instanceof TableColumnExt) || !identifier.equals(column.getIdentifier())) continue;
            return (TableColumnExt)column;
        }
        return null;
    }

    @Override
    public TableColumnExt getColumnExt(int columnIndex) {
        TableColumn column = this.getColumn(columnIndex);
        if (column instanceof TableColumnExt) {
            return (TableColumnExt)column;
        }
        return null;
    }

    public boolean isRemovedToInvisibleEvent(int oldIndex) {
        if (oldIndex >= this.currentColumns.size()) {
            return false;
        }
        if (!(this.currentColumns.get(oldIndex) instanceof TableColumnExt)) {
            return false;
        }
        return Boolean.TRUE.equals(((TableColumnExt)this.currentColumns.get(oldIndex)).getClientProperty(IGNORE_EVENT));
    }

    public boolean isAddedFromInvisibleEvent(int newIndex) {
        if (!(this.getColumn(newIndex) instanceof TableColumnExt)) {
            return false;
        }
        return Boolean.TRUE.equals(((TableColumnExt)this.getColumn(newIndex)).getClientProperty(IGNORE_EVENT));
    }

    @Override
    public void removeColumn(TableColumn column) {
        if (column instanceof TableColumnExt) {
            ((TableColumnExt)column).removePropertyChangeListener(this.visibilityListener);
        }
        this.currentColumns.remove(column);
        this.initialColumns.remove(column);
        super.removeColumn(column);
    }

    @Override
    public void addColumn(TableColumn aColumn) {
        boolean oldVisible = true;
        if (aColumn instanceof TableColumnExt) {
            TableColumnExt xColumn = (TableColumnExt)aColumn;
            oldVisible = xColumn.isVisible();
            xColumn.setVisible(true);
            xColumn.addPropertyChangeListener(this.visibilityListener);
        }
        this.currentColumns.add(aColumn);
        this.initialColumns.add(aColumn);
        super.addColumn(aColumn);
        if (aColumn instanceof TableColumnExt) {
            ((TableColumnExt)aColumn).setVisible(oldVisible);
        }
    }

    @Override
    public void moveColumn(int columnIndex, int newIndex) {
        if (columnIndex != newIndex) {
            this.updateCurrentColumns(columnIndex, newIndex);
        }
        super.moveColumn(columnIndex, newIndex);
    }

    private void updateCurrentColumns(int oldIndex, int newIndex) {
        TableColumn movedColumn = (TableColumn)this.tableColumns.elementAt(oldIndex);
        int oldPosition = this.currentColumns.indexOf(movedColumn);
        TableColumn targetColumn = (TableColumn)this.tableColumns.elementAt(newIndex);
        int newPosition = this.currentColumns.indexOf(targetColumn);
        this.currentColumns.remove(oldPosition);
        this.currentColumns.add(newPosition, movedColumn);
    }

    protected void moveToInvisible(TableColumnExt col) {
        col.putClientProperty(IGNORE_EVENT, Boolean.TRUE);
        super.removeColumn(col);
        col.putClientProperty(IGNORE_EVENT, null);
    }

    protected void moveToVisible(TableColumnExt col) {
        col.putClientProperty(IGNORE_EVENT, Boolean.TRUE);
        super.addColumn(col);
        Integer addIndex = this.currentColumns.indexOf(col);
        for (int i = 0; i < this.getColumnCount() - 1; ++i) {
            TableColumn tableCol = this.getColumn(i);
            int actualPosition = this.currentColumns.indexOf(tableCol);
            if (actualPosition <= addIndex) continue;
            super.moveColumn(this.getColumnCount() - 1, i);
            break;
        }
        col.putClientProperty(IGNORE_EVENT, null);
    }

    protected EventListenerList getEventListenerList() {
        return this.listenerList;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        super.propertyChange(evt);
        this.fireColumnPropertyChange(evt);
    }

    protected void fireColumnPropertyChange(PropertyChangeEvent evt) {
        if (IGNORE_EVENT.equals(evt.getPropertyName())) {
            return;
        }
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TableColumnModelExtListener.class) continue;
            ((TableColumnModelExtListener)listeners[i + 1]).columnPropertyChange(evt);
        }
    }

    @Override
    public void addColumnModelListener(TableColumnModelListener x) {
        super.addColumnModelListener(x);
        if (x instanceof TableColumnModelExtListener) {
            this.listenerList.add(TableColumnModelExtListener.class, (TableColumnModelExtListener)x);
        }
    }

    @Override
    public void removeColumnModelListener(TableColumnModelListener x) {
        super.removeColumnModelListener(x);
        if (x instanceof TableColumnModelExtListener) {
            this.listenerList.remove(TableColumnModelExtListener.class, (TableColumnModelExtListener)x);
        }
    }

    public TableColumnModelExtListener[] getTableColumnModelExtListeners() {
        return (TableColumnModelExtListener[])this.listenerList.getListeners(TableColumnModelExtListener.class);
    }

    private class VisibilityListener
    implements PropertyChangeListener,
    Serializable {
        private VisibilityListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if ("visible".equals(evt.getPropertyName())) {
                TableColumnExt columnExt = (TableColumnExt)evt.getSource();
                if (columnExt.isVisible()) {
                    DefaultTableColumnModelExt.this.moveToVisible(columnExt);
                    DefaultTableColumnModelExt.this.fireColumnPropertyChange(evt);
                } else {
                    DefaultTableColumnModelExt.this.moveToInvisible(columnExt);
                }
            } else if (!((TableColumnExt)evt.getSource()).isVisible()) {
                DefaultTableColumnModelExt.this.fireColumnPropertyChange(evt);
            }
        }
    }
}

