/*
 * Decompiled with CFR 0.152.
 */
package ddf.minim.signals;

import ddf.minim.AudioOutput;
import ddf.minim.AudioSignal;
import ddf.minim.signals.ADSR;

class Note
implements AudioSignal {
    private AudioOutput out;
    private AudioSignal sig;
    private ADSR env;
    private float[] amps;

    public Note(AudioSignal wave, ADSR envelope, AudioOutput output) {
        this.out = output;
        this.sig = wave;
        this.env = envelope;
        output.addSignal(this);
        this.env.trigger();
        this.amps = new float[output.bufferSize()];
    }

    public void generate(float[] signal) {
        this.sig.generate(signal);
        this.env.generate(this.amps);
        int i = 0;
        while (i < this.amps.length) {
            int n = i;
            signal[n] = signal[n] * this.amps[i];
            ++i;
        }
        if (this.env.done()) {
            this.out.removeSignal(this);
        }
    }

    public void generate(float[] left, float[] right) {
        this.sig.generate(left, right);
        this.env.generate(this.amps);
        int i = 0;
        while (i < this.amps.length) {
            int n = i;
            left[n] = left[n] * this.amps[i];
            int n2 = i;
            right[n2] = right[n2] * this.amps[i];
            ++i;
        }
        if (this.env.done()) {
            this.out.removeSignal(this);
        }
    }
}

