/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.coordinator.impl;

import java.util.Collection;
import java.util.Iterator;
import java.util.TimerTask;
import org.apache.felix.coordinator.impl.CoordinationImpl;
import org.apache.felix.coordinator.impl.CoordinationMgr;
import org.osgi.framework.Bundle;
import org.osgi.service.coordinator.Coordination;
import org.osgi.service.coordinator.CoordinationException;
import org.osgi.service.coordinator.CoordinationPermission;
import org.osgi.service.coordinator.Coordinator;
import org.osgi.service.coordinator.Participant;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoordinatorImpl
implements Coordinator {
    private final Bundle owner;
    private final CoordinationMgr mgr;

    CoordinatorImpl(Bundle owner, CoordinationMgr mgr) {
        this.owner = owner;
        this.mgr = mgr;
    }

    void dispose() {
        this.mgr.dispose(this.owner);
    }

    private void checkName(String name) {
        String[] parts;
        if (name.length() == 0) {
            throw new IllegalArgumentException("Name must not be an empty string");
        }
        for (String p : parts = name.split("\\.")) {
            boolean valid = true;
            if (p.length() == 0) {
                valid = false;
            } else {
                for (int i = 0; i < p.length(); ++i) {
                    char c = p.charAt(i);
                    if (c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_' || c == '-') continue;
                    valid = false;
                    break;
                }
            }
            if (valid) continue;
            throw new IllegalArgumentException("Name [" + name + "] does not comply with the symbolic-name definition.");
        }
    }

    public void checkPermission(String coordinationName, String actions) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            CoordinationPermission permission = new CoordinationPermission(coordinationName, this.owner, actions);
            securityManager.checkPermission(permission);
        }
    }

    @Override
    public Coordination create(String name, long timeout) {
        this.checkPermission(name, "initiate");
        this.checkName(name);
        if (timeout < 0L) {
            throw new IllegalArgumentException("Timeout must not be negative");
        }
        CoordinationMgr.CreationResult result = this.mgr.create(this, name, timeout);
        return result.holder;
    }

    @Override
    public Collection<Coordination> getCoordinations() {
        Collection<Coordination> result = this.mgr.getCoordinations();
        Iterator<Coordination> i = result.iterator();
        while (i.hasNext()) {
            Coordination c = i.next();
            try {
                this.checkPermission(c.getName(), "admin");
            }
            catch (SecurityException se) {
                i.remove();
            }
        }
        return result;
    }

    @Override
    public boolean fail(Throwable reason) {
        CoordinationImpl current = (CoordinationImpl)this.mgr.peek();
        if (current != null) {
            return current.fail(reason);
        }
        return false;
    }

    @Override
    public Coordination peek() {
        Coordination c = this.mgr.peek();
        if (c != null) {
            c = ((CoordinationImpl)c).getHolder();
        }
        return c;
    }

    @Override
    public Coordination begin(String name, long timeout) {
        this.checkPermission(name, "initiate");
        this.checkName(name);
        if (timeout < 0L) {
            throw new IllegalArgumentException("Timeout must not be negative");
        }
        CoordinationMgr.CreationResult result = this.mgr.create(this, name, timeout);
        this.mgr.push(result.coordination);
        return result.holder;
    }

    @Override
    public Coordination pop() {
        Coordination c = this.mgr.pop();
        if (c != null) {
            this.checkPermission(c.getName(), "initiate");
            c = ((CoordinationImpl)c).getHolder();
        }
        return c;
    }

    @Override
    public boolean addParticipant(Participant participant) {
        Coordination current = this.peek();
        if (current != null) {
            current.addParticipant(participant);
            return true;
        }
        return false;
    }

    @Override
    public Coordination getCoordination(long id) {
        Coordination c = this.mgr.getCoordinationById(id);
        if (c != null) {
            try {
                this.checkPermission(c.getName(), "admin");
                c = ((CoordinationImpl)c).getHolder();
            }
            catch (SecurityException e) {
                c = null;
            }
        }
        return c;
    }

    void push(CoordinationImpl c) {
        this.mgr.push(c);
    }

    void unregister(CoordinationImpl c, boolean removeFromStack) {
        this.mgr.unregister(c, removeFromStack);
    }

    void schedule(TimerTask task, long deadLine) {
        this.mgr.schedule(task, deadLine);
    }

    void lockParticipant(Participant p, CoordinationImpl c) {
        this.mgr.lockParticipant(p, c);
    }

    void releaseParticipant(Participant p) {
        this.mgr.releaseParticipant(p);
    }

    Bundle getBundle() {
        return this.owner;
    }

    Coordination getEnclosingCoordination(CoordinationImpl c) {
        return this.mgr.getEnclosingCoordination(c);
    }

    CoordinationException endNestedCoordinations(CoordinationImpl c) {
        return this.mgr.endNestedCoordinations(c);
    }
}

