/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.composer.ui.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.project.Project;
import org.netbeans.modules.php.api.executable.InvalidPhpExecutableException;
import org.netbeans.modules.php.api.phpmodule.PhpModule;
import org.netbeans.modules.php.composer.commands.Composer;
import org.netbeans.modules.php.composer.files.ComposerJson;
import org.netbeans.modules.php.composer.ui.actions.BaseComposerAction;
import org.netbeans.modules.php.composer.ui.actions.Bundle;
import org.openide.awt.Actions;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.actions.Presenter;

public class ComposerScriptsAction
extends AbstractAction
implements ContextAwareAction,
Presenter.Popup {
    private static final long serialVersionUID = -5103436278063173440L;
    @NullAllowed
    final Project project;
    final List<String> scripts = new CopyOnWriteArrayList<String>();

    public ComposerScriptsAction() {
        this((Project)null, (Collection<String>)null);
    }

    public ComposerScriptsAction(Project project, Collection<String> scripts) {
        this.project = project;
        if (scripts != null) {
            this.scripts.addAll(scripts);
        }
        this.setEnabled(project != null);
        this.putValue("hideWhenDisabled", true);
        this.putValue("Name", "");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        assert (false);
    }

    public Action createContextAwareInstance(Lookup context) {
        Project contextProject = (Project)context.lookup(Project.class);
        if (contextProject == null) {
            return this;
        }
        PhpModule phpModule = PhpModule.Factory.lookupPhpModule((Lookup)context);
        if (phpModule == null) {
            return this;
        }
        ComposerJson composerJson = new ComposerJson(phpModule.getProjectDirectory());
        Set<String> allScripts = composerJson.getScripts();
        if (allScripts.isEmpty()) {
            return this;
        }
        ArrayList<String> orderedScripts = new ArrayList<String>(allScripts);
        Collections.sort(orderedScripts);
        return new ComposerScriptsAction(contextProject, orderedScripts);
    }

    public JMenuItem getPopupPresenter() {
        if (this.project == null) {
            return new Actions.MenuItem((Action)this, false);
        }
        return this.createScriptsMenu();
    }

    private JMenuItem createScriptsMenu() {
        assert (this.project != null);
        assert (!this.scripts.isEmpty());
        JMenu menu = new JMenu(Bundle.ComposerScriptsAction_name());
        for (String command : this.scripts) {
            RunScriptAction scriptAction = new RunScriptAction(command);
            menu.add(scriptAction);
        }
        return menu;
    }

    private static class RunScriptAction
    extends BaseComposerAction {
        private final String script;

        public RunScriptAction(String script) {
            this.script = script;
            this.putValue("noIconInMenu", true);
            this.putValue("Name", script);
            this.putValue("ShortDescription", script);
            this.putValue("menuText", script);
        }

        @Override
        protected String getName() {
            return this.script;
        }

        @Override
        protected void runCommand(PhpModule phpModule) throws InvalidPhpExecutableException {
            Composer.getDefault().runScript(phpModule, this.script);
        }
    }
}

