/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.editor.overridden;

import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.progress.BaseProgressUtils;
import org.netbeans.editor.BaseAction;
import org.netbeans.modules.editor.java.GoToSupport;
import org.netbeans.modules.editor.java.JavaKit;
import org.netbeans.modules.java.editor.overridden.AnnotationType;
import org.netbeans.modules.java.editor.overridden.ComputeOverriding;
import org.netbeans.modules.java.editor.overridden.ElementDescription;
import org.netbeans.modules.java.editor.overridden.IsOverriddenAnnotationAction;
import org.openide.awt.StatusDisplayer;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class GoToSuperTypeAction
extends BaseAction {
    public GoToSuperTypeAction() {
        super("goto-super-implementation", 132);
        this.putValue("ShortDescription", NbBundle.getMessage(JavaKit.class, (String)"goto-super-implementation"));
        String name = NbBundle.getMessage(JavaKit.class, (String)"goto-super-implementation-trimmed");
        this.putValue("trimmed-text", name);
        this.putValue("PopupMenuText", name);
    }

    public void actionPerformed(ActionEvent evt, JTextComponent target) {
        JavaSource js = JavaSource.forDocument((Document)target.getDocument());
        if (js == null) {
            StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(GoToSupport.class, (String)"WARN_CannotGoToGeneric", (Object)1));
            return;
        }
        int caretPos = target.getCaretPosition();
        AtomicBoolean cancel = new AtomicBoolean();
        BaseProgressUtils.runOffEventDispatchThread(() -> GoToSuperTypeAction.goToImpl(target, js, caretPos, cancel), (String)NbBundle.getMessage(JavaKit.class, (String)"goto-super-implementation"), (AtomicBoolean)cancel, (boolean)false);
    }

    private static void goToImpl(JTextComponent c, JavaSource js, int caretPos, AtomicBoolean cancel) {
        try {
            js.runUserActionTask(controller -> {
                if (cancel != null && cancel.get()) {
                    return;
                }
                controller.toPhase(JavaSource.Phase.RESOLVED);
                ExecutableElement ee = GoToSuperTypeAction.resolveMethodElement((CompilationInfo)controller, caretPos);
                if (ee == null) {
                    ee = GoToSuperTypeAction.resolveMethodElement((CompilationInfo)controller, caretPos + 1);
                }
                if (ee == null) {
                    Toolkit.getDefaultToolkit().beep();
                    return;
                }
                ArrayList<ElementDescription> result = new ArrayList<ElementDescription>();
                AnnotationType type = ComputeOverriding.detectOverrides((CompilationInfo)controller, (TypeElement)ee.getEnclosingElement(), ee, result);
                if (type == null) {
                    Toolkit.getDefaultToolkit().beep();
                    return;
                }
                SwingUtilities.invokeLater(() -> {
                    try {
                        Point p = c.modelToView(c.getCaretPosition()).getLocation();
                        IsOverriddenAnnotationAction.mouseClicked(Map.of(IsOverriddenAnnotationAction.computeCaption(type, ""), result), c, p);
                    }
                    catch (BadLocationException e) {
                        Exceptions.printStackTrace((Throwable)e);
                    }
                });
            }, true);
        }
        catch (IOException e) {
            Exceptions.printStackTrace((Throwable)e);
        }
    }

    private static ExecutableElement resolveMethodElement(CompilationInfo info, int caret) {
        TreePath path;
        for (path = info.getTreeUtilities().pathFor(caret); path != null && path.getLeaf().getKind() != Tree.Kind.METHOD; path = path.getParentPath()) {
        }
        if (path == null) {
            return null;
        }
        Element resolved = info.getTrees().getElement(path);
        if (resolved == null || resolved.getKind() != ElementKind.METHOD) {
            return null;
        }
        return (ExecutableElement)resolved;
    }
}

