/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class AppCatalogSubscriptionSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="publisherName")
    private final String publisherName;
    @JsonProperty(value="listingId")
    private final String listingId;
    @JsonProperty(value="listingResourceVersion")
    private final String listingResourceVersion;
    @JsonProperty(value="listingResourceId")
    private final String listingResourceId;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="summary")
    private final String summary;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;

    @Deprecated
    @ConstructorProperties(value={"publisherName", "listingId", "listingResourceVersion", "listingResourceId", "displayName", "summary", "compartmentId", "timeCreated"})
    public AppCatalogSubscriptionSummary(String publisherName, String listingId, String listingResourceVersion, String listingResourceId, String displayName, String summary, String compartmentId, Date timeCreated) {
        this.publisherName = publisherName;
        this.listingId = listingId;
        this.listingResourceVersion = listingResourceVersion;
        this.listingResourceId = listingResourceId;
        this.displayName = displayName;
        this.summary = summary;
        this.compartmentId = compartmentId;
        this.timeCreated = timeCreated;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getPublisherName() {
        return this.publisherName;
    }

    public String getListingId() {
        return this.listingId;
    }

    public String getListingResourceVersion() {
        return this.listingResourceVersion;
    }

    public String getListingResourceId() {
        return this.listingResourceId;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getSummary() {
        return this.summary;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("AppCatalogSubscriptionSummary(");
        sb.append("super=").append(super.toString());
        sb.append("publisherName=").append(String.valueOf(this.publisherName));
        sb.append(", listingId=").append(String.valueOf(this.listingId));
        sb.append(", listingResourceVersion=").append(String.valueOf(this.listingResourceVersion));
        sb.append(", listingResourceId=").append(String.valueOf(this.listingResourceId));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", summary=").append(String.valueOf(this.summary));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AppCatalogSubscriptionSummary)) {
            return false;
        }
        AppCatalogSubscriptionSummary other = (AppCatalogSubscriptionSummary)((Object)o);
        return Objects.equals(this.publisherName, other.publisherName) && Objects.equals(this.listingId, other.listingId) && Objects.equals(this.listingResourceVersion, other.listingResourceVersion) && Objects.equals(this.listingResourceId, other.listingResourceId) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.summary, other.summary) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.timeCreated, other.timeCreated) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.publisherName == null ? 43 : this.publisherName.hashCode());
        result = result * 59 + (this.listingId == null ? 43 : this.listingId.hashCode());
        result = result * 59 + (this.listingResourceVersion == null ? 43 : this.listingResourceVersion.hashCode());
        result = result * 59 + (this.listingResourceId == null ? 43 : this.listingResourceId.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.summary == null ? 43 : this.summary.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="publisherName")
        private String publisherName;
        @JsonProperty(value="listingId")
        private String listingId;
        @JsonProperty(value="listingResourceVersion")
        private String listingResourceVersion;
        @JsonProperty(value="listingResourceId")
        private String listingResourceId;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="summary")
        private String summary;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder publisherName(String publisherName) {
            this.publisherName = publisherName;
            this.__explicitlySet__.add("publisherName");
            return this;
        }

        public Builder listingId(String listingId) {
            this.listingId = listingId;
            this.__explicitlySet__.add("listingId");
            return this;
        }

        public Builder listingResourceVersion(String listingResourceVersion) {
            this.listingResourceVersion = listingResourceVersion;
            this.__explicitlySet__.add("listingResourceVersion");
            return this;
        }

        public Builder listingResourceId(String listingResourceId) {
            this.listingResourceId = listingResourceId;
            this.__explicitlySet__.add("listingResourceId");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder summary(String summary) {
            this.summary = summary;
            this.__explicitlySet__.add("summary");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public AppCatalogSubscriptionSummary build() {
            AppCatalogSubscriptionSummary model = new AppCatalogSubscriptionSummary(this.publisherName, this.listingId, this.listingResourceVersion, this.listingResourceId, this.displayName, this.summary, this.compartmentId, this.timeCreated);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(AppCatalogSubscriptionSummary model) {
            if (model.wasPropertyExplicitlySet("publisherName")) {
                this.publisherName(model.getPublisherName());
            }
            if (model.wasPropertyExplicitlySet("listingId")) {
                this.listingId(model.getListingId());
            }
            if (model.wasPropertyExplicitlySet("listingResourceVersion")) {
                this.listingResourceVersion(model.getListingResourceVersion());
            }
            if (model.wasPropertyExplicitlySet("listingResourceId")) {
                this.listingResourceId(model.getListingResourceId());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("summary")) {
                this.summary(model.getSummary());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            return this;
        }
    }
}

