/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.wizards;

import java.awt.Component;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.php.api.framework.PhpFrameworks;
import org.netbeans.modules.php.project.ui.wizards.NewPhpProjectWizardIterator;
import org.netbeans.modules.php.project.ui.wizards.PhpFrameworksPanelVisual;
import org.netbeans.modules.php.spi.framework.PhpFrameworkProvider;
import org.netbeans.modules.php.spi.framework.PhpModuleExtender;
import org.openide.WizardDescriptor;
import org.openide.util.ChangeSupport;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class PhpFrameworksPanel
implements WizardDescriptor.Panel<WizardDescriptor>,
WizardDescriptor.FinishablePanel<WizardDescriptor>,
ChangeListener {
    static final String VALID = "PhpFrameworksPanel.valid";
    static final String EXTENDERS = "frameworks";
    private final String[] steps;
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private PhpFrameworksPanelVisual frameworksPanel = null;
    private WizardDescriptor descriptor = null;

    public PhpFrameworksPanel(String[] steps) {
        this.steps = (String[])steps.clone();
    }

    String[] getSteps() {
        return this.steps;
    }

    public Component getComponent() {
        if (this.frameworksPanel == null) {
            this.frameworksPanel = new PhpFrameworksPanelVisual(this, this.createExtenders());
        }
        return this.frameworksPanel;
    }

    public HelpCtx getHelp() {
        return new HelpCtx("org.netbeans.modules.php.project.ui.wizards.PhpFrameworksPanel");
    }

    public void readSettings(WizardDescriptor settings) {
        this.getComponent();
        this.descriptor = settings;
        this.frameworksPanel.addPhpFrameworksListener(this);
    }

    public void storeSettings(WizardDescriptor settings) {
        this.getComponent();
        this.frameworksPanel.removePhpFrameworksListener(this);
        this.descriptor.putProperty(EXTENDERS, this.frameworksPanel.getSelectedExtenders());
    }

    public boolean isValid() {
        this.getComponent();
        this.descriptor.putProperty("WizardPanel_errorMessage", (Object)" ");
        String error = null;
        String warning = null;
        PhpModuleExtender visibleExtender = this.frameworksPanel.getSelectedVisibleExtender();
        if (visibleExtender != null) {
            if (!visibleExtender.isValid()) {
                error = visibleExtender.getErrorMessage();
            }
            warning = visibleExtender.getWarningMessage();
        }
        HashSet<PhpFrameworkProvider> invalidFrameworks = new HashSet<PhpFrameworkProvider>();
        for (Map.Entry<PhpFrameworkProvider, PhpModuleExtender> entry : this.frameworksPanel.getSelectedExtenders().entrySet()) {
            PhpModuleExtender extender = entry.getValue();
            if (extender == null || extender.isValid()) continue;
            PhpFrameworkProvider frameworkProvider = entry.getKey();
            if (error == null) {
                error = NbBundle.getMessage(PhpFrameworksPanel.class, (String)"MSG_InvalidFramework", (Object)frameworkProvider.getName());
            }
            invalidFrameworks.add(frameworkProvider);
        }
        this.frameworksPanel.markInvalidFrameworks(invalidFrameworks);
        if (error != null) {
            this.descriptor.putProperty("WizardPanel_errorMessage", (Object)error);
            this.descriptor.putProperty(VALID, (Object)false);
            return false;
        }
        if (warning != null) {
            this.descriptor.putProperty("WizardPanel_warningMessage", (Object)warning);
        }
        this.descriptor.putProperty(VALID, (Object)true);
        return true;
    }

    public void addChangeListener(ChangeListener l) {
        this.changeSupport.addChangeListener(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.changeSupport.removeChangeListener(l);
    }

    public boolean isFinishPanel() {
        return NewPhpProjectWizardIterator.areAllStepsValid(this.descriptor);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.fireChangeEvent();
    }

    final void fireChangeEvent() {
        this.changeSupport.fireChange();
    }

    private Map<PhpFrameworkProvider, PhpModuleExtender> createExtenders() {
        LinkedHashMap<PhpFrameworkProvider, PhpModuleExtender> extenders = new LinkedHashMap<PhpFrameworkProvider, PhpModuleExtender>();
        for (PhpFrameworkProvider provider : PhpFrameworks.getFrameworks()) {
            PhpModuleExtender extender = provider.createPhpModuleExtender(null);
            if (extender == null) continue;
            extenders.put(provider, extender);
        }
        return extenders;
    }
}

