/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.environment;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import org.netbeans.modules.php.api.util.FileUtils;
import org.netbeans.modules.php.project.environment.PhpEnvironment;
import org.openide.util.NbBundle;

final class WindowsPhpEnvironment
extends PhpEnvironment {
    private static final String PHP = "php.exe";
    private static final PhpEnvironment XAMPP = new XamppPhpEnvironment();

    WindowsPhpEnvironment() {
    }

    @Override
    protected List<PhpEnvironment.DocumentRoot> getDocumentRoots(String projectName) {
        File root;
        File programFiles;
        File htDocs = null;
        Iterator<File> iterator = WindowsPhpEnvironment.getFsRoots().iterator();
        while (iterator.hasNext() && (htDocs = WindowsPhpEnvironment.findHtDocsDirectory(programFiles = new File(root = iterator.next(), "Program Files"), APACHE_FILENAME_FILTER)) == null) {
        }
        if (htDocs != null) {
            String documentRoot = WindowsPhpEnvironment.getFolderName(htDocs, projectName);
            String url = WindowsPhpEnvironment.getDefaultUrl(projectName);
            String hint = NbBundle.getMessage(WindowsPhpEnvironment.class, (String)"TXT_HtDocs");
            return Collections.singletonList(new PhpEnvironment.DocumentRoot(documentRoot, url, hint, FileUtils.isDirectoryWritable((File)htDocs)));
        }
        return XAMPP.getDocumentRoots(projectName);
    }

    @Override
    public List<String> getAllPhpInterpreters() {
        return WindowsPhpEnvironment.getAllPhpInterpreters(PHP);
    }

    private static List<File> getFsRoots() {
        File[] fsRoots = File.listRoots();
        if (fsRoots == null) {
            return Collections.emptyList();
        }
        ArrayList<File> result = new ArrayList<File>(fsRoots.length);
        for (File root : fsRoots) {
            LOGGER.log(Level.FINE, "FS root: {0}", root);
            if (WindowsPhpEnvironment.isFloppy(root)) {
                LOGGER.log(Level.FINE, "Skipping floppy: {0}", root);
                continue;
            }
            result.add(root);
        }
        return result;
    }

    private static boolean isFloppy(File root) {
        String absolutePath = root.getAbsolutePath();
        LOGGER.log(Level.FINE, "Testing floppy on {0}", absolutePath);
        return absolutePath.toLowerCase().startsWith("a:") || absolutePath.toLowerCase().startsWith("b:");
    }

    private static final class XamppPhpEnvironment
    extends PhpEnvironment {
        private static final String XAMPP = "xampp";
        private static final FilenameFilter XAMPP_FILENAME_FILTER = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.toLowerCase().startsWith(XamppPhpEnvironment.XAMPP);
            }
        };

        private XamppPhpEnvironment() {
        }

        @Override
        protected List<PhpEnvironment.DocumentRoot> getDocumentRoots(String projectName) {
            File programFiles;
            File root;
            File htDocs = null;
            Iterator iterator = WindowsPhpEnvironment.getFsRoots().iterator();
            while (iterator.hasNext() && !(htDocs = new File(new File(root = (File)iterator.next(), XAMPP), "htdocs")).isDirectory() && (htDocs = XamppPhpEnvironment.findHtDocsDirectory(programFiles = new File(root, "Program Files"), XAMPP_FILENAME_FILTER)) == null) {
            }
            if (htDocs != null) {
                String documentRoot = XamppPhpEnvironment.getFolderName(htDocs, projectName);
                String url = XamppPhpEnvironment.getDefaultUrl(projectName);
                String hint = NbBundle.getMessage(WindowsPhpEnvironment.class, (String)"TXT_XamppHtDocs");
                return Collections.singletonList(new PhpEnvironment.DocumentRoot(documentRoot, url, hint, FileUtils.isDirectoryWritable((File)htDocs)));
            }
            return Collections.emptyList();
        }

        @Override
        public List<String> getAllPhpInterpreters() {
            return Collections.emptyList();
        }
    }
}

