/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor.api.completion;

import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Arrays;
import javax.swing.ImageIcon;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.editor.completion.Completion;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.editor.indent.api.Indent;
import org.netbeans.modules.html.editor.HtmlPreferences;
import org.netbeans.modules.html.editor.completion.HtmlCompletionProvider;
import org.netbeans.modules.html.editor.javadoc.HelpManager;
import org.netbeans.modules.html.editor.lib.api.HelpItem;
import org.netbeans.modules.html.editor.lib.api.model.HtmlTag;
import org.netbeans.modules.html.editor.lib.api.model.HtmlTagAttribute;
import org.netbeans.modules.html.editor.lib.api.model.HtmlTagType;
import org.netbeans.modules.web.common.ui.api.FileReferenceCompletion;
import org.netbeans.spi.editor.completion.CompletionItem;
import org.netbeans.spi.editor.completion.CompletionTask;
import org.netbeans.spi.editor.completion.LazyCompletionItem;
import org.netbeans.spi.editor.completion.support.AsyncCompletionQuery;
import org.netbeans.spi.editor.completion.support.AsyncCompletionTask;
import org.netbeans.spi.editor.completion.support.CompletionUtilities;
import org.netbeans.swing.plaf.LFCustoms;
import org.openide.filesystems.FileObject;
import org.openide.util.ImageUtilities;
import org.openide.xml.XMLUtil;

public class HtmlCompletionItem
implements CompletionItem {
    protected static final int DEFAULT_SORT_PRIORITY = 20;
    private static final String END_FONT = "</font>";
    protected int substitutionOffset;
    protected String text;
    protected String helpId;
    protected boolean shift;
    protected HelpItem help;

    public static HtmlCompletionItem createTag(HtmlTag tag, String name, int substitutionOffset, String helpId, boolean possible) {
        return new Tag(tag, name, substitutionOffset, helpId, possible);
    }

    public static HtmlCompletionItem createEndTag(HtmlTag tag, String name, int substitutionOffset, String helpId, int order, EndTag.Type type) {
        return new EndTag(tag, name, substitutionOffset, helpId, order, type);
    }

    public static HtmlCompletionItem createEndTag(String name, int substitutionOffset, String helpId, int order, EndTag.Type type) {
        return new EndTag(name, substitutionOffset, helpId, order, type);
    }

    public static HtmlCompletionItem createAutocompleteEndTag(String name, int substitutionOffset) {
        return new AutocompleteEndTag(name, substitutionOffset);
    }

    public static HtmlCompletionItem createBooleanAttribute(String name, int substitutionOffset, boolean required, String helpId) {
        return new BooleanAttribute(name, substitutionOffset, required, helpId);
    }

    public static HtmlCompletionItem createAttribute(HtmlTagAttribute attribute, String name, int substitutionOffset, boolean required, String helpId) {
        return new Attribute(attribute, name, substitutionOffset, required, helpId);
    }

    public static HtmlCompletionItem createAttributeValue(String name, int substitutionOffset, boolean addQuotation) {
        return new AttributeValue(name, substitutionOffset, addQuotation);
    }

    public static HtmlCompletionItem createAttributeValue(String name, int substitutionOffset, boolean addQuotation, int sortPrioritiy) {
        return new AttributeValue(name, substitutionOffset, addQuotation, sortPrioritiy);
    }

    public static HtmlCompletionItem createAttributeValue(String name, int substitutionOffset) {
        return HtmlCompletionItem.createAttributeValue(name, substitutionOffset, false);
    }

    public static HtmlCompletionItem createCharacterReference(String name, char value, int substitutionOffset, String helpId) {
        return new CharRefItem(name, value, substitutionOffset, helpId);
    }

    public static HtmlCompletionItem createCssValue(String value, int substitutionOffset, boolean related) {
        return new HtmlCssValueCompletionItem(value, substitutionOffset, related);
    }

    @NonNull
    public static HtmlCompletionItem createFileCompletionItem(FileObject file, int substitutionOffset) {
        boolean folder = file.isFolder();
        String name = file.getNameExt() + (folder ? Character.valueOf('/') : "");
        Color color = folder ? new Color(224, 160, 65) : null;
        ImageIcon icon = FileReferenceCompletion.getIcon((FileObject)file);
        return new FileAttributeValue(folder, name, substitutionOffset, color, icon);
    }

    public static HtmlCompletionItem createGoUpFileCompletionItem(int substitutionOffset, Color color, ImageIcon icon) {
        return new GoUpFileAttributeValue(substitutionOffset, color, icon);
    }

    protected HtmlCompletionItem(HelpItem help, String text, int substitutionOffset, String helpId) {
        this(text, substitutionOffset, helpId);
        this.help = help;
    }

    protected HtmlCompletionItem(String text, int substituteOffset) {
        this.substitutionOffset = substituteOffset;
        this.text = text;
    }

    protected HtmlCompletionItem(String text, int substituteOffset, String helpId) {
        this(text, substituteOffset);
        this.helpId = helpId;
    }

    public String getItemText() {
        return this.text;
    }

    public int getSortPriority() {
        return 20;
    }

    public CharSequence getSortText() {
        return this.getItemText();
    }

    public CharSequence getInsertPrefix() {
        return this.getItemText();
    }

    public void processKeyEvent(KeyEvent e) {
        this.shift = e.getKeyCode() == 10 && e.getID() == 401 && e.isShiftDown();
    }

    public void defaultAction(JTextComponent component) {
        if (component != null) {
            int caretOffset;
            int len;
            if (!this.shift) {
                Completion.get().hideDocumentation();
                Completion.get().hideCompletion();
            }
            if ((len = (caretOffset = component.getSelectionEnd()) - this.substitutionOffset) >= 0) {
                this.substituteText(component, len);
            }
        }
    }

    public int getAnchorOffset() {
        return this.substitutionOffset;
    }

    protected int getMoveBackLength() {
        return 0;
    }

    protected String getSubstituteText() {
        return this.getItemText();
    }

    protected boolean substituteText(JTextComponent c, int len) {
        return this.substituteText(c, len, this.getMoveBackLength());
    }

    protected boolean substituteText(JTextComponent c, int len, int moveBack) {
        return this.substituteText(c, this.getSubstituteText(), len, moveBack);
    }

    protected boolean substituteText(final JTextComponent c, final String substituteText, final int len, int moveBack) {
        final BaseDocument doc = (BaseDocument)c.getDocument();
        final boolean[] result = new boolean[]{true};
        doc.runAtomic(new Runnable(){

            @Override
            public void run() {
                try {
                    String currentText = doc.getText(HtmlCompletionItem.this.substitutionOffset, doc.getLength() - HtmlCompletionItem.this.substitutionOffset < substituteText.length() ? doc.getLength() - HtmlCompletionItem.this.substitutionOffset : substituteText.length());
                    if (!substituteText.equals(currentText)) {
                        doc.remove(HtmlCompletionItem.this.substitutionOffset, len);
                        doc.insertString(HtmlCompletionItem.this.substitutionOffset, substituteText, null);
                    } else {
                        c.setCaretPosition(c.getSelectionEnd() + substituteText.length() - len);
                    }
                }
                catch (BadLocationException ex) {
                    result[0] = false;
                }
            }
        });
        this.reindent(c);
        if (moveBack != 0) {
            Caret caret = c.getCaret();
            int dot = caret.getDot();
            caret.setDot(dot - moveBack);
        }
        return result[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reindent(JTextComponent component) {
        final BaseDocument doc = (BaseDocument)component.getDocument();
        final int dotPos = component.getCaretPosition();
        final Indent indent = Indent.get((Document)doc);
        indent.lock();
        try {
            doc.runAtomic(new Runnable(){

                @Override
                public void run() {
                    try {
                        int startOffset = Utilities.getRowStart((BaseDocument)doc, (int)dotPos);
                        int endOffset = Utilities.getRowEnd((BaseDocument)doc, (int)dotPos);
                        indent.reindent(startOffset, endOffset);
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
            });
        }
        finally {
            indent.unlock();
        }
    }

    public boolean instantSubstitution(JTextComponent component) {
        if (component != null) {
            try {
                int caretOffset = component.getSelectionEnd();
                if (caretOffset > this.substitutionOffset) {
                    String currentText = component.getDocument().getText(this.substitutionOffset, caretOffset - this.substitutionOffset);
                    if (!this.getSubstituteText().toString().startsWith(currentText)) {
                        return false;
                    }
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        this.defaultAction(component);
        return true;
    }

    public int getPreferredWidth(Graphics g, Font defaultFont) {
        return CompletionUtilities.getPreferredWidth((String)this.getLeftHtmlText(), (String)this.getRightHtmlText(), (Graphics)g, (Font)defaultFont);
    }

    public void render(Graphics g, Font defaultFont, Color defaultColor, Color backgroundColor, int width, int height, boolean selected) {
        CompletionUtilities.renderHtml((ImageIcon)this.getIcon(), (String)this.getLeftHtmlText(), (String)this.getRightHtmlText(), (Graphics)g, (Font)defaultFont, (Color)defaultColor, (int)width, (int)height, (boolean)selected);
    }

    protected ImageIcon getIcon() {
        return null;
    }

    protected String getLeftHtmlText() {
        return this.getItemText();
    }

    protected String getRightHtmlText() {
        return null;
    }

    public String getHelpId() {
        return this.helpId;
    }

    public URL getHelpURL() {
        if (this.helpId == null || this.helpId.equals("")) {
            return null;
        }
        try {
            return new URL(this.helpId);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public String getHelp() {
        return HelpManager.getDefault().getHelp(this.helpId);
    }

    private boolean hasLegacyHelp() {
        return this.helpId != null && this.helpId.length() > 0;
    }

    public boolean hasHelp() {
        return this.getHelpItem() != null || this.hasLegacyHelp();
    }

    public void prepareHelp() {
    }

    public CompletionTask createDocumentationTask() {
        return new AsyncCompletionTask((AsyncCompletionQuery)new HtmlCompletionProvider.DocQuery(this, false));
    }

    public CompletionTask createToolTipTask() {
        return null;
    }

    public HelpItem getHelpItem() {
        return this.help;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HtmlCompletionItem other = (HtmlCompletionItem)obj;
        if (this.substitutionOffset != other.substitutionOffset) {
            return false;
        }
        if (this.text == null ? other.text != null : !this.text.equals(other.text)) {
            return false;
        }
        return !(this.helpId == null ? other.helpId != null : !this.helpId.equals(other.helpId));
    }

    public int hashCode() {
        int hash = 5;
        hash = 97 * hash + this.substitutionOffset;
        hash = 97 * hash + (this.text != null ? this.text.hashCode() : 0);
        hash = 97 * hash + (this.helpId != null ? this.helpId.hashCode() : 0);
        return hash;
    }

    public String toString() {
        return this.getItemText();
    }

    public static String hexColorCode(Color c) {
        Color tweakedToLookAndFeel = LFCustoms.shiftColor((Color)c);
        return Integer.toHexString(tweakedToLookAndFeel.getRGB()).substring(2);
    }

    private static String escape(String s) {
        if (s != null) {
            try {
                return XMLUtil.toAttributeValue((String)s);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return s;
    }

    private static String getHtmlColor(Color c) {
        return "<font color=#" + HtmlCompletionItem.hexColorCode(c) + ">";
    }

    public static class Tag
    extends HtmlCompletionItem {
        private static final ImageIcon HTML_TAG_ICON = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/csl/source/resources/icons/html_element.png", (boolean)false);
        private static final ImageIcon SVG_TAG_ICON = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/csl/source/resources/icons/class.png", (boolean)false);
        private static final ImageIcon MATHML_TAG_ICON = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/html/editor/resources/mathml.png", (boolean)false);
        private static final Color GRAY_COLOR = Color.GRAY;
        private static final Color DEFAULT_FG_COLOR = new Color(64, 64, 217);
        private boolean possible;
        private HtmlTag tag;

        protected Tag(HtmlTag tag, String name, int substitutionOffset, String helpId, boolean possible) {
            super(tag.getHelp(), name, substitutionOffset, helpId);
            this.tag = tag;
            this.possible = possible;
        }

        protected Tag(String text, int substitutionOffset, String helpId, boolean possible) {
            super(text, substitutionOffset, helpId);
            this.possible = possible;
        }

        @Override
        public void defaultAction(JTextComponent component) {
            super.defaultAction(component);
        }

        @Override
        protected String getSubstituteText() {
            return "<" + this.getItemText();
        }

        @Override
        public int getSortPriority() {
            return super.getSortPriority() + (this.possible ? -10 : 0);
        }

        @Override
        protected String getLeftHtmlText() {
            Color tagColor = this.possible ? DEFAULT_FG_COLOR : GRAY_COLOR;
            boolean isPossibleHtmlTag = this.possible && this.tag != null && this.tag.getTagClass() == HtmlTagType.HTML;
            StringBuilder b = new StringBuilder();
            if (isPossibleHtmlTag) {
                b.append("<b>");
            }
            b.append(HtmlCompletionItem.getHtmlColor(tagColor));
            b.append("&lt;");
            b.append(this.getItemText());
            b.append("&gt;");
            b.append(HtmlCompletionItem.END_FONT);
            if (isPossibleHtmlTag) {
                b.append("</b>");
            }
            return b.toString();
        }

        @Override
        protected String getRightHtmlText() {
            return null;
        }

        @Override
        protected ImageIcon getIcon() {
            if (this.tag != null) {
                switch (this.tag.getTagClass()) {
                    case HTML: {
                        return HTML_TAG_ICON;
                    }
                    case SVG: {
                        return SVG_TAG_ICON;
                    }
                    case MATHML: {
                        return MATHML_TAG_ICON;
                    }
                }
                return null;
            }
            return null;
        }

        @Override
        public boolean hasHelp() {
            return this.tag != null && this.tag.getHelp() != null || super.hasHelp();
        }
    }

    public static class EndTag
    extends HtmlCompletionItem {
        private int orderIndex;
        private Type type;
        private HtmlTag tag;

        EndTag(HtmlTag tag, String name, int substitutionOffset, String helpId, int order, Type type) {
            super(tag.getHelp(), name, substitutionOffset, helpId);
            this.orderIndex = order;
            this.type = type;
            this.tag = tag;
        }

        EndTag(String text, int substitutionOffset, String helpId, int order, Type type) {
            super(text, substitutionOffset, helpId);
            this.orderIndex = order;
            this.type = type;
        }

        @Override
        public CharSequence getSortText() {
            if (this.orderIndex == -1) {
                return super.getSortText();
            }
            char[] result = new char[Integer.toString(Integer.MAX_VALUE).length()];
            char[] orderIndexChars = Integer.toString(this.orderIndex).toCharArray();
            Arrays.fill(result, '0');
            System.arraycopy(orderIndexChars, 0, result, result.length - orderIndexChars.length, orderIndexChars.length);
            return new String(result);
        }

        @Override
        protected String getSubstituteText() {
            return "</" + this.getItemText() + ">";
        }

        @Override
        public int getSortPriority() {
            return this.type.sortPriority;
        }

        @Override
        protected String getLeftHtmlText() {
            return (this.type.bold ? "<b>" : "") + HtmlCompletionItem.getHtmlColor(this.type.color) + "&lt;/" + this.getItemText() + "&gt;" + HtmlCompletionItem.END_FONT + (this.type.bold ? "</b>" : "");
        }

        @Override
        public boolean hasHelp() {
            return this.tag != null && (this.tag.getHelp() != null || this.tag.getTagClass() != HtmlTagType.UNKNOWN && super.hasHelp());
        }

        public static enum Type {
            DEFAULT(Color.BLUE, false, 20),
            OPTIONAL_EXISTING(Color.GRAY, false, 20),
            OPTIONAL_MISSING(Color.BLUE, false, 10),
            REQUIRED_EXISTING(Color.GRAY, false, 20),
            REQUIRED_MISSING(Color.BLUE, false, 10);

            private Color color;
            private boolean bold;
            private int sortPriority;

            private Type(Color color, boolean bold, int sortPriority) {
                this.color = color;
                this.bold = bold;
                this.sortPriority = sortPriority;
            }
        }
    }

    public static class AutocompleteEndTag
    extends EndTag {
        public AutocompleteEndTag(String text, int substitutionOffset) {
            super(text, substitutionOffset, null, -1, EndTag.Type.DEFAULT);
        }

        @Override
        protected int getMoveBackLength() {
            return this.getSubstituteText().length();
        }

        @Override
        public boolean instantSubstitution(JTextComponent component) {
            return false;
        }
    }

    public static class BooleanAttribute
    extends HtmlCompletionItem {
        private boolean required;
        private static final Color ATTR_NAME_COLOR = Color.green.darker();

        public BooleanAttribute(String value, int offset, boolean required, String helpId) {
            super(value, offset, helpId);
            this.required = required;
        }

        @Override
        protected String getLeftHtmlText() {
            StringBuilder sb = new StringBuilder();
            if (this.required) {
                sb.append("<b>");
            }
            sb.append(HtmlCompletionItem.getHtmlColor(BooleanAttribute.ATTR_NAME_COLOR));
            sb.append(this.getItemText());
            sb.append(HtmlCompletionItem.END_FONT);
            if (this.required) {
                sb.append("</b>");
            }
            return sb.toString();
        }
    }

    public static class Attribute
    extends HtmlCompletionItem {
        private boolean required;
        private boolean autocompleteQuotes;
        private HtmlTagAttribute attr;

        public Attribute(HtmlTagAttribute attr, String value, int offset, boolean required, String helpId) {
            super(attr != null ? attr.getHelp() : null, value, offset, helpId);
            this.attr = attr;
            this.required = required;
            this.autocompleteQuotes = HtmlPreferences.autocompleteQuotesAfterEqualSign();
        }

        public Attribute(String value, int offset, boolean required, HelpItem helpItem) {
            super(helpItem, value, offset, null);
            this.required = required;
            this.autocompleteQuotes = HtmlPreferences.autocompleteQuotesAfterEqualSign();
        }

        public Attribute(String value, int offset, boolean required, String helpId) {
            super(value, offset, helpId);
            this.required = required;
            this.autocompleteQuotes = HtmlPreferences.autocompleteQuotesAfterEqualSign();
        }

        public Attribute(String value, int offset, boolean required, String helpId, boolean autoCompleteValue) {
            super(value, offset, helpId);
            this.required = required;
            this.autocompleteQuotes = autoCompleteValue && HtmlPreferences.autocompleteQuotesAfterEqualSign();
        }

        protected Color getAttributeColor() {
            return Color.green.darker();
        }

        @Override
        protected String getSubstituteText() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.getItemText());
            if (this.autocompleteQuotes) {
                sb.append("=\"\"");
            }
            return sb.toString();
        }

        @Override
        protected int getMoveBackLength() {
            return this.autocompleteQuotes ? 1 : 0;
        }

        @Override
        public int getSortPriority() {
            return super.getSortPriority() - (this.required ? 1 : 0);
        }

        @Override
        protected String getLeftHtmlText() {
            StringBuilder sb = new StringBuilder();
            if (this.required) {
                sb.append("<b>");
            }
            sb.append(HtmlCompletionItem.getHtmlColor(this.getAttributeColor()));
            sb.append(this.getItemText());
            sb.append(HtmlCompletionItem.END_FONT);
            if (this.required) {
                sb.append("</b>");
            }
            return sb.toString();
        }

        @Override
        public boolean hasHelp() {
            return this.attr != null && this.attr.getHelp() != null || super.hasHelp();
        }
    }

    public static class AttributeValue
    extends HtmlCompletionItem {
        private final boolean addQuotation;
        private final int sortPriority;

        public AttributeValue(String value, int offset, boolean addQuotation, int sortPriority) {
            super(value, offset);
            this.addQuotation = addQuotation;
            this.sortPriority = sortPriority;
        }

        public AttributeValue(String value, int offset, boolean addQuotation) {
            this(value, offset, addQuotation, 20);
        }

        @Override
        public int getSortPriority() {
            return this.sortPriority;
        }

        @Override
        protected String getSubstituteText() {
            StringBuilder sb = new StringBuilder();
            if (this.addQuotation) {
                sb.append("\"");
            }
            sb.append(super.getSubstituteText());
            if (this.addQuotation) {
                sb.append("\"");
            }
            return sb.toString();
        }
    }

    public static class CharRefItem
    extends HtmlCompletionItem {
        private char value;
        private static final Color FG = new Color(153, 0, 0);

        CharRefItem(String name, char value, int substitutionOffset, String helpId) {
            super(name, substitutionOffset, helpId);
            this.value = value;
        }

        @Override
        protected String getSubstituteText() {
            return "&" + this.getItemText() + ';';
        }

        @Override
        protected String getLeftHtmlText() {
            return "<b>&amp;" + HtmlCompletionItem.escape(this.getItemText()) + ";</b>";
        }

        @Override
        protected String getRightHtmlText() {
            String strVal = this.value == '>' ? "&gt;" : (this.value == '<' ? "&lt;" : Character.toString(this.value));
            return "<b>" + HtmlCompletionItem.getHtmlColor(CharRefItem.FG) + strVal + HtmlCompletionItem.END_FONT + "</b>";
        }
    }

    public static class HtmlCssValueCompletionItem
    extends HtmlCompletionItem {
        private static final ImageIcon ICON = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/html/editor/resources/rule.png", (boolean)false);
        private static final String RELATED_SELECTOR_COLOR = "007c00";
        private static final String GRAY_COLOR_CODE = Integer.toHexString(Color.GRAY.getRGB()).substring(2);
        private final boolean related;

        private HtmlCssValueCompletionItem(String value, int substituteOffset, boolean related) {
            super(value, substituteOffset);
            this.related = related;
        }

        @Override
        protected String getLeftHtmlText() {
            StringBuilder buf = new StringBuilder();
            if (this.related) {
                buf.append("<b><font color=#");
                buf.append(RELATED_SELECTOR_COLOR);
            } else {
                buf.append("<font color=#");
                buf.append(GRAY_COLOR_CODE);
            }
            buf.append(">");
            buf.append(this.getItemText());
            buf.append(HtmlCompletionItem.END_FONT);
            if (this.related) {
                buf.append("</b>");
            }
            return buf.toString();
        }

        @Override
        protected ImageIcon getIcon() {
            return ICON;
        }

        @Override
        public int getSortPriority() {
            return super.getSortPriority() - (this.related ? 1 : 0);
        }

        @Override
        void reindent(JTextComponent component) {
        }
    }

    public static class FileAttributeValue
    extends HtmlCompletionItem
    implements PropertyChangeListener,
    LazyCompletionItem {
        private ImageIcon icon;
        private final Color color;
        private boolean visible;
        private final boolean folder;

        FileAttributeValue(boolean folder, String text, int substitutionOffset, Color color, ImageIcon icon) {
            super(text, substitutionOffset);
            this.folder = folder;
            this.color = color;
            this.icon = icon;
        }

        @Override
        protected ImageIcon getIcon() {
            return this.icon;
        }

        @Override
        protected String getLeftHtmlText() {
            if (this.color == null) {
                return this.getItemText();
            }
            StringBuilder sb = new StringBuilder();
            sb.append(HtmlCompletionItem.getHtmlColor(this.color));
            sb.append(this.getItemText());
            sb.append(HtmlCompletionItem.END_FONT);
            return sb.toString();
        }

        @Override
        public CharSequence getSortText() {
            return this.folder ? "_" + this.getItemText() : this.getItemText();
        }

        private void iconLoaded(ImageIcon icon) {
            this.icon = icon;
            if (this.visible) {
                this.repaintCompletionView_EDT();
            }
        }

        private void repaintCompletionView_EDT() {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    FileAttributeValue.repaintCompletionView();
                }
            });
        }

        private static void repaintCompletionView() {
            try {
                Completion completion = Completion.get();
                Class<?> clz = completion.getClass();
                Method method = clz.getDeclaredMethod("repaintCompletionView", new Class[0]);
                method.setAccessible(true);
                method.invoke((Object)completion, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
                // empty catch block
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("iconLoaded")) {
                this.iconLoaded((ImageIcon)evt.getNewValue());
            }
        }

        public boolean accept() {
            this.visible = true;
            return true;
        }
    }

    public static class GoUpFileAttributeValue
    extends FileAttributeValue {
        GoUpFileAttributeValue(int substitutionOffset, Color color, ImageIcon icon) {
            super(true, "../", substitutionOffset, color, icon);
        }

        @Override
        public int getSortPriority() {
            return super.getSortPriority() - 1;
        }
    }
}

