/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.openide.awt;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JToggleButton;
import org.openide.awt.Actions;
import org.openide.awt.DynamicMenuContent;
import org.openide.util.actions.ActionPresenterProvider;
import org.openide.util.actions.BooleanStateAction;
import org.openide.util.actions.SystemAction;

public final class DefaultAWTBridge
extends ActionPresenterProvider {
    public JMenuItem createMenuPresenter(Action action) {
        if (action instanceof BooleanStateAction) {
            BooleanStateAction b = (BooleanStateAction)action;
            return new Actions.CheckboxMenuItem(b, true);
        }
        if (action.getValue("openide.awt.actionToggle") != null) {
            return new Actions.CheckboxMenuItem(action, true);
        }
        if (action instanceof SystemAction) {
            SystemAction s = (SystemAction)action;
            return new Actions.MenuItem(s, true);
        }
        return new Actions.MenuItem(action, true);
    }

    public JMenuItem createPopupPresenter(Action action) {
        JMenuItem item;
        if (action instanceof BooleanStateAction) {
            BooleanStateAction b = (BooleanStateAction)action;
            item = new Actions.CheckboxMenuItem(b, false);
        } else if (action instanceof SystemAction) {
            SystemAction s = (SystemAction)action;
            item = new Actions.MenuItem(s, false);
        } else {
            item = new Actions.MenuItem(action, false);
        }
        return item;
    }

    public Component createToolbarPresenter(Action action) {
        AbstractButton btn;
        if (action instanceof BooleanStateAction || action.getValue("openide.awt.actionToggle") != null) {
            btn = new JToggleButton();
            Actions.connect(btn, action);
        } else {
            btn = new JButton();
            Actions.connect(btn, action);
        }
        return btn;
    }

    public JPopupMenu createEmptyPopup() {
        return new JPopupMenu();
    }

    public Component[] convertComponents(Component comp) {
        JMenuItem item;
        if (comp instanceof JMenuItem && Boolean.TRUE.equals((item = (JMenuItem)comp).getClientProperty("hideWhenDisabled")) && !item.isEnabled()) {
            return new Component[0];
        }
        if (comp instanceof DynamicMenuContent) {
            Component[] toRet = ((DynamicMenuContent)((Object)comp)).getMenuPresenters();
            boolean atLeastOne = false;
            ArrayList<Component> col = new ArrayList<Component>();
            for (int i = 0; i < toRet.length; ++i) {
                if (toRet[i] instanceof DynamicMenuContent && toRet[i] != comp) {
                    col.addAll(Arrays.asList(this.convertComponents(toRet[i])));
                    atLeastOne = true;
                    continue;
                }
                if (toRet[i] == null) {
                    toRet[i] = new JSeparator();
                }
                col.add(toRet[i]);
            }
            if (atLeastOne) {
                return col.toArray(new Component[0]);
            }
            return toRet;
        }
        return new Component[]{comp};
    }
}

