/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.debug;

import java.awt.Color;
import java.util.Collections;
import java.util.Set;
import org.netbeans.api.debugger.jpda.DebuggerStartException;
import org.netbeans.api.project.Project;
import org.netbeans.modules.maven.api.execute.RunConfig;
import org.netbeans.modules.maven.api.output.ContextOutputProcessorFactory;
import org.netbeans.modules.maven.api.output.OutputProcessor;
import org.netbeans.modules.maven.api.output.OutputVisitor;
import org.netbeans.modules.maven.debug.DebuggerChecker;
import org.openide.util.Exceptions;

public class DebugCheckerOutputFactory
implements ContextOutputProcessorFactory {
    @Override
    public Set<? extends OutputProcessor> createProcessorsSet(Project project, RunConfig config) {
        String trigger = config.getProperties().get("jpda.attach.trigger");
        if (trigger == null) {
            return Collections.emptySet();
        }
        return Collections.singleton(new JPDATrigger(trigger, config));
    }

    @Override
    public Set<? extends OutputProcessor> createProcessorsSet(Project project) {
        return Collections.emptySet();
    }

    private static class JPDATrigger
    implements OutputProcessor {
        private String trigger;
        private final RunConfig cfg;

        public JPDATrigger(String trigger, RunConfig cfg) {
            this.trigger = trigger;
            this.cfg = cfg;
        }

        @Override
        public String[] getRegisteredOutputSequences() {
            return new String[]{"project-execute"};
        }

        @Override
        public void processLine(String line, OutputVisitor visitor) {
            if (this.trigger != null && line.contains(this.trigger)) {
                this.trigger = null;
                try {
                    DebuggerChecker.connect(this.cfg);
                }
                catch (DebuggerStartException ex) {
                    visitor.setLine(visitor.getLine() + " cannot connect: " + ex.getMessage());
                    visitor.setColor(Color.red);
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }

        @Override
        public void sequenceStart(String sequenceId, OutputVisitor visitor) {
        }

        @Override
        public void sequenceEnd(String sequenceId, OutputVisitor visitor) {
        }

        @Override
        public void sequenceFail(String sequenceId, OutputVisitor visitor) {
        }
    }
}

