/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ant.freeform;

import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.modules.ant.freeform.FreeformFileEncodingQueryImpl;
import org.netbeans.modules.ant.freeform.spi.support.Util;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.openide.loaders.CreateFromTemplateAttributesProvider;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class FreeformTemplateAttributesProvider
implements CreateFromTemplateAttributesProvider {
    private final AntProjectHelper helper;
    private final PropertyEvaluator evaluator;
    private final FreeformFileEncodingQueryImpl encodingQuery;

    public FreeformTemplateAttributesProvider(AntProjectHelper helper, PropertyEvaluator eval, FreeformFileEncodingQueryImpl encodingQuery) {
        this.helper = helper;
        this.evaluator = eval;
        this.encodingQuery = encodingQuery;
    }

    public Map<String, ?> attributesFor(DataObject template, DataFolder target, String name) {
        Element primData = Util.getPrimaryConfigurationData(this.helper);
        Element licenseEl = XMLUtil.findElement((Element)primData, (String)"project-license", (String)"http://www.netbeans.org/ns/freeform-project/2");
        Charset charset = this.encodingQuery.getEncoding(target.getPrimaryFile());
        if (licenseEl == null && charset == null) {
            return null;
        }
        HashMap<String, String> values = new HashMap<String, String>();
        if (licenseEl != null) {
            values.put("license", this.evaluator.evaluate(XMLUtil.findText((Node)licenseEl)));
        }
        if (charset != null) {
            values.put("encoding", charset.name());
        }
        return Collections.singletonMap("project", values);
    }
}

