/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.util;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.circuitbreaker.CircuitBreakerConfiguration;
import com.oracle.bmc.circuitbreaker.NoCircuitBreakerConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CircuitBreakerUtils {
    private static final Logger LOG = LoggerFactory.getLogger(CircuitBreakerUtils.class);
    private static volatile CircuitBreakerConfiguration defaultCircuitBreakerConfiguration;
    public static final CircuitBreakerConfiguration DEFAULT_CIRCUIT_BREAKER_CONFIGURATION;
    private static final String OCI_SDK_DEFAULT_CIRCUITBREAKER_ENABLED_ENV_VAR = "OCI_SDK_DEFAULT_CIRCUITBREAKER_ENABLED";

    public static CircuitBreakerConfiguration getNoCircuitBreakerConfiguration() {
        return new NoCircuitBreakerConfiguration();
    }

    public static CircuitBreakerConfiguration getDefaultCircuitBreakerConfiguration() {
        return defaultCircuitBreakerConfiguration;
    }

    public static CircuitBreakerConfiguration getUserDefinedCircuitBreakerConfiguration(ClientConfiguration configuration) {
        CircuitBreakerConfiguration circuitBreakerConfiguration = null;
        if (configuration != null) {
            if (configuration.getCircuitBreakerConfiguration() != null) {
                circuitBreakerConfiguration = configuration.getCircuitBreakerConfiguration();
            }
        } else if (defaultCircuitBreakerConfiguration != null) {
            circuitBreakerConfiguration = defaultCircuitBreakerConfiguration;
        } else if (CircuitBreakerUtils.isEnvBasedDefaultCircuitBreakerEnabled()) {
            circuitBreakerConfiguration = DEFAULT_CIRCUIT_BREAKER_CONFIGURATION;
        } else if (!CircuitBreakerUtils.isEnvBasedDefaultCircuitBreakerEnabled()) {
            circuitBreakerConfiguration = CircuitBreakerUtils.getNoCircuitBreakerConfiguration();
        }
        LOG.debug("Circuit breaker configuration in use: {}", (Object)circuitBreakerConfiguration);
        return circuitBreakerConfiguration;
    }

    private static boolean isEnvBasedDefaultCircuitBreakerEnabled() {
        String defaultCircuitBreakerEnvVariable = System.getenv(OCI_SDK_DEFAULT_CIRCUITBREAKER_ENABLED_ENV_VAR);
        return defaultCircuitBreakerEnvVariable == null || !defaultCircuitBreakerEnvVariable.equalsIgnoreCase("false");
    }

    public static void setDefaultCircuitBreakerConfiguration(CircuitBreakerConfiguration defaultCircuitBreakerConfiguration) {
        CircuitBreakerUtils.defaultCircuitBreakerConfiguration = defaultCircuitBreakerConfiguration;
    }

    static {
        DEFAULT_CIRCUIT_BREAKER_CONFIGURATION = CircuitBreakerConfiguration.builder().build();
    }
}

