/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.input.style.parser.stylehandler;

import java.util.ArrayList;
import org.jfree.layouting.input.style.StyleKey;
import org.jfree.layouting.input.style.parser.CSSValueFactory;
import org.jfree.layouting.input.style.parser.CSSValueReadHandler;
import org.jfree.layouting.input.style.values.CSSValue;
import org.jfree.layouting.input.style.values.CSSValueList;
import org.w3c.css.sac.LexicalUnit;

public abstract class ListOfValuesReadHandler
implements CSSValueReadHandler {
    private int maxCount;
    private boolean distinctValues;

    protected ListOfValuesReadHandler() {
        this.maxCount = Integer.MAX_VALUE;
        this.distinctValues = false;
    }

    protected ListOfValuesReadHandler(int n, boolean bl) {
        this.maxCount = n;
        this.distinctValues = bl;
    }

    public boolean isDistinctValues() {
        return this.distinctValues;
    }

    public int getMaxCount() {
        return this.maxCount;
    }

    @Override
    public CSSValue createValue(StyleKey styleKey, LexicalUnit lexicalUnit) {
        ArrayList<CSSValue> arrayList = new ArrayList<CSSValue>();
        for (int i = 0; lexicalUnit != null && i < this.maxCount; ++i) {
            CSSValue cSSValue = this.parseValue(lexicalUnit);
            if (cSSValue == null) {
                return null;
            }
            if (!this.distinctValues || !arrayList.contains(cSSValue)) {
                arrayList.add(cSSValue);
            }
            lexicalUnit = CSSValueFactory.parseComma(lexicalUnit);
        }
        return new CSSValueList(arrayList);
    }

    protected abstract CSSValue parseValue(LexicalUnit var1);
}

