/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.repository.zip;

import java.util.Date;
import java.util.HashMap;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import org.pentaho.reporting.libraries.base.util.IOUtils;
import org.pentaho.reporting.libraries.repository.ContentCreationException;
import org.pentaho.reporting.libraries.repository.ContentEntity;
import org.pentaho.reporting.libraries.repository.ContentIOException;
import org.pentaho.reporting.libraries.repository.ContentItem;
import org.pentaho.reporting.libraries.repository.ContentLocation;
import org.pentaho.reporting.libraries.repository.Repository;
import org.pentaho.reporting.libraries.repository.RepositoryUtilities;
import org.pentaho.reporting.libraries.repository.zip.ZipContentItem;
import org.pentaho.reporting.libraries.repository.zip.ZipRepository;

public class ZipContentLocation
implements ContentLocation {
    private static final Logger logger = Logger.getLogger(ZipContentLocation.class.getName());
    private ZipRepository repository;
    private ZipContentLocation parent;
    private String comment;
    private String name;
    private long size;
    private long time;
    private String entryName;
    private HashMap entries;

    public ZipContentLocation(ZipRepository repository, ZipContentLocation parent, String entryName) {
        if (repository == null) {
            throw new NullPointerException();
        }
        if (entryName == null) {
            throw new NullPointerException();
        }
        this.repository = repository;
        this.parent = parent;
        this.entryName = entryName;
        this.entries = new HashMap();
        this.name = RepositoryUtilities.buildName(this, "/") + '/';
        this.time = System.currentTimeMillis();
    }

    public ZipContentLocation(ZipRepository repository, ZipContentLocation parent, ZipEntry zipEntry) {
        if (repository == null) {
            throw new NullPointerException();
        }
        if (parent == null) {
            throw new NullPointerException();
        }
        if (zipEntry == null) {
            throw new NullPointerException();
        }
        this.repository = repository;
        this.parent = parent;
        this.entryName = IOUtils.getInstance().getFileName(zipEntry.getName());
        this.comment = zipEntry.getComment();
        this.size = zipEntry.getSize();
        this.time = zipEntry.getTime();
        this.entries = new HashMap();
        this.name = RepositoryUtilities.buildName(this, "/") + '/';
    }

    private void updateMetaData(ZipEntry zipEntry) {
        this.comment = zipEntry.getComment();
        this.size = zipEntry.getSize();
        this.time = zipEntry.getTime();
    }

    public void updateDirectoryEntry(String[] name, int index, ZipEntry zipEntry) {
        ZipContentLocation location;
        if (name == null) {
            throw new NullPointerException();
        }
        if (zipEntry == null) {
            throw new NullPointerException();
        }
        String path = name[index];
        Object entry = this.entries.get(path);
        if (entry instanceof ContentItem) {
            logger.warning("Directory-Entry with the same name as a Content-Entry encountered: " + path);
            return;
        }
        if (entry == null) {
            location = new ZipContentLocation(this.repository, this, path);
            this.entries.put(path, location);
        } else {
            location = (ZipContentLocation)entry;
        }
        int nextNameIdx = index + 1;
        if (nextNameIdx < name.length) {
            location.updateDirectoryEntry(name, nextNameIdx, zipEntry);
        } else if (nextNameIdx == name.length) {
            location.updateMetaData(zipEntry);
        }
    }

    public void updateEntry(String[] name, int index, ZipEntry zipEntry, byte[] data) {
        if (name == null) {
            throw new NullPointerException();
        }
        if (zipEntry == null) {
            throw new NullPointerException();
        }
        if (data == null) {
            throw new NullPointerException();
        }
        String path = name[index];
        Object entry = this.entries.get(path);
        int nextNameIdx = index + 1;
        if (nextNameIdx < name.length) {
            ZipContentLocation location;
            if (entry instanceof ContentItem) {
                logger.warning("Directory-Entry with the same name as a Content-Entry encountered: " + path);
                return;
            }
            if (entry == null) {
                location = new ZipContentLocation(this.repository, this, path);
                this.entries.put(path, location);
            } else {
                location = (ZipContentLocation)entry;
            }
            if (nextNameIdx < name.length) {
                location.updateEntry(name, nextNameIdx, zipEntry, data);
            }
        } else if (nextNameIdx == name.length) {
            if (entry instanceof ContentItem) {
                logger.warning("Duplicate Content-Entry encountered: " + path);
                return;
            }
            if (entry != null) {
                logger.warning("Replacing Directory-Entry with the same name as a Content-Entry: " + path);
            }
            ZipContentItem contentItem = new ZipContentItem(this.repository, this, zipEntry, data);
            this.entries.put(path, contentItem);
        }
    }

    @Override
    public ContentEntity[] listContents() throws ContentIOException {
        return this.entries.values().toArray(new ContentEntity[this.entries.size()]);
    }

    @Override
    public ContentEntity getEntry(String name) throws ContentIOException {
        return (ContentEntity)this.entries.get(name);
    }

    @Override
    public boolean exists(String name) {
        return this.entries.containsKey(name);
    }

    @Override
    public ContentItem createItem(String name) throws ContentCreationException {
        if (this.entries.containsKey(name)) {
            throw new ContentCreationException("An entry with name '" + name + "' already exists.");
        }
        if (name.indexOf(47) != -1) {
            throw new ContentCreationException("The entry-name '" + name + "' is invalid.");
        }
        if ("".equals(name) || ".".equals(name) || "..".equals(name)) {
            throw new ContentCreationException("The entry-name '" + name + "' is invalid.");
        }
        ZipContentItem value = new ZipContentItem(this.repository, this, name);
        this.entries.put(name, value);
        return value;
    }

    @Override
    public ContentLocation createLocation(String name) throws ContentCreationException {
        if (this.entries.containsKey(name)) {
            throw new ContentCreationException("An entry with name '" + name + "' already exists.");
        }
        if (this.entries.containsKey(name)) {
            throw new ContentCreationException("An entry with name '" + name + "' already exists.");
        }
        if (name.indexOf(47) != -1) {
            throw new ContentCreationException("The entry-name '" + name + "' is invalid.");
        }
        if ("".equals(name) || ".".equals(name) || "..".equals(name)) {
            throw new ContentCreationException("The entry-name '" + name + "' is invalid.");
        }
        ZipContentLocation value = new ZipContentLocation(this.repository, this, name);
        this.entries.put(name, value);
        return value;
    }

    @Override
    public String getName() {
        return this.entryName;
    }

    @Override
    public Object getContentId() {
        return this.name;
    }

    @Override
    public Object getAttribute(String domain, String key) {
        if ("org.jfree.repository".equals(domain)) {
            if ("size".equals(key)) {
                return new Long(this.size);
            }
            if ("version".equals(key)) {
                return new Date(this.time);
            }
        } else if ("org.jfree.repository.zip".equals(domain) && "comment".equals(key)) {
            return this.comment;
        }
        return null;
    }

    @Override
    public boolean setAttribute(String domain, String key, Object value) {
        if ("org.jfree.repository".equals(domain)) {
            if ("version".equals(key)) {
                if (value instanceof Date) {
                    Date n = (Date)value;
                    this.time = n.getTime();
                    return true;
                }
                if (value instanceof Number) {
                    Number n = (Number)value;
                    this.time = n.longValue();
                    return true;
                }
            }
        } else if ("org.jfree.repository.zip".equals(domain) && "comment".equals(key)) {
            if (value != null) {
                this.comment = String.valueOf(value);
                return true;
            }
            this.comment = null;
            return true;
        }
        return false;
    }

    @Override
    public ContentLocation getParent() {
        return this.parent;
    }

    @Override
    public Repository getRepository() {
        return this.repository;
    }

    @Override
    public boolean delete() {
        if (this.parent == null) {
            return false;
        }
        return this.parent.removeEntity(this);
    }

    public boolean removeEntity(ContentEntity entity) {
        return this.entries.remove(entity.getName()) != null;
    }
}

