/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.mailvalidator;

import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.mailvalidator.MailValidation;
import org.pentaho.di.trans.steps.mailvalidator.MailValidationResult;
import org.pentaho.di.trans.steps.mailvalidator.MailValidatorData;
import org.pentaho.di.trans.steps.mailvalidator.MailValidatorMeta;
import org.pentaho.di.trans.steps.mailvalidator.Messages;

public class MailValidator
extends BaseStep
implements StepInterface {
    private MailValidatorMeta meta;
    private MailValidatorData data;

    public MailValidator(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        block23: {
            this.meta = (MailValidatorMeta)smi;
            this.data = (MailValidatorData)sdi;
            Object[] r = this.getRow();
            if (r == null) {
                this.setOutputDone();
                return false;
            }
            if (this.first) {
                this.first = false;
                this.data.previousRowMeta = this.getInputRowMeta().clone();
                this.data.NrPrevFields = this.data.previousRowMeta.size();
                this.data.outputRowMeta = this.getInputRowMeta().clone();
                this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, this);
                this.data.realResultFieldName = this.environmentSubstitute(this.meta.getResultFieldName());
                if (Const.isEmpty((String)this.data.realResultFieldName)) {
                    throw new KettleException(Messages.getString("MailValidator.Error.ResultFieldNameMissing"));
                }
                if (this.meta.isResultAsString()) {
                    if (Const.isEmpty((String)this.meta.getEMailValideMsg())) {
                        throw new KettleException(Messages.getString("MailValidator.Error.EMailValidMsgMissing"));
                    }
                    if (Const.isEmpty((String)this.meta.getEMailNotValideMsg())) {
                        throw new KettleException(Messages.getString("MailValidator.Error.EMailNotValidMsgMissing"));
                    }
                    this.data.msgValidMail = this.environmentSubstitute(this.meta.getEMailValideMsg());
                    this.data.msgNotValidMail = this.environmentSubstitute(this.meta.getEMailNotValideMsg());
                }
                if (Const.isEmpty((String)this.meta.getEmailField())) {
                    throw new KettleException(Messages.getString("MailValidator.Error.FilenameFieldMissing"));
                }
                this.data.realResultErrorsFieldName = this.environmentSubstitute(this.meta.getErrorsField());
                if (this.data.indexOfeMailField < 0) {
                    this.data.indexOfeMailField = this.data.previousRowMeta.indexOfValue(this.meta.getEmailField());
                    if (this.data.indexOfeMailField < 0) {
                        throw new KettleException(Messages.getString("MailValidator.Exception.CouldnotFindField", this.meta.getEmailField()));
                    }
                }
                if (this.meta.isSMTPCheck()) {
                    if (this.meta.isdynamicDefaultSMTP()) {
                        if (Const.isEmpty((String)this.meta.getDefaultSMTP())) {
                            throw new KettleException(Messages.getString("MailValidator.Error.DefaultSMTPFieldMissing"));
                        }
                        if (this.data.indexOfdefaultSMTPField < 0) {
                            this.data.indexOfdefaultSMTPField = this.data.previousRowMeta.indexOfValue(this.meta.getDefaultSMTP());
                            if (this.data.indexOfdefaultSMTPField < 0) {
                                throw new KettleException(Messages.getString("MailValidator.Exception.CouldnotFindField", this.meta.getDefaultSMTP()));
                            }
                        }
                    }
                    this.data.timeout = Const.toInt((String)this.environmentSubstitute(this.meta.getTimeOut()), (int)0);
                    this.data.realemailSender = this.environmentSubstitute(this.meta.geteMailSender());
                    this.data.realdefaultSMTPServer = this.environmentSubstitute(this.meta.getDefaultSMTP());
                }
            }
            boolean sendToErrorRow = false;
            String errorMessage = null;
            boolean mailvalid = false;
            String mailerror = null;
            Object[] outputRow = RowDataUtil.allocateRowData((int)this.data.outputRowMeta.size());
            for (int i = 0; i < this.data.NrPrevFields; ++i) {
                outputRow[i] = r[i];
            }
            try {
                String emailaddress = this.data.previousRowMeta.getString(r, this.data.indexOfeMailField);
                if (!Const.isEmpty((String)emailaddress)) {
                    if (this.meta.isdynamicDefaultSMTP()) {
                        this.data.realdefaultSMTPServer = this.data.previousRowMeta.getString(r, this.data.indexOfdefaultSMTPField);
                    }
                    MailValidationResult result = MailValidation.isAddressValid(emailaddress, this.data.realemailSender, this.data.realdefaultSMTPServer, this.data.timeout, this.meta.isSMTPCheck());
                    mailvalid = result.isValide();
                    mailerror = result.getErrorMessage();
                } else {
                    mailerror = Messages.getString("MailValidator.Error.MailEmpty");
                }
                outputRow[this.data.NrPrevFields] = this.meta.isResultAsString() ? (mailvalid ? this.data.msgValidMail : this.data.msgNotValidMail) : Boolean.valueOf(mailvalid);
                int rowIndex = this.data.NrPrevFields;
                ++rowIndex;
                if (!Const.isEmpty((String)this.data.realResultErrorsFieldName)) {
                    outputRow[rowIndex] = mailerror;
                }
                this.putRow(this.data.outputRowMeta, outputRow);
                if (this.log.isRowLevel()) {
                    this.log.logRowlevel(this.toString(), Messages.getString("MailValidator.LineNumber", this.getLinesRead() + " : " + this.getInputRowMeta().getString(r)), new Object[0]);
                }
            }
            catch (Exception e) {
                if (!this.getStepMeta().isDoingErrorHandling()) {
                    this.logError(Messages.getString("MailValidator.ErrorInStepRunning") + e.getMessage());
                    this.setErrors(1L);
                    this.stopAll();
                    this.setOutputDone();
                    return false;
                }
                sendToErrorRow = true;
                errorMessage = e.toString();
                if (!sendToErrorRow) break block23;
                this.putError(this.getInputRowMeta(), r, 1L, errorMessage, this.meta.getResultFieldName(), "MailValidator001");
            }
        }
        return true;
    }

    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (MailValidatorMeta)smi;
        this.data = (MailValidatorData)sdi;
        if (super.init(smi, sdi)) {
            if (Const.isEmpty((String)this.meta.getResultFieldName())) {
                this.log.logError(this.toString(), Messages.getString("MailValidator.Error.ResultFieldMissing"), new Object[0]);
                return false;
            }
            return true;
        }
        return false;
    }

    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (MailValidatorMeta)smi;
        this.data = (MailValidatorData)sdi;
        super.dispose(smi, sdi);
    }

    public void run() {
        BaseStep.runStepThread(this, this.meta, this.data);
    }

    public String toString() {
        return this.getClass().getName();
    }
}

