/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.handler;

import de.rub.nds.tlsattacker.core.protocol.handler.ServerKeyExchangeHandler;
import de.rub.nds.tlsattacker.core.protocol.message.PskDheServerKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.parser.PskDheServerKeyExchangeParser;
import de.rub.nds.tlsattacker.core.protocol.preparator.PskDheServerKeyExchangePreparator;
import de.rub.nds.tlsattacker.core.protocol.serializer.PskDheServerKeyExchangeSerializer;
import de.rub.nds.tlsattacker.core.state.TlsContext;
import java.math.BigInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PskDheServerKeyExchangeHandler
extends ServerKeyExchangeHandler<PskDheServerKeyExchangeMessage> {
    private static final Logger LOGGER = LogManager.getLogger();

    public PskDheServerKeyExchangeHandler(TlsContext tlsContext) {
        super(tlsContext);
    }

    @Override
    public PskDheServerKeyExchangeParser getParser(byte[] message, int pointer) {
        return new PskDheServerKeyExchangeParser(pointer, message, this.tlsContext.getChooser().getLastRecordVersion(), this.tlsContext.getConfig());
    }

    public PskDheServerKeyExchangePreparator getPreparator(PskDheServerKeyExchangeMessage message) {
        return new PskDheServerKeyExchangePreparator(this.tlsContext.getChooser(), message);
    }

    public PskDheServerKeyExchangeSerializer getSerializer(PskDheServerKeyExchangeMessage message) {
        return new PskDheServerKeyExchangeSerializer(message, this.tlsContext.getChooser().getSelectedProtocolVersion());
    }

    @Override
    public void adjustTLSContext(PskDheServerKeyExchangeMessage message) {
        this.adjustPSKGenerator(message);
        this.adjustPSKModulus(message);
        this.adjustServerPublicKey(message);
        if (message.getComputations() != null && message.getComputations().getPrivateKey() != null) {
            this.adjustServerPrivateKey(message);
        }
    }

    private void adjustPSKGenerator(PskDheServerKeyExchangeMessage message) {
        this.tlsContext.setPSKGenerator(new BigInteger(1, (byte[])message.getGenerator().getValue()));
        LOGGER.debug("PSK Generator: " + this.tlsContext.getPSKGenerator());
    }

    private void adjustPSKModulus(PskDheServerKeyExchangeMessage message) {
        this.tlsContext.setPSKModulus(new BigInteger(1, (byte[])message.getModulus().getValue()));
        LOGGER.debug("PSK Modulus: " + this.tlsContext.getPSKModulus());
    }

    private void adjustServerPublicKey(PskDheServerKeyExchangeMessage message) {
        this.tlsContext.setServerPSKPublicKey(new BigInteger(1, (byte[])message.getPublicKey().getValue()));
        LOGGER.debug("Server PublicKey: " + this.tlsContext.getServerPSKPublicKey());
    }

    private void adjustServerPrivateKey(PskDheServerKeyExchangeMessage message) {
        this.tlsContext.setServerPSKPrivateKey((BigInteger)message.getComputations().getPrivateKey().getValue());
        LOGGER.debug("Server PrivateKey: " + this.tlsContext.getServerPSKPrivateKey());
    }
}

