/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.tls;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.bouncycastle.asn1.ocsp.OCSPResponse;
import org.bouncycastle.crypto.tls.TlsFatalAlert;
import org.bouncycastle.crypto.tls.TlsUtils;

public class CertificateStatus {
    protected short statusType;
    protected Object response;

    public CertificateStatus(short statusType, Object response) {
        if (!CertificateStatus.isCorrectType(statusType, response)) {
            throw new IllegalArgumentException("'response' is not an instance of the correct type");
        }
        this.statusType = statusType;
        this.response = response;
    }

    public short getStatusType() {
        return this.statusType;
    }

    public Object getResponse() {
        return this.response;
    }

    public OCSPResponse getOCSPResponse() {
        if (!CertificateStatus.isCorrectType((short)1, this.response)) {
            throw new IllegalStateException("'response' is not an OCSPResponse");
        }
        return (OCSPResponse)this.response;
    }

    public void encode(OutputStream output) throws IOException {
        TlsUtils.writeUint8(this.statusType, output);
        switch (this.statusType) {
            case 1: {
                byte[] derEncoding = ((OCSPResponse)this.response).getEncoded("DER");
                TlsUtils.writeOpaque24(derEncoding, output);
                break;
            }
            default: {
                throw new TlsFatalAlert(80);
            }
        }
    }

    public static CertificateStatus parse(InputStream input) throws IOException {
        OCSPResponse response;
        short status_type = TlsUtils.readUint8(input);
        switch (status_type) {
            case 1: {
                byte[] derEncoding = TlsUtils.readOpaque24(input);
                response = OCSPResponse.getInstance(TlsUtils.readDERObject(derEncoding));
                break;
            }
            default: {
                throw new TlsFatalAlert(50);
            }
        }
        return new CertificateStatus(status_type, response);
    }

    protected static boolean isCorrectType(short statusType, Object response) {
        switch (statusType) {
            case 1: {
                return response instanceof OCSPResponse;
            }
        }
        throw new IllegalArgumentException("'statusType' is an unsupported CertificateStatusType");
    }
}

