/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.List;
import net.sf.freecol.common.model.AbstractUnit;
import net.sf.freecol.common.model.BuildingType;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.EuropeanNationType;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.Nation;
import net.sf.freecol.common.model.NationType;
import net.sf.freecol.common.model.Role;
import net.sf.freecol.common.model.SettlementType;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.option.OptionGroup;
import net.sf.freecol.common.util.CollectionUtils;
import net.sf.freecol.util.test.FreeColTestCase;

public class NationTypeTest
extends FreeColTestCase {
    public void testHasType() {
        Specification s = NationTypeTest.spec();
        for (Nation n : s.getNations()) {
            NationTypeTest.assertNotNull((String)n.toString(), (Object)n.getType());
        }
    }

    public void testisRef() {
        Specification s = NationTypeTest.spec();
        NationTypeTest.assertTrue((boolean)s.getNationType("model.nationType.trade").isEuropean());
        NationTypeTest.assertTrue((boolean)s.getNationType("model.nationType.default").isEuropean());
        NationTypeTest.assertTrue((boolean)s.getNationType("model.nationType.ref").isEuropean());
        NationTypeTest.assertTrue((boolean)s.getNationType("model.nationType.cooperation").isEuropean());
        NationTypeTest.assertTrue((boolean)s.getNationType("model.nationType.immigration").isEuropean());
        NationTypeTest.assertTrue((boolean)s.getNationType("model.nationType.conquest").isEuropean());
        NationTypeTest.assertFalse((boolean)s.getNationType("model.nationType.apache").isEuropean());
        NationTypeTest.assertFalse((boolean)s.getNationType("model.nationType.sioux").isEuropean());
        NationTypeTest.assertFalse((boolean)s.getNationType("model.nationType.tupi").isEuropean());
        NationTypeTest.assertFalse((boolean)s.getNationType("model.nationType.arawak").isEuropean());
        NationTypeTest.assertFalse((boolean)s.getNationType("model.nationType.cherokee").isEuropean());
        NationTypeTest.assertFalse((boolean)s.getNationType("model.nationType.iroquois").isEuropean());
        NationTypeTest.assertFalse((boolean)s.getNationType("model.nationType.inca").isEuropean());
        NationTypeTest.assertFalse((boolean)s.getNationType("model.nationType.aztec").isEuropean());
    }

    public void testIsREF() {
        Specification s = NationTypeTest.spec();
        NationTypeTest.assertFalse((boolean)s.getNationType("model.nationType.trade").isREF());
        NationTypeTest.assertFalse((boolean)s.getNationType("model.nationType.default").isREF());
        NationTypeTest.assertTrue((boolean)s.getNationType("model.nationType.ref").isREF());
        NationTypeTest.assertFalse((boolean)s.getNationType("model.nationType.cooperation").isREF());
        NationTypeTest.assertFalse((boolean)s.getNationType("model.nationType.immigration").isREF());
        NationTypeTest.assertFalse((boolean)s.getNationType("model.nationType.conquest").isREF());
        NationTypeTest.assertFalse((boolean)s.getNationType("model.nationType.apache").isREF());
        NationTypeTest.assertFalse((boolean)s.getNationType("model.nationType.sioux").isREF());
        NationTypeTest.assertFalse((boolean)s.getNationType("model.nationType.tupi").isREF());
        NationTypeTest.assertFalse((boolean)s.getNationType("model.nationType.arawak").isREF());
        NationTypeTest.assertFalse((boolean)s.getNationType("model.nationType.cherokee").isREF());
        NationTypeTest.assertFalse((boolean)s.getNationType("model.nationType.iroquois").isREF());
        NationTypeTest.assertFalse((boolean)s.getNationType("model.nationType.inca").isREF());
        NationTypeTest.assertFalse((boolean)s.getNationType("model.nationType.aztec").isREF());
    }

    public void testSettlementType() {
        for (NationType nationType : NationTypeTest.spec().getIndianNationTypes()) {
            NationTypeTest.assertFalse((boolean)nationType.getSettlementTypes().isEmpty());
            SettlementType settlement = nationType.getSettlementType(false);
            SettlementType capital = nationType.getSettlementType(true);
            NationTypeTest.assertNotNull((String)nationType.getId(), (Object)settlement);
            NationTypeTest.assertNotNull((String)nationType.getId(), (Object)capital);
            NationTypeTest.assertFalse((String)nationType.getId(), (capital == settlement ? 1 : 0) != 0);
        }
    }

    public void testStartingUnits() {
        int difficulty = 0;
        for (OptionGroup og : NationTypeTest.spec().getDifficultyLevels()) {
            NationTypeTest.spec().applyDifficultyLevel(og);
            for (EuropeanNationType type : NationTypeTest.spec().getEuropeanNationTypes()) {
                List<AbstractUnit> startingUnits = type.getStartingUnits();
                NationTypeTest.assertEquals((String)("Wrong number of starting units: " + type.toString()), (int)3, (int)startingUnits.size());
                for (AbstractUnit au : startingUnits) {
                    String unitTypeId = au.getId();
                    if ("model.role.soldier".equals(au.getRoleId())) {
                        if (difficulty == 0 || difficulty == 1 || "model.nationType.conquest".equals(type.getId())) {
                            NationTypeTest.assertEquals((String)("Wrong type of soldier: " + type.toString()), (String)"model.unit.veteranSoldier", (String)unitTypeId);
                            continue;
                        }
                        NationTypeTest.assertFalse((String)("Wrong type of soldier: " + type.toString()), (boolean)"model.unit.veteranSoldier".equals(unitTypeId));
                        continue;
                    }
                    if ("model.role.pioneer".equals(au.getRoleId())) {
                        if ("model.nationType.cooperation".equals(type.getId())) {
                            NationTypeTest.assertEquals((String)("Wrong type of pioneer: " + type.toString()), (String)"model.unit.hardyPioneer", (String)unitTypeId);
                            continue;
                        }
                        NationTypeTest.assertFalse((String)("Wrong type of pioneer: " + type.toString()), (boolean)"model.unit.hardyPioneer".equals(unitTypeId));
                        continue;
                    }
                    if (!Role.isDefaultRoleId(au.getRoleId())) continue;
                    NationTypeTest.assertTrue((String)("Ship is not naval: " + type.toString()), (boolean)NationTypeTest.spec().getUnitType(au.getId()).hasAbility("model.ability.navalUnit"));
                    if ("model.nationType.trade".equals(type.getId()) || "model.nationType.naval".equals(type.getId())) {
                        NationTypeTest.assertEquals((String)("Wrong type of ship: " + type.toString()), (String)"model.unit.merchantman", (String)unitTypeId);
                        continue;
                    }
                    NationTypeTest.assertEquals((String)("Wrong type of ship: " + type.toString()), (String)"model.unit.caravel", (String)unitTypeId);
                }
            }
            ++difficulty;
        }
    }

    public void testAdvantagesThatOnlyApplyToPersons() {
        Game game = NationTypeTest.getGame();
        game.changeMap(NationTypeTest.getTestMap(true));
        Colony colony = this.getStandardColony();
        colony.getOwner().changeNationType(NationTypeTest.spec().getNationType("model.nationType.building"));
        List<Modifier> modifiers = CollectionUtils.toList(colony.getOwner().getModifiers("model.goods.hammers"));
        NationTypeTest.assertEquals((int)1, (int)modifiers.size());
        BuildingType carpenterHouse = NationTypeTest.spec().getBuildingType("model.building.carpenterHouse");
        NationTypeTest.assertFalse((String)"Hammer production bonus should not apply to buildings", (boolean)modifiers.get(0).appliesTo(carpenterHouse));
        for (Unit unit : colony.getUnitList()) {
            NationTypeTest.assertTrue((String)"Hammer production bonus should apply to all persons", (boolean)modifiers.get(0).appliesTo(unit.getType()));
        }
        colony.getOwner().changeNationType(NationTypeTest.spec().getNationType("model.nationType.furTrapping"));
        modifiers = CollectionUtils.toList(colony.getOwner().getModifiers("model.goods.coats"));
        NationTypeTest.assertEquals((int)1, (int)modifiers.size());
        BuildingType traderHouse = NationTypeTest.spec().getBuildingType("model.building.furTraderHouse");
        NationTypeTest.assertFalse((String)"Coat production bonus should not apply to buildings", (boolean)modifiers.get(0).appliesTo(traderHouse));
        for (Unit unit : colony.getUnitList()) {
            NationTypeTest.assertTrue((String)"Coat production bonus should apply to all persons", (boolean)modifiers.get(0).appliesTo(unit.getType()));
        }
    }
}

