/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.oauthbearer.internals.secured;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.security.auth.login.AppConfigurationEntry;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.types.Password;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.oauthbearer.internals.secured.OAuthBearerConfigurable;
import org.apache.kafka.common.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigurationUtils.class);
    private final Map<String, ?> configs;
    private final String prefix;

    public ConfigurationUtils(Map<String, ?> configs) {
        this(configs, null);
    }

    public ConfigurationUtils(Map<String, ?> configs, String saslMechanism) {
        this.configs = configs;
        this.prefix = saslMechanism != null && !saslMechanism.trim().isEmpty() ? ListenerName.saslMechanismPrefix(saslMechanism.trim()) : null;
    }

    public boolean containsKey(String name) {
        return this.get(name) != null;
    }

    public File validateFileUrl(String name) {
        File file;
        URL url = this.validateUrl(name);
        try {
            file = new File(url.toURI().getRawPath()).getAbsoluteFile();
        }
        catch (URISyntaxException e) {
            throw new ConfigException(String.format("The OAuth configuration option %s contains a URL (%s) that is malformed: %s", name, url, e.getMessage()));
        }
        return this.validateFile(name, file);
    }

    public File validateFile(String name) {
        String s = this.validateString(name);
        File file = this.validateFile(name, new File(s).getAbsoluteFile());
        this.throwIfFileIsNotAllowed(name, file.getAbsolutePath());
        return file;
    }

    private File validateFile(String name, File file) {
        if (!file.exists()) {
            throw new ConfigException(String.format("The OAuth configuration option %s contains a file (%s) that doesn't exist", name, file));
        }
        if (!file.canRead()) {
            throw new ConfigException(String.format("The OAuth configuration option %s contains a file (%s) that doesn't have read permission", name, file));
        }
        if (file.isDirectory()) {
            throw new ConfigException(String.format("The OAuth configuration option %s references a directory (%s), not a file", name, file));
        }
        return file;
    }

    public Integer validateInteger(String name, boolean isRequired) {
        Integer value = (Integer)this.get(name);
        if (value == null) {
            if (isRequired) {
                throw new ConfigException(String.format("The OAuth configuration option %s is required", name));
            }
            return null;
        }
        return value;
    }

    public Long validateLong(String name) {
        return this.validateLong(name, true);
    }

    public Long validateLong(String name, boolean isRequired) {
        return this.validateLong(name, isRequired, null);
    }

    public Long validateLong(String name, boolean isRequired, Long min) {
        Long value = (Long)this.get(name);
        if (value == null) {
            if (isRequired) {
                throw new ConfigException(String.format("The OAuth configuration option %s is required", name));
            }
            return null;
        }
        if (min != null && value < min) {
            throw new ConfigException(String.format("The OAuth configuration option %s value must be at least %s", name, min));
        }
        return value;
    }

    public URL validateUrl(String name) {
        URL url;
        String value = this.validateString(name);
        try {
            url = new URL(value);
        }
        catch (MalformedURLException e) {
            throw new ConfigException(String.format("The OAuth configuration option %s contains a URL (%s) that is malformed: %s", name, value, e.getMessage()));
        }
        String protocol = url.getProtocol();
        if (protocol == null || protocol.trim().isEmpty()) {
            throw new ConfigException(String.format("The OAuth configuration option %s contains a URL (%s) that is missing the protocol", name, value));
        }
        if (!((protocol = protocol.toLowerCase(Locale.ROOT)).equals("http") || protocol.equals("https") || protocol.equals("file"))) {
            throw new ConfigException(String.format("The OAuth configuration option %s contains a URL (%s) that contains an invalid protocol (%s); only \"http\", \"https\", and \"file\" protocol are supported", name, value, protocol));
        }
        this.throwIfURLIsNotAllowed(name, value);
        return url;
    }

    public String validatePassword(String name) {
        Password value = (Password)this.get(name);
        if (value == null || Utils.isBlank(value.value())) {
            throw new ConfigException(String.format("The OAuth configuration option %s value is required", name));
        }
        return value.value().trim();
    }

    public String validateString(String name) {
        return this.validateString(name, true);
    }

    public String validateString(String name, boolean isRequired) {
        String value = (String)this.get(name);
        if (Utils.isBlank(value)) {
            if (isRequired) {
                throw new ConfigException(String.format("The OAuth configuration option %s value is required", name));
            }
            return null;
        }
        return value.trim();
    }

    public Boolean validateBoolean(String name, boolean isRequired) {
        Boolean value = (Boolean)this.get(name);
        if (value == null && isRequired) {
            throw new ConfigException(String.format("The OAuth configuration option %s is required", name));
        }
        return value;
    }

    public <T> T get(String name) {
        Object value = this.configs.get(this.prefix + name);
        if (value != null) {
            return (T)value;
        }
        return (T)this.configs.get(name);
    }

    public static <T> T getConfiguredInstance(Map<String, ?> configs, String saslMechanism, List<AppConfigurationEntry> jaasConfigEntries, String configName, Class<T> expectedClass) {
        T o;
        Object configValue = configs.get(configName);
        if (configValue instanceof String) {
            String implementationClassName = (String)configValue;
            try {
                o = Utils.newInstance(implementationClassName, expectedClass);
            }
            catch (Exception e) {
                throw new ConfigException(String.format("The class %s defined in the %s configuration could not be instantiated: %s", implementationClassName, configName, e.getMessage()));
            }
        } else if (configValue instanceof Class) {
            Class implementationClass = (Class)configValue;
            try {
                o = Utils.newInstance(implementationClass);
            }
            catch (Exception e) {
                throw new ConfigException(String.format("The class %s defined in the %s configuration could not be instantiated: %s", implementationClass.getName(), configName, e.getMessage()));
            }
        } else {
            if (configValue != null) {
                throw new ConfigException(String.format("The type for the %s configuration must be either %s or %s, but was %s", configName, String.class.getName(), Class.class.getName(), configValue.getClass().getName()));
            }
            throw new ConfigException(String.format("The required configuration %s was null", configName));
        }
        if (!expectedClass.isInstance(o)) {
            throw new ConfigException(String.format("The configured class (%s) for the %s configuration is not an instance of %s, as is required", o.getClass().getName(), configName, expectedClass.getName()));
        }
        if (o instanceof OAuthBearerConfigurable) {
            try {
                ((OAuthBearerConfigurable)o).configure(configs, saslMechanism, jaasConfigEntries);
            }
            catch (Exception e) {
                Utils.maybeCloseQuietly(o, "Instance of class " + o.getClass().getName() + " failed call to configure()");
                LOG.warn("The class {} defined in the {} configuration encountered an error on configure(): {}", new Object[]{o.getClass().getName(), configName, e.getMessage(), e});
                throw new ConfigException(String.format("The class %s defined in the %s configuration encountered an error on configure(): %s", o.getClass().getName(), configName, e.getMessage()));
            }
        }
        return expectedClass.cast(o);
    }

    void throwIfURLIsNotAllowed(String configName, String configValue) {
        this.throwIfResourceIsNotAllowed("URL", configName, configValue, "org.apache.kafka.sasl.oauthbearer.allowed.urls", "");
    }

    void throwIfFileIsNotAllowed(String configName, String configValue) {
        this.throwIfResourceIsNotAllowed("file", configName, configValue, "org.apache.kafka.sasl.oauthbearer.allowed.files", "");
    }

    private void throwIfResourceIsNotAllowed(String resourceType, String configName, String configValue, String propertyName, String propertyDefault) {
        String[] allowedArray = System.getProperty(propertyName, propertyDefault).split(",");
        Set allowed = Arrays.stream(allowedArray).map(String::trim).collect(Collectors.toSet());
        if (!allowed.contains(configValue)) {
            String message = String.format("The %s cannot be accessed due to restrictions. Update the system property '%s' to allow the %s to be accessed.", resourceType, propertyName, resourceType);
            throw new ConfigException(configName, configValue, message);
        }
    }
}

