/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.serializer;

import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.constants.ProtocolVersion;
import de.rub.nds.tlsattacker.core.protocol.message.HeartbeatMessage;
import de.rub.nds.tlsattacker.core.protocol.serializer.ProtocolMessageSerializer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HeartbeatMessageSerializer
extends ProtocolMessageSerializer<HeartbeatMessage> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final HeartbeatMessage msg;

    public HeartbeatMessageSerializer(HeartbeatMessage message, ProtocolVersion version) {
        super(message, version);
        this.msg = message;
    }

    @Override
    public byte[] serializeProtocolMessageContent() {
        LOGGER.debug("Serializing HeartbeatMessage");
        this.writeHeartbeatMessageType(this.msg);
        this.writePayloadLength(this.msg);
        this.writePayload(this.msg);
        this.writePadding(this.msg);
        return this.getAlreadySerialized();
    }

    private void writeHeartbeatMessageType(HeartbeatMessage msg) {
        this.appendByte((Byte)msg.getHeartbeatMessageType().getValue());
        LOGGER.debug("HeartbeatMessageType: " + msg.getHeartbeatMessageType().getValue());
    }

    private void writePayloadLength(HeartbeatMessage msg) {
        this.appendInt((Integer)msg.getPayloadLength().getValue(), 2);
        LOGGER.debug("PayloadLength: " + msg.getPayloadLength().getValue());
    }

    private void writePayload(HeartbeatMessage msg) {
        this.appendBytes((byte[])msg.getPayload().getValue());
        LOGGER.debug("Payload: " + ArrayConverter.bytesToHexString((byte[])((byte[])msg.getPayload().getValue())));
    }

    private void writePadding(HeartbeatMessage msg) {
        this.appendBytes((byte[])msg.getPadding().getValue());
        LOGGER.debug("Padding: " + ArrayConverter.bytesToHexString((byte[])((byte[])msg.getPadding().getValue())));
    }
}

