/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.parsetree.reconstr.impl;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.parsetree.reconstr.impl.AbstractCommentAssociater;
import org.eclipse.xtext.parsetree.reconstr.impl.NodeIterator;
import org.eclipse.xtext.parsetree.reconstr.impl.TokenUtil;
import org.eclipse.xtext.util.ITextRegionWithLineInformation;
import org.eclipse.xtext.util.Pair;

public class DefaultCommentAssociater
extends AbstractCommentAssociater {
    @Inject
    protected TokenUtil tokenUtil;

    @Override
    public Map<ILeafNode, EObject> associateCommentsWithSemanticEObjects(EObject model, Set<ICompositeNode> roots) {
        HashMap<ILeafNode, EObject> mapping = new HashMap<ILeafNode, EObject>();
        for (ICompositeNode rootNode : roots) {
            this.associateCommentsWithSemanticEObjects(mapping, rootNode);
        }
        return mapping;
    }

    protected void associateCommentsWithSemanticEObjects(Map<ILeafNode, EObject> mapping, ICompositeNode rootNode) {
        INode node;
        EObject currentEObject = null;
        ArrayList<ILeafNode> currentComments = new ArrayList<ILeafNode>();
        NodeIterator nodeIterator = new NodeIterator(rootNode);
        while (nodeIterator.hasPrevious() && currentEObject == null) {
            node = nodeIterator.previous();
            if (!this.tokenUtil.isToken(node)) continue;
            currentEObject = this.tokenUtil.getTokenOwner(node);
        }
        while (nodeIterator.hasNext()) {
            ITextRegionWithLineInformation textRegion;
            node = nodeIterator.next();
            if (this.tokenUtil.isCommentNode(node)) {
                currentComments.add((ILeafNode)node);
            }
            boolean isToken = this.tokenUtil.isToken(node);
            if ((node instanceof ILeafNode || isToken) && currentEObject != null && (textRegion = node.getTextRegionWithLineInformation()).getLineNumber() != textRegion.getEndLineNumber()) {
                this.addMapping(mapping, currentComments, currentEObject);
                currentEObject = null;
            }
            if (!isToken) continue;
            Pair<List<ILeafNode>, List<ILeafNode>> leadingAndTrailingHiddenTokens = this.tokenUtil.getLeadingAndTrailingHiddenTokens(node);
            for (ILeafNode leadingHiddenNode : (List)leadingAndTrailingHiddenTokens.getFirst()) {
                if (!this.tokenUtil.isCommentNode(leadingHiddenNode)) continue;
                currentComments.add(leadingHiddenNode);
            }
            nodeIterator.prune();
            currentEObject = this.tokenUtil.getTokenOwner(node);
            if (currentEObject == null) continue;
            this.addMapping(mapping, currentComments, currentEObject);
            if (node.getOffset() > rootNode.getEndOffset()) break;
        }
        if (!currentComments.isEmpty()) {
            if (currentEObject != null) {
                this.addMapping(mapping, currentComments, currentEObject);
            } else {
                EObject objectForRemainingComments = this.getEObjectForRemainingComments(rootNode);
                if (objectForRemainingComments != null) {
                    this.addMapping(mapping, currentComments, objectForRemainingComments);
                }
            }
        }
    }

    protected void addMapping(Map<ILeafNode, EObject> mapping, List<ILeafNode> currentComments, EObject currentEObject) {
        for (ILeafNode l : currentComments) {
            mapping.put(l, currentEObject);
        }
        currentComments.clear();
    }

    protected EObject getEObjectForRemainingComments(ICompositeNode rootNode) {
        for (INode o : rootNode.getAsTreeIterable()) {
            if (!o.hasDirectSemanticElement()) continue;
            return o.getSemanticElement();
        }
        return null;
    }
}

