/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.format.jackson;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.reflect.Type;
import org.hibernate.type.format.AbstractJsonFormatMapper;

public final class JacksonJsonFormatMapper
extends AbstractJsonFormatMapper {
    public static final String SHORT_NAME = "jackson";
    private final ObjectMapper objectMapper;

    public JacksonJsonFormatMapper() {
        this(new ObjectMapper().findAndRegisterModules());
    }

    public JacksonJsonFormatMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    @Override
    public <T> T fromString(CharSequence charSequence, Type type) {
        try {
            return (T)this.objectMapper.readValue(charSequence.toString(), this.objectMapper.constructType(type));
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("Could not deserialize string to java type: " + type, e);
        }
    }

    @Override
    public <T> String toString(T value, Type type) {
        try {
            return this.objectMapper.writerFor(this.objectMapper.constructType(type)).writeValueAsString(value);
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("Could not serialize object of java type: " + type, e);
        }
    }
}

