/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.codeInsight.daemon.impl.analysis.JavaGenericsUtil;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.util.Pair;
import org.jetbrains.kotlin.com.intellij.pom.java.LanguageLevel;
import org.jetbrains.kotlin.com.intellij.psi.JavaPsiFacade;
import org.jetbrains.kotlin.com.intellij.psi.JavaTokenType;
import org.jetbrains.kotlin.com.intellij.psi.PsiArrayType;
import org.jetbrains.kotlin.com.intellij.psi.PsiCaseLabelElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiCaseLabelElementList;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiClassType;
import org.jetbrains.kotlin.com.intellij.psi.PsiConditionalExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiConditionalLoopStatement;
import org.jetbrains.kotlin.com.intellij.psi.PsiDeconstructionList;
import org.jetbrains.kotlin.com.intellij.psi.PsiDeconstructionPattern;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementFactory;
import org.jetbrains.kotlin.com.intellij.psi.PsiExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiForeachPatternStatement;
import org.jetbrains.kotlin.com.intellij.psi.PsiIfStatement;
import org.jetbrains.kotlin.com.intellij.psi.PsiInstanceOfExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiParenthesizedExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiParenthesizedPattern;
import org.jetbrains.kotlin.com.intellij.psi.PsiPattern;
import org.jetbrains.kotlin.com.intellij.psi.PsiPatternVariable;
import org.jetbrains.kotlin.com.intellij.psi.PsiPolyadicExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiPrefixExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiPrimaryPattern;
import org.jetbrains.kotlin.com.intellij.psi.PsiPrimitiveType;
import org.jetbrains.kotlin.com.intellij.psi.PsiRecordComponent;
import org.jetbrains.kotlin.com.intellij.psi.PsiSubstitutor;
import org.jetbrains.kotlin.com.intellij.psi.PsiSwitchBlock;
import org.jetbrains.kotlin.com.intellij.psi.PsiSwitchLabelStatementBase;
import org.jetbrains.kotlin.com.intellij.psi.PsiType;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeTestPattern;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypes;
import org.jetbrains.kotlin.com.intellij.psi.PsiUnnamedPattern;
import org.jetbrains.kotlin.com.intellij.psi.codeStyle.JavaCodeStyleManager;
import org.jetbrains.kotlin.com.intellij.psi.codeStyle.VariableKind;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.JavaVarTypeUtil;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.psi.util.InheritanceUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTypesUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.TypeConversionUtil;
import org.jetbrains.kotlin.com.intellij.util.ArrayUtil;
import org.jetbrains.kotlin.com.intellij.util.ObjectUtils;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;
import org.jetbrains.kotlin.one.util.streamex.AbstractStreamEx;
import org.jetbrains.kotlin.one.util.streamex.StreamEx;

public final class JavaPsiPatternUtil {
    @Contract(pure=true)
    @NotNull
    public static List<PsiPatternVariable> getExposedPatternVariables(@NotNull PsiExpression expression2) {
        if (expression2 == null) {
            JavaPsiPatternUtil.$$$reportNull$$$0(0);
        }
        List<PatternVariableWrapper> list = JavaPsiPatternUtil.collectPatternVariableWrappers(expression2);
        List<PsiPatternVariable> list2 = ((AbstractStreamEx)((StreamEx)StreamEx.of(list).filter(base -> !base.isFake())).map(PatternVariableWrapper::getVariable)).toList();
        if (list2 == null) {
            JavaPsiPatternUtil.$$$reportNull$$$0(1);
        }
        return list2;
    }

    @Contract(pure=true)
    @NotNull
    public static List<PatternVariableWrapper> collectPatternVariableWrappers(@NotNull PsiExpression expression2) {
        PsiElement parent2;
        boolean parentMayAccept;
        if (expression2 == null) {
            JavaPsiPatternUtil.$$$reportNull$$$0(2);
        }
        boolean bl = parentMayAccept = (parent2 = PsiUtil.skipParenthesizedExprUp(expression2.getParent())) instanceof PsiPrefixExpression && ((PsiPrefixExpression)parent2).getOperationTokenType().equals(JavaTokenType.EXCL) || parent2 instanceof PsiPolyadicExpression && ((PsiPolyadicExpression)parent2).getOperationTokenType().equals(JavaTokenType.ANDAND) || parent2 instanceof PsiPolyadicExpression && ((PsiPolyadicExpression)parent2).getOperationTokenType().equals(JavaTokenType.OROR) || parent2 instanceof PsiConditionalExpression || parent2 instanceof PsiIfStatement || parent2 instanceof PsiConditionalLoopStatement;
        if (!parentMayAccept) {
            List<PatternVariableWrapper> list = Collections.emptyList();
            if (list == null) {
                JavaPsiPatternUtil.$$$reportNull$$$0(3);
            }
            return list;
        }
        ArrayList<PatternVariableWrapper> list = new ArrayList<PatternVariableWrapper>();
        JavaPsiPatternUtil.collectPatternVariableCandidates(expression2, expression2, list, false);
        ArrayList<PatternVariableWrapper> arrayList = list;
        if (arrayList == null) {
            JavaPsiPatternUtil.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    @Contract(pure=true)
    @NotNull
    public static List<PsiPatternVariable> getExposedPatternVariablesIgnoreParent(@NotNull PsiExpression expression2) {
        if (expression2 == null) {
            JavaPsiPatternUtil.$$$reportNull$$$0(5);
        }
        ArrayList<PatternVariableWrapper> list = new ArrayList<PatternVariableWrapper>();
        JavaPsiPatternUtil.collectPatternVariableCandidates(expression2, expression2, list, true);
        List<PsiPatternVariable> list2 = ((AbstractStreamEx)((StreamEx)StreamEx.of(list).filter(base -> !base.isFake())).map(PatternVariableWrapper::getVariable)).toList();
        if (list2 == null) {
            JavaPsiPatternUtil.$$$reportNull$$$0(6);
        }
        return list2;
    }

    @Nullable
    public static String getEffectiveInitializerText(@NotNull PsiPatternVariable variable) {
        PsiPattern pattern;
        PsiInstanceOfExpression instanceOf;
        if (variable == null) {
            JavaPsiPatternUtil.$$$reportNull$$$0(7);
        }
        if ((instanceOf = ObjectUtils.tryCast((pattern = variable.getPattern()).getParent(), PsiInstanceOfExpression.class)) == null) {
            return null;
        }
        PsiExpression operand = instanceOf.getOperand();
        PsiTypeElement checkType = pattern instanceof PsiTypeTestPattern ? ((PsiTypeTestPattern)pattern).getCheckType() : (pattern instanceof PsiDeconstructionPattern ? ((PsiDeconstructionPattern)pattern).getTypeElement() : null);
        if (checkType == null) {
            return null;
        }
        if (checkType.getType().equals(operand.getType())) {
            return operand.getText();
        }
        return "(" + checkType.getText() + ")" + operand.getText();
    }

    @Contract(value="null -> null", pure=true)
    @Nullable
    public static PsiPattern skipParenthesizedPatternDown(PsiPattern pattern) {
        while (pattern instanceof PsiParenthesizedPattern) {
            pattern = ((PsiParenthesizedPattern)pattern).getPattern();
        }
        return pattern;
    }

    public static PsiElement skipParenthesizedPatternUp(PsiElement parent2) {
        while (parent2 instanceof PsiParenthesizedPattern) {
            parent2 = parent2.getParent();
        }
        return parent2;
    }

    @Contract(value="null -> null", pure=true)
    @Nullable
    public static PsiPatternVariable getPatternVariable(@Nullable PsiCaseLabelElement pattern) {
        if (pattern instanceof PsiParenthesizedPattern) {
            return JavaPsiPatternUtil.getPatternVariable(((PsiParenthesizedPattern)pattern).getPattern());
        }
        if (pattern instanceof PsiTypeTestPattern) {
            return ((PsiTypeTestPattern)pattern).getPatternVariable();
        }
        if (pattern instanceof PsiDeconstructionPattern) {
            return ((PsiDeconstructionPattern)pattern).getPatternVariable();
        }
        return null;
    }

    @Contract(value="null -> null", pure=true)
    @Nullable
    public static PsiPrimaryPattern getTypedPattern(@Nullable PsiCaseLabelElement element) {
        if (element instanceof PsiParenthesizedPattern) {
            return JavaPsiPatternUtil.getTypedPattern(((PsiParenthesizedPattern)element).getPattern());
        }
        if (element instanceof PsiDeconstructionPattern) {
            return (PsiDeconstructionPattern)element;
        }
        if (element instanceof PsiTypeTestPattern) {
            return (PsiTypeTestPattern)element;
        }
        return null;
    }

    @Contract(value="null -> false", pure=true)
    public static boolean containsNamedPatternVariable(@Nullable PsiCaseLabelElement pattern) {
        if (pattern instanceof PsiTypeTestPattern) {
            PsiPatternVariable variable = ((PsiTypeTestPattern)pattern).getPatternVariable();
            return variable != null && !variable.isUnnamed();
        }
        if (pattern instanceof PsiParenthesizedPattern) {
            return JavaPsiPatternUtil.containsNamedPatternVariable(((PsiParenthesizedPattern)pattern).getPattern());
        }
        if (pattern instanceof PsiDeconstructionPattern) {
            PsiDeconstructionPattern deconstructionPattern = (PsiDeconstructionPattern)pattern;
            return deconstructionPattern.getPatternVariable() != null || ContainerUtil.exists(deconstructionPattern.getDeconstructionList().getDeconstructionComponents(), component -> JavaPsiPatternUtil.containsNamedPatternVariable(component));
        }
        return false;
    }

    public static boolean isGuarded(@NotNull PsiCaseLabelElement pattern) {
        PsiExpression guardExpression;
        PsiElement gParent;
        PsiElement parent2;
        if (pattern == null) {
            JavaPsiPatternUtil.$$$reportNull$$$0(8);
        }
        return (parent2 = pattern.getParent()) instanceof PsiCaseLabelElementList && (gParent = parent2.getParent()) instanceof PsiSwitchLabelStatementBase && (guardExpression = ((PsiSwitchLabelStatementBase)gParent).getGuardExpression()) != null && !Boolean.TRUE.equals(JavaPsiPatternUtil.evaluateConstant(guardExpression));
    }

    @Contract(value="null -> null", pure=true)
    @Nullable
    public static PsiType getPatternType(@Nullable PsiCaseLabelElement pattern) {
        PsiTypeElement typeElement = JavaPsiPatternUtil.getPatternTypeElement(pattern);
        if (typeElement == null) {
            return null;
        }
        return typeElement.getType();
    }

    @Nullable
    public static PsiTypeElement getPatternTypeElement(@Nullable PsiCaseLabelElement pattern) {
        if (pattern == null) {
            return null;
        }
        if (pattern instanceof PsiParenthesizedPattern) {
            return JavaPsiPatternUtil.getPatternTypeElement(((PsiParenthesizedPattern)pattern).getPattern());
        }
        if (pattern instanceof PsiDeconstructionPattern) {
            return ((PsiDeconstructionPattern)pattern).getTypeElement();
        }
        if (pattern instanceof PsiTypeTestPattern) {
            return ((PsiTypeTestPattern)pattern).getCheckType();
        }
        if (pattern instanceof PsiUnnamedPattern) {
            return ((PsiUnnamedPattern)pattern).getTypeElement();
        }
        return null;
    }

    @Contract(value="null, _ -> false", pure=true)
    public static boolean isUnconditionalForType(@Nullable PsiCaseLabelElement pattern, @NotNull PsiType type2) {
        if (type2 == null) {
            JavaPsiPatternUtil.$$$reportNull$$$0(9);
        }
        return JavaPsiPatternUtil.isUnconditionalForType(pattern, type2, false) && !JavaPsiPatternUtil.isGuarded(pattern);
    }

    @Nullable
    public static PsiPrimaryPattern findUnconditionalPattern(@Nullable PsiCaseLabelElement pattern) {
        if (pattern == null || JavaPsiPatternUtil.isGuarded(pattern)) {
            return null;
        }
        if (pattern instanceof PsiParenthesizedPattern) {
            return JavaPsiPatternUtil.findUnconditionalPattern(((PsiParenthesizedPattern)pattern).getPattern());
        }
        if (pattern instanceof PsiDeconstructionPattern || pattern instanceof PsiTypeTestPattern || pattern instanceof PsiUnnamedPattern) {
            return (PsiPrimaryPattern)pattern;
        }
        return null;
    }

    @Contract(value="null,_,_ -> false")
    public static boolean isUnconditionalForType(@Nullable PsiCaseLabelElement pattern, @NotNull PsiType type2, boolean forDomination) {
        PsiPrimaryPattern unconditionalPattern;
        if (type2 == null) {
            JavaPsiPatternUtil.$$$reportNull$$$0(10);
        }
        if ((unconditionalPattern = JavaPsiPatternUtil.findUnconditionalPattern(pattern)) == null) {
            return false;
        }
        if (unconditionalPattern instanceof PsiDeconstructionPattern) {
            return forDomination && JavaPsiPatternUtil.dominates(JavaPsiPatternUtil.getPatternType(unconditionalPattern), type2);
        }
        if (unconditionalPattern instanceof PsiTypeTestPattern || unconditionalPattern instanceof PsiUnnamedPattern) {
            return JavaPsiPatternUtil.dominates(JavaPsiPatternUtil.getPatternType(unconditionalPattern), type2);
        }
        return false;
    }

    public static boolean hasUnconditionalComponents(@NotNull PsiDeconstructionPattern pattern) {
        if (pattern == null) {
            JavaPsiPatternUtil.$$$reportNull$$$0(11);
        }
        PsiType type2 = pattern.getTypeElement().getType();
        PsiPattern[] patternComponents = pattern.getDeconstructionList().getDeconstructionComponents();
        PsiClass selectorClass = PsiUtil.resolveClassInClassTypeOnly(type2);
        if (selectorClass == null) {
            return false;
        }
        PsiRecordComponent[] recordComponents = selectorClass.getRecordComponents();
        if (patternComponents.length != recordComponents.length) {
            return false;
        }
        for (int i = 0; i < patternComponents.length; ++i) {
            PsiPattern patternComponent = patternComponents[i];
            PsiType componentType = recordComponents[i].getType();
            if (JavaPsiPatternUtil.isUnconditionalForType(patternComponent, componentType)) continue;
            return false;
        }
        return true;
    }

    public static boolean dominates(@Nullable PsiType who, @Nullable PsiType overWhom) {
        if (who == null || overWhom == null) {
            return false;
        }
        if (who.getCanonicalText().equals(overWhom.getCanonicalText())) {
            return true;
        }
        overWhom = TypeConversionUtil.erasure(overWhom);
        PsiType baseType = TypeConversionUtil.erasure(who);
        if (overWhom.equals(PsiTypes.nullType())) {
            return who instanceof PsiClassType || who instanceof PsiArrayType;
        }
        if (overWhom instanceof PsiArrayType || baseType instanceof PsiArrayType) {
            return baseType != null && TypeConversionUtil.isAssignable(baseType, overWhom);
        }
        PsiClass typeClass = PsiTypesUtil.getPsiClass(overWhom);
        PsiClass baseTypeClass = PsiTypesUtil.getPsiClass(baseType);
        return typeClass != null && baseTypeClass != null && InheritanceUtil.isInheritorOrSelf(typeClass, baseTypeClass, true);
    }

    @Contract(value="null, _ -> false", pure=true)
    public static boolean dominates(@Nullable PsiCaseLabelElement who, @NotNull PsiCaseLabelElement overWhom) {
        if (overWhom == null) {
            JavaPsiPatternUtil.$$$reportNull$$$0(12);
        }
        if (who == null) {
            return false;
        }
        PsiType overWhomType = JavaPsiPatternUtil.getPatternType(overWhom);
        if (overWhomType == null || !JavaPsiPatternUtil.isUnconditionalForType(who, overWhomType, true)) {
            return false;
        }
        PsiDeconstructionPattern whoDeconstruction = JavaPsiPatternUtil.findDeconstructionPattern(who);
        if (whoDeconstruction != null) {
            PsiDeconstructionPattern overWhomDeconstruction = JavaPsiPatternUtil.findDeconstructionPattern(overWhom);
            return JavaPsiPatternUtil.dominatesComponents(whoDeconstruction, overWhomDeconstruction);
        }
        return true;
    }

    private static boolean dominatesComponents(@NotNull PsiDeconstructionPattern who, @Nullable PsiDeconstructionPattern overWhom) {
        PsiPattern[] overWhomComponents;
        if (who == null) {
            JavaPsiPatternUtil.$$$reportNull$$$0(13);
        }
        if (overWhom == null) {
            return false;
        }
        PsiPattern[] whoComponents = who.getDeconstructionList().getDeconstructionComponents();
        if (whoComponents.length != (overWhomComponents = overWhom.getDeconstructionList().getDeconstructionComponents()).length) {
            return false;
        }
        for (int i = 0; i < whoComponents.length; ++i) {
            PsiPattern whoComponent = whoComponents[i];
            PsiPattern overWhomComponent = overWhomComponents[i];
            if (JavaPsiPatternUtil.dominates(whoComponent, overWhomComponent)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public static PsiDeconstructionPattern findDeconstructionPattern(@Nullable PsiCaseLabelElement element) {
        if (element instanceof PsiParenthesizedPattern) {
            return JavaPsiPatternUtil.findDeconstructionPattern(((PsiParenthesizedPattern)element).getPattern());
        }
        if (element instanceof PsiDeconstructionPattern) {
            return (PsiDeconstructionPattern)element;
        }
        return null;
    }

    @Contract(value="_,null -> false", pure=true)
    public static boolean dominatesOverConstant(@NotNull PsiCaseLabelElement who, @Nullable PsiType overWhom) {
        PsiType whoType;
        if (who == null) {
            JavaPsiPatternUtil.$$$reportNull$$$0(14);
        }
        if (overWhom == null) {
            return false;
        }
        if (PsiUtil.getLanguageLevel(who) != LanguageLevel.JDK_20_PREVIEW) {
            who = JavaPsiPatternUtil.findUnconditionalPattern(who);
        }
        if ((whoType = TypeConversionUtil.erasure(JavaPsiPatternUtil.getPatternType(who))) == null) {
            return false;
        }
        PsiType overWhomType = null;
        if (overWhom instanceof PsiPrimitiveType) {
            overWhomType = ((PsiPrimitiveType)overWhom).getBoxedType(who);
        } else if (overWhom instanceof PsiClassType) {
            overWhomType = overWhom;
        }
        return overWhomType != null && TypeConversionUtil.areTypesConvertible(overWhomType, whoType);
    }

    @Contract(pure=true)
    @Nullable
    public static PsiRecordComponent getRecordComponentForPattern(@NotNull PsiPattern pattern) {
        PsiDeconstructionList deconstructionList;
        if (pattern == null) {
            JavaPsiPatternUtil.$$$reportNull$$$0(15);
        }
        if ((deconstructionList = ObjectUtils.tryCast(pattern.getParent(), PsiDeconstructionList.class)) == null) {
            return null;
        }
        @NotNull Object @NotNull [] patterns = deconstructionList.getDeconstructionComponents();
        int index = ArrayUtil.indexOf(patterns, pattern);
        PsiDeconstructionPattern deconstructionPattern = ObjectUtils.tryCast(deconstructionList.getParent(), PsiDeconstructionPattern.class);
        if (deconstructionPattern == null) {
            return null;
        }
        PsiClassType classType = ObjectUtils.tryCast(deconstructionPattern.getTypeElement().getType(), PsiClassType.class);
        if (classType == null) {
            return null;
        }
        PsiClass aClass = classType.resolve();
        if (aClass == null) {
            return null;
        }
        PsiRecordComponent[] components = aClass.getRecordComponents();
        if (components.length <= index) {
            return null;
        }
        return components[index];
    }

    @Nullable
    public static PsiType getDeconstructedImplicitPatternVariableType(@NotNull PsiPatternVariable parameter) {
        if (parameter == null) {
            JavaPsiPatternUtil.$$$reportNull$$$0(16);
        }
        return JavaPsiPatternUtil.getDeconstructedImplicitPatternType(parameter.getPattern());
    }

    @Nullable
    public static PsiType getDeconstructedImplicitPatternType(@NotNull PsiPattern pattern) {
        PsiRecordComponent recordComponent;
        if (pattern == null) {
            JavaPsiPatternUtil.$$$reportNull$$$0(17);
        }
        if ((recordComponent = JavaPsiPatternUtil.getRecordComponentForPattern(pattern)) != null) {
            PsiDeconstructionList deconstructionList = ObjectUtils.tryCast(pattern.getParent(), PsiDeconstructionList.class);
            if (deconstructionList == null) {
                return null;
            }
            PsiDeconstructionPattern deconstructionPattern = (PsiDeconstructionPattern)deconstructionList.getParent();
            PsiType patternType = deconstructionPattern.getTypeElement().getType();
            if (patternType instanceof PsiClassType) {
                patternType = PsiUtil.captureToplevelWildcards(patternType, pattern);
                PsiSubstitutor substitutor2 = ((PsiClassType)patternType).resolveGenerics().getSubstitutor();
                PsiType recordComponentType = recordComponent.getType();
                return JavaVarTypeUtil.getUpwardProjection(substitutor2.substitute(recordComponentType));
            }
        }
        return null;
    }

    private static void collectPatternVariableCandidates(@NotNull PsiExpression scope2, @NotNull PsiExpression expression2, Collection<PatternVariableWrapper> candidates, boolean strict) {
        PsiPolyadicExpression polyadicExpression;
        IElementType tokenType;
        PsiPrimaryPattern pattern;
        if (scope2 == null) {
            JavaPsiPatternUtil.$$$reportNull$$$0(18);
        }
        if (expression2 == null) {
            JavaPsiPatternUtil.$$$reportNull$$$0(19);
        }
        while (true) {
            if (expression2 instanceof PsiParenthesizedExpression) {
                expression2 = ((PsiParenthesizedExpression)expression2).getExpression();
                continue;
            }
            if (!(expression2 instanceof PsiPrefixExpression) || !((PsiPrefixExpression)expression2).getOperationTokenType().equals(JavaTokenType.EXCL)) break;
            expression2 = ((PsiPrefixExpression)expression2).getOperand();
        }
        if (expression2 instanceof PsiInstanceOfExpression && ((pattern = ((PsiInstanceOfExpression)expression2).getPattern()) instanceof PsiTypeTestPattern || pattern instanceof PsiDeconstructionPattern)) {
            JavaPsiPatternUtil.collectPatternVariableCandidates(pattern, scope2, null, candidates, strict);
        }
        if (expression2 instanceof PsiPolyadicExpression && ((tokenType = (polyadicExpression = (PsiPolyadicExpression)expression2).getOperationTokenType()).equals(JavaTokenType.ANDAND) || tokenType.equals(JavaTokenType.OROR))) {
            for (PsiExpression operand : polyadicExpression.getOperands()) {
                JavaPsiPatternUtil.collectPatternVariableCandidates(scope2, operand, candidates, strict);
            }
        }
    }

    private static void collectPatternVariableCandidates(@NotNull PsiPattern pattern, @NotNull PsiExpression scope2, @Nullable Pair<PsiPatternVariable, PsiRecordComponent> parent2, Collection<PatternVariableWrapper> candidates, boolean strict) {
        if (pattern == null) {
            JavaPsiPatternUtil.$$$reportNull$$$0(20);
        }
        if (scope2 == null) {
            JavaPsiPatternUtil.$$$reportNull$$$0(21);
        }
        if (pattern instanceof PsiTypeTestPattern) {
            PsiPatternVariable variable = ((PsiTypeTestPattern)pattern).getPatternVariable();
            if (variable != null && !PsiTreeUtil.isAncestor(scope2, variable.getDeclarationScope(), strict)) {
                if (parent2 == null) {
                    candidates.add(new PatternVariableWrapper(variable, false));
                } else {
                    candidates.add(new DestructionComponent(variable, parent2.getFirst(), parent2.getSecond(), false));
                }
            }
        } else if (pattern instanceof PsiDeconstructionPattern) {
            PsiPattern[] components;
            PsiRecordComponent[] recordComponents;
            boolean isFake;
            PsiDeconstructionPattern deconstruction = (PsiDeconstructionPattern)pattern;
            PsiTypeElement typeElement = deconstruction.getTypeElement();
            PsiType type2 = typeElement.getType();
            PsiClass aClass = PsiUtil.resolveClassInClassTypeOnly(type2);
            PsiPatternVariable variable = deconstruction.getPatternVariable();
            boolean bl = isFake = variable == null;
            if (aClass != null && (recordComponents = aClass.getRecordComponents()).length == (components = deconstruction.getDeconstructionList().getDeconstructionComponents()).length && recordComponents.length != 0) {
                if (isFake) {
                    variable = JavaPsiPatternUtil.createFakePatternVariable(pattern, typeElement, type2);
                }
                PatternVariableWrapper patternVariableWrapper = parent2 == null ? new PatternVariableWrapper(variable, isFake) : new DestructionComponent(variable, parent2.getFirst(), parent2.getSecond(), isFake);
                candidates.add(patternVariableWrapper);
                for (int i = 0; i < components.length; ++i) {
                    JavaPsiPatternUtil.collectPatternVariableCandidates(components[i], scope2, Pair.pair(variable, recordComponents[i]), candidates, strict);
                }
            }
        }
    }

    @NotNull
    private static PsiPatternVariable createFakePatternVariable(@NotNull PsiPattern pattern, @NotNull PsiTypeElement typeElement, @NotNull PsiType type2) {
        if (pattern == null) {
            JavaPsiPatternUtil.$$$reportNull$$$0(22);
        }
        if (typeElement == null) {
            JavaPsiPatternUtil.$$$reportNull$$$0(23);
        }
        if (type2 == null) {
            JavaPsiPatternUtil.$$$reportNull$$$0(24);
        }
        Project project = pattern.getProject();
        PsiElementFactory factory = PsiElementFactory.getInstance(project);
        JavaCodeStyleManager styleManager = JavaCodeStyleManager.getInstance(project);
        String name2 = styleManager.suggestVariableName((VariableKind)VariableKind.PARAMETER, null, null, (PsiType)type2).names[0];
        name2 = styleManager.suggestUniqueVariableName(name2, (PsiElement)pattern, true);
        PsiElement parent2 = pattern.getParent();
        String operand = parent2 instanceof PsiInstanceOfExpression ? ((PsiInstanceOfExpression)parent2).getOperand().getText() : "x";
        String text = operand + " instanceof " + typeElement.getText() + " " + name2;
        PsiInstanceOfExpression instanceOf = (PsiInstanceOfExpression)factory.createExpressionFromText(text, null);
        PsiPatternVariable variable = ((PsiTypeTestPattern)Objects.requireNonNull(instanceOf.getPattern())).getPatternVariable();
        assert (variable != null);
        PsiPatternVariable psiPatternVariable = variable;
        if (psiPatternVariable == null) {
            JavaPsiPatternUtil.$$$reportNull$$$0(25);
        }
        return psiPatternVariable;
    }

    @Nullable
    public static PsiType getContextType(@NotNull PsiPattern pattern) {
        PsiDeconstructionPattern parentPattern;
        PsiExpression expression2;
        PsiSwitchBlock block;
        PsiSwitchLabelStatementBase label;
        if (pattern == null) {
            JavaPsiPatternUtil.$$$reportNull$$$0(26);
        }
        PsiElement parent2 = pattern.getParent();
        while (parent2 instanceof PsiParenthesizedPattern) {
            parent2 = parent2.getParent();
        }
        if (parent2 instanceof PsiInstanceOfExpression) {
            return ((PsiInstanceOfExpression)parent2).getOperand().getType();
        }
        if (parent2 instanceof PsiForeachPatternStatement) {
            PsiExpression iteratedValue = ((PsiForeachPatternStatement)parent2).getIteratedValue();
            if (iteratedValue == null) {
                return null;
            }
            return JavaGenericsUtil.getCollectionItemType(iteratedValue);
        }
        if (parent2 instanceof PsiCaseLabelElementList && (label = ObjectUtils.tryCast(parent2.getParent(), PsiSwitchLabelStatementBase.class)) != null && (block = label.getEnclosingSwitchBlock()) != null && (expression2 = block.getExpression()) != null) {
            return expression2.getType();
        }
        if (parent2 instanceof PsiDeconstructionList && (parentPattern = ObjectUtils.tryCast(parent2.getParent(), PsiDeconstructionPattern.class)) != null) {
            int index = ArrayUtil.indexOf(((PsiDeconstructionList)parent2).getDeconstructionComponents(), pattern);
            if (index < 0) {
                return null;
            }
            PsiType patternType = parentPattern.getTypeElement().getType();
            if (!(patternType instanceof PsiClassType)) {
                return null;
            }
            PsiSubstitutor parentSubstitutor = ((PsiClassType)patternType).resolveGenerics().getSubstitutor();
            PsiClass parentRecord = PsiUtil.resolveClassInClassTypeOnly(parentPattern.getTypeElement().getType());
            if (parentRecord == null) {
                return null;
            }
            PsiRecordComponent[] components = parentRecord.getRecordComponents();
            if (index >= components.length) {
                return null;
            }
            return parentSubstitutor.substitute(components[index].getType());
        }
        return null;
    }

    @Nullable
    private static Object evaluateConstant(@Nullable PsiExpression expression2) {
        if (expression2 == null) {
            return null;
        }
        return JavaPsiFacade.getInstance(expression2.getProject()).getConstantEvaluationHelper().computeConstantExpression(expression2, false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 25: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 25: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/util/JavaPsiPatternUtil";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 8: 
            case 11: 
            case 15: 
            case 17: 
            case 20: 
            case 22: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 9: 
            case 10: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "overWhom";
                break;
            }
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "who";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/util/JavaPsiPatternUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getExposedPatternVariables";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "collectPatternVariableWrappers";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getExposedPatternVariablesIgnoreParent";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "createFakePatternVariable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getExposedPatternVariables";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 25: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "collectPatternVariableWrappers";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getExposedPatternVariablesIgnoreParent";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getEffectiveInitializerText";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isGuarded";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isUnconditionalForType";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "hasUnconditionalComponents";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "dominates";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "dominatesComponents";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "dominatesOverConstant";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getRecordComponentForPattern";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getDeconstructedImplicitPatternVariableType";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getDeconstructedImplicitPatternType";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "collectPatternVariableCandidates";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "createFakePatternVariable";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getContextType";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 25: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    public static class PatternVariableWrapper {
        @NotNull
        private final PsiPatternVariable myVariable;
        private final boolean myIsFake;

        PatternVariableWrapper(@NotNull PsiPatternVariable variable, boolean isFake) {
            if (variable == null) {
                PatternVariableWrapper.$$$reportNull$$$0(0);
            }
            this.myVariable = variable;
            this.myIsFake = isFake;
        }

        @NotNull
        public PsiPatternVariable getVariable() {
            PsiPatternVariable psiPatternVariable = this.myVariable;
            if (psiPatternVariable == null) {
                PatternVariableWrapper.$$$reportNull$$$0(1);
            }
            return psiPatternVariable;
        }

        boolean isFake() {
            return this.myIsFake;
        }

        public String getEffectiveInitializerText() {
            return JavaPsiPatternUtil.getEffectiveInitializerText(this.myVariable);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variable";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/util/JavaPsiPatternUtil$PatternVariableWrapper";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/util/JavaPsiPatternUtil$PatternVariableWrapper";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVariable";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class DestructionComponent
    extends PatternVariableWrapper {
        @NotNull
        private final PsiPatternVariable myParent;
        @NotNull
        private final PsiRecordComponent myRecordComponent;

        DestructionComponent(@NotNull PsiPatternVariable variable, @NotNull PsiPatternVariable parent2, @NotNull PsiRecordComponent recordComponent, boolean isFake) {
            if (variable == null) {
                DestructionComponent.$$$reportNull$$$0(0);
            }
            if (parent2 == null) {
                DestructionComponent.$$$reportNull$$$0(1);
            }
            if (recordComponent == null) {
                DestructionComponent.$$$reportNull$$$0(2);
            }
            super(variable, isFake);
            this.myParent = parent2;
            this.myRecordComponent = recordComponent;
        }

        @Override
        public String getEffectiveInitializerText() {
            String text = this.myParent.getName() + "." + this.myRecordComponent.getName() + "()";
            PsiType type2 = this.getVariable().getType();
            if (!type2.equals(this.myRecordComponent.getType())) {
                return "(" + type2.getCanonicalText() + ")" + text;
            }
            return text;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "variable";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parent";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "recordComponent";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/kotlin/com/intellij/psi/util/JavaPsiPatternUtil$DestructionComponent";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

