/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.providers.ldap.authenticator;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceAware;
import org.springframework.context.support.MessageSourceAccessor;
import org.springframework.ldap.core.ContextSource;
import org.springframework.ldap.core.DirContextOperations;
import org.springframework.security.Authentication;
import org.springframework.security.SpringSecurityMessageSource;
import org.springframework.security.ldap.LdapUserSearch;
import org.springframework.security.providers.ldap.LdapAuthenticator;
import org.springframework.util.Assert;

public abstract class AbstractLdapAuthenticator
implements LdapAuthenticator,
InitializingBean,
MessageSourceAware {
    private ContextSource contextSource;
    private LdapUserSearch userSearch;
    protected MessageSourceAccessor messages = SpringSecurityMessageSource.getAccessor();
    private String[] userAttributes = null;
    private MessageFormat[] userDnFormat = null;

    public AbstractLdapAuthenticator(ContextSource contextSource) {
        Assert.notNull((Object)contextSource, (String)"contextSource must not be null.");
        this.contextSource = contextSource;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.isTrue((this.userDnFormat != null || this.userSearch != null ? 1 : 0) != 0, (String)"Either an LdapUserSearch or DN pattern (or both) must be supplied.");
    }

    protected ContextSource getContextSource() {
        return this.contextSource;
    }

    public String[] getUserAttributes() {
        return this.userAttributes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List getUserDns(String username) {
        if (this.userDnFormat == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<String> userDns = new ArrayList<String>(this.userDnFormat.length);
        String[] args = new String[]{username};
        MessageFormat[] messageFormatArray = this.userDnFormat;
        synchronized (this.userDnFormat) {
            for (int i = 0; i < this.userDnFormat.length; ++i) {
                userDns.add(this.userDnFormat[i].format(args));
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return userDns;
        }
    }

    protected LdapUserSearch getUserSearch() {
        return this.userSearch;
    }

    public void setMessageSource(MessageSource messageSource) {
        Assert.notNull((Object)"Message source must not be null");
        this.messages = new MessageSourceAccessor(messageSource);
    }

    public void setUserAttributes(String[] userAttributes) {
        Assert.notNull((Object)userAttributes, (String)"The userAttributes property cannot be set to null");
        this.userAttributes = userAttributes;
    }

    public void setUserDnPatterns(String[] dnPattern) {
        Assert.notNull((Object)dnPattern, (String)"The array of DN patterns cannot be set to null");
        this.userDnFormat = new MessageFormat[dnPattern.length];
        for (int i = 0; i < dnPattern.length; ++i) {
            this.userDnFormat[i] = new MessageFormat(dnPattern[i]);
        }
    }

    public void setUserSearch(LdapUserSearch userSearch) {
        Assert.notNull((Object)userSearch, (String)"The userSearch cannot be set to null");
        this.userSearch = userSearch;
    }

    public abstract /* synthetic */ DirContextOperations authenticate(Authentication var1);
}

