/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devtools.project.state;

import io.quarkus.bootstrap.workspace.WorkspaceModuleId;
import io.quarkus.devtools.project.state.ExtensionProvider;
import io.quarkus.devtools.project.state.ModuleState;
import io.quarkus.devtools.project.state.TopExtensionDependency;
import io.quarkus.maven.dependency.ArtifactCoords;
import io.quarkus.maven.dependency.ArtifactKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ProjectState {
    private final List<ArtifactCoords> importedPlatformBoms = new ArrayList<ArtifactCoords>();
    private final Map<ArtifactKey, TopExtensionDependency> topExtensions = new LinkedHashMap<ArtifactKey, TopExtensionDependency>();
    private ModuleState mainModule;
    private final Map<WorkspaceModuleId, ModuleState> modules = new LinkedHashMap<WorkspaceModuleId, ModuleState>();
    private final Map<String, ExtensionProvider> providers = new LinkedHashMap<String, ExtensionProvider>();

    public static Builder builder() {
        return new ProjectState().new Builder();
    }

    public Collection<ArtifactCoords> getPlatformBoms() {
        return this.importedPlatformBoms;
    }

    public Collection<TopExtensionDependency> getExtensions() {
        return this.topExtensions.values();
    }

    public TopExtensionDependency getExtension(ArtifactKey key) {
        return this.topExtensions.get(key);
    }

    public Collection<ModuleState> getModules() {
        return this.modules.values();
    }

    public ModuleState getMainModule() {
        return this.mainModule;
    }

    public ModuleState getModule(WorkspaceModuleId id) {
        return this.modules.get(id);
    }

    public Collection<ExtensionProvider> getExtensionProviders() {
        return this.providers.values();
    }

    public class Builder {
        private Builder() {
        }

        public Builder addPlatformBom(ArtifactCoords coords) {
            ProjectState.this.importedPlatformBoms.add(coords);
            return this;
        }

        public Builder addExtensionDependency(TopExtensionDependency dep) {
            ProjectState.this.topExtensions.put(dep.getKey(), dep);
            return this;
        }

        public Builder addModule(ModuleState state) {
            ProjectState.this.modules.put(state.getId(), state);
            if (state.isMain()) {
                ProjectState.this.mainModule = state;
            }
            return this;
        }

        public Builder addExtensionProvider(ExtensionProvider provider) {
            ProjectState.this.providers.put(provider.getKey(), provider);
            return this;
        }

        public ProjectState build() {
            return ProjectState.this;
        }
    }
}

