/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.pdf.BadPdfFormatException;
import com.lowagie.text.pdf.ByteBuffer;
import com.lowagie.text.pdf.PRIndirectReference;
import com.lowagie.text.pdf.PRStream;
import com.lowagie.text.pdf.PdfCopy;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfReader;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashMap;

public class PdfSmartCopy
extends PdfCopy {
    private HashMap streamMap = new HashMap();

    public PdfSmartCopy(Document document, OutputStream outputStream) throws DocumentException {
        super(document, outputStream);
    }

    protected PdfIndirectReference copyIndirect(PRIndirectReference pRIndirectReference) throws IOException, BadPdfFormatException {
        PdfCopy.RefKey refKey;
        PdfCopy.IndirectReferences indirectReferences;
        PdfIndirectReference pdfIndirectReference;
        PdfObject pdfObject = PdfReader.getPdfObjectRelease(pRIndirectReference);
        ByteStore byteStore = null;
        boolean bl = false;
        if (pdfObject.isStream() && !((PRStream)pdfObject).contains(PdfName.BBOX)) {
            bl = true;
            byteStore = new ByteStore((PRStream)pdfObject);
            pdfIndirectReference = (PdfIndirectReference)this.streamMap.get(byteStore);
            if (pdfIndirectReference != null) {
                return pdfIndirectReference;
            }
        }
        if ((indirectReferences = (PdfCopy.IndirectReferences)this.indirects.get(refKey = new PdfCopy.RefKey(pRIndirectReference))) != null) {
            pdfIndirectReference = indirectReferences.getRef();
            if (indirectReferences.getCopied()) {
                return pdfIndirectReference;
            }
        } else {
            pdfIndirectReference = this.body.getPdfIndirectReference();
            indirectReferences = new PdfCopy.IndirectReferences(pdfIndirectReference);
            this.indirects.put(refKey, indirectReferences);
        }
        indirectReferences.setCopied();
        if (bl) {
            this.streamMap.put(byteStore, pdfIndirectReference);
        }
        PdfObject pdfObject2 = this.copyObject(pdfObject);
        this.addToBody(pdfObject2, pdfIndirectReference);
        return pdfIndirectReference;
    }

    static class ByteStore {
        private byte[] b;
        private int hash;

        ByteStore(PRStream pRStream) throws IOException {
            byte[] byArray = PdfReader.getStreamBytesRaw(pRStream);
            Object[] objectArray = pRStream.getKeys().toArray();
            Arrays.sort(objectArray);
            ByteBuffer byteBuffer = new ByteBuffer();
            for (int i = 0; i < objectArray.length; ++i) {
                byteBuffer.append(objectArray[i].toString());
            }
            byteBuffer.append(byArray);
            this.b = byteBuffer.toByteArray();
        }

        public boolean equals(Object object) {
            if (!(object instanceof ByteStore)) {
                return false;
            }
            if (this.hashCode() != object.hashCode()) {
                return false;
            }
            return Arrays.equals(this.b, ((ByteStore)object).b);
        }

        public int hashCode() {
            if (this.hash == 0) {
                int n = this.b.length;
                for (int i = 0; i < n; ++i) {
                    this.hash = this.hash * 31 + (this.b[i] & 0xFF);
                }
            }
            return this.hash;
        }
    }
}

