/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import org.armedbear.lisp.Debug;

public class HttpHead {
    public static String get(String urlString, String key) throws IOException {
        URL url = null;
        try {
            url = new URL(urlString);
        }
        catch (MalformedURLException e) {
            HttpHead.log("Failed to form url from '" + urlString + "': " + String.valueOf(e));
        }
        return HttpHead.get(url, key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String get(URL url, String key) throws IOException {
        Socket socket = null;
        String result = null;
        try {
            String protocol = url.getProtocol();
            if (!protocol.equals("http")) {
                HttpHead.log("The protocol '" + protocol + "' is not http.");
                String string = result;
                return string;
            }
            String host = url.getHost();
            int port = url.getPort();
            if (port == -1) {
                port = 80;
            }
            socket = new Socket(host, port);
            PrintWriter out = null;
            BufferedReader in = null;
            try {
                socket.setSoTimeout(5000);
                out = new PrintWriter((Writer)new OutputStreamWriter(socket.getOutputStream()), true);
                in = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            }
            catch (IOException e) {
                HttpHead.log("Failed to establish socket io: " + String.valueOf(e));
                String string = result;
                try {
                    socket.close();
                    return string;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return string;
            }
            String CRLF = "\r\n";
            String head = "HEAD " + url.getPath() + " HTTP/1.1";
            out.print(head + CRLF);
            out.print("Host: " + url.getAuthority() + CRLF);
            out.print("Connection: close" + CRLF);
            out.print(CRLF);
            out.flush();
            String line = null;
            try {
                line = in.readLine();
            }
            catch (IOException e) {
                HttpHead.log("Failed to read HTTP response: " + String.valueOf(e));
            }
            if (line == null) {
                throw new IOException("Could not access URL to parse headers.");
            }
            String[] status = line.split("\\s");
            if (status[1].equals("200")) {
                result = HttpHead.findHeader(in, key);
                return result;
            }
            if (status[1].startsWith("3")) {
                String location = HttpHead.findHeader(in, "Location");
                if (location == null) return result;
                String string = HttpHead.get(location, key);
                return string;
            }
            HttpHead.log("Unexpected response: " + line);
            return result;
        }
        finally {
            try {
                socket.close();
            }
            catch (IOException iOException) {}
        }
    }

    private static String findHeader(BufferedReader in, String key) {
        String result = null;
        try {
            String line;
            while ((line = in.readLine()) != null) {
                int i = line.indexOf(":");
                if (i == -1) continue;
                String k = line.substring(0, i);
                String v = line.substring(i + 1).trim();
                if (!k.equals(key)) continue;
                result = v;
                break;
            }
        }
        catch (IOException e) {
            HttpHead.log("Failed to read headers: " + String.valueOf(e));
        }
        return result;
    }

    private static void log(String message) {
        Debug.warn(message);
    }

    public static void main(String[] argv) {
        if (argv.length != 1) {
            System.out.println("Usage: <cmd> URL");
            return;
        }
        String modified = null;
        try {
            modified = HttpHead.get(argv[0], "Last-Modified");
        }
        catch (IOException ex) {
            System.err.println("Unable to get Last-Modified header: ");
            ex.printStackTrace(System.err);
        }
        if (modified != null) {
            System.out.println("Last-Modified: " + modified);
        } else {
            System.out.println("No result returned.");
        }
    }
}

