/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.HsqlNameManager;
import org.hsqldb.NumberSequence;
import org.hsqldb.ReferenceObject;
import org.hsqldb.Routine;
import org.hsqldb.RoutineSchema;
import org.hsqldb.SchemaObject;
import org.hsqldb.SchemaObjectSet;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.error.Error;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.OrderedHashMap;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.lib.StringConverter;
import org.hsqldb.lib.WrapperIterator;
import org.hsqldb.rights.Grantee;

public final class Schema
implements SchemaObject {
    static int[] scriptSequenceOne = new int[]{14, 15, 12, 7, 16};
    static int[] scriptSequenceTwo = new int[]{3, 17, 8, 29, 31};
    private HsqlNameManager.HsqlName name;
    SchemaObjectSet triggerLookup;
    SchemaObjectSet constraintLookup;
    SchemaObjectSet indexLookup;
    SchemaObjectSet tableLookup;
    SchemaObjectSet sequenceLookup;
    SchemaObjectSet typeLookup;
    SchemaObjectSet charsetLookup;
    SchemaObjectSet collationLookup;
    SchemaObjectSet procedureLookup;
    SchemaObjectSet functionLookup;
    SchemaObjectSet specificRoutineLookup;
    SchemaObjectSet assertionLookup;
    SchemaObjectSet referenceLookup;
    SchemaObjectSet conditionLookup;
    SchemaObjectSet moduleLookup;
    OrderedHashMap tableList;
    OrderedHashMap sequenceList;
    OrderedHashMap referenceList;
    long changeTimestamp;

    public Schema(HsqlNameManager.HsqlName hsqlName, Grantee grantee) {
        this.name = hsqlName;
        this.triggerLookup = new SchemaObjectSet(8);
        this.indexLookup = new SchemaObjectSet(20);
        this.constraintLookup = new SchemaObjectSet(5);
        this.tableLookup = new SchemaObjectSet(3);
        this.sequenceLookup = new SchemaObjectSet(7);
        this.typeLookup = new SchemaObjectSet(12);
        this.charsetLookup = new SchemaObjectSet(14);
        this.collationLookup = new SchemaObjectSet(15);
        this.procedureLookup = new SchemaObjectSet(17);
        this.functionLookup = new SchemaObjectSet(16);
        this.specificRoutineLookup = new SchemaObjectSet(24);
        this.assertionLookup = new SchemaObjectSet(6);
        this.referenceLookup = new SchemaObjectSet(29);
        this.conditionLookup = new SchemaObjectSet(32);
        this.moduleLookup = new SchemaObjectSet(31);
        this.tableList = (OrderedHashMap)this.tableLookup.map;
        this.sequenceList = (OrderedHashMap)this.sequenceLookup.map;
        this.referenceList = (OrderedHashMap)this.referenceLookup.map;
        hsqlName.owner = grantee;
    }

    @Override
    public int getType() {
        return 2;
    }

    @Override
    public HsqlNameManager.HsqlName getName() {
        return this.name;
    }

    @Override
    public HsqlNameManager.HsqlName getSchemaName() {
        return null;
    }

    @Override
    public HsqlNameManager.HsqlName getCatalogName() {
        return this.name.schema;
    }

    @Override
    public Grantee getOwner() {
        return this.name.owner;
    }

    @Override
    public OrderedHashSet getReferences() {
        return new OrderedHashSet();
    }

    @Override
    public OrderedHashSet getComponents() {
        return null;
    }

    @Override
    public void compile(Session session, SchemaObject schemaObject) {
    }

    @Override
    public long getChangeTimestamp() {
        return this.changeTimestamp;
    }

    @Override
    public String getSQL() {
        StringBuilder stringBuilder = new StringBuilder(128);
        stringBuilder.append("CREATE").append(' ');
        stringBuilder.append("SCHEMA").append(' ');
        stringBuilder.append(this.getName().statementName).append(' ');
        stringBuilder.append("AUTHORIZATION").append(' ');
        stringBuilder.append(this.getOwner().getName().getStatementName());
        return stringBuilder.toString();
    }

    String getSetSchemaSQL() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("SET").append(' ');
        stringBuilder.append("SCHEMA").append(' ');
        stringBuilder.append(this.name.statementName);
        return stringBuilder.toString();
    }

    static String getCommentSQL(HsqlNameManager.HsqlName hsqlName, String string) {
        if (hsqlName.comment == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("COMMENT").append(' ').append("ON");
        stringBuilder.append(' ').append(string).append(' ');
        stringBuilder.append(hsqlName.getSchemaQualifiedStatementName());
        stringBuilder.append(' ').append("IS").append(' ');
        stringBuilder.append(StringConverter.toQuotedString(hsqlName.comment, '\'', true));
        return stringBuilder.toString();
    }

    public HsqlArrayList getSQLArray(int n, OrderedHashSet orderedHashSet, OrderedHashSet orderedHashSet2) {
        HsqlArrayList hsqlArrayList = new HsqlArrayList();
        switch (n) {
            case 14: {
                this.charsetLookup.getSQL(hsqlArrayList, orderedHashSet, orderedHashSet2);
                break;
            }
            case 15: {
                this.collationLookup.getSQL(hsqlArrayList, orderedHashSet, orderedHashSet2);
                break;
            }
            case 12: {
                this.typeLookup.getSQL(hsqlArrayList, orderedHashSet, orderedHashSet2);
                break;
            }
            case 7: {
                this.sequenceLookup.getSQL(hsqlArrayList, orderedHashSet, orderedHashSet2);
                break;
            }
            case 16: {
                this.functionLookup.getSQL(hsqlArrayList, orderedHashSet, orderedHashSet2);
                break;
            }
            case 3: {
                this.tableLookup.getSQL(hsqlArrayList, orderedHashSet, orderedHashSet2);
                break;
            }
            case 17: {
                this.procedureLookup.getSQL(hsqlArrayList, orderedHashSet, orderedHashSet2);
                break;
            }
            case 29: {
                this.referenceLookup.getSQL(hsqlArrayList, orderedHashSet, orderedHashSet2);
            }
        }
        return hsqlArrayList;
    }

    public HsqlArrayList getSequenceRestartSQL() {
        HsqlArrayList<String> hsqlArrayList = new HsqlArrayList<String>();
        Iterator iterator = this.sequenceLookup.map.values().iterator();
        while (iterator.hasNext()) {
            NumberSequence numberSequence = (NumberSequence)iterator.next();
            String string = numberSequence.getRestartSQL();
            hsqlArrayList.add(string);
        }
        return hsqlArrayList;
    }

    public HsqlArrayList getTriggerSQL() {
        HsqlArrayList hsqlArrayList = new HsqlArrayList();
        Iterator iterator = this.tableLookup.map.values().iterator();
        while (iterator.hasNext()) {
            Table table = (Table)iterator.next();
            Object[] objectArray = table.getTriggerSQL();
            hsqlArrayList.addAll(objectArray);
        }
        return hsqlArrayList;
    }

    boolean isEmpty() {
        return this.sequenceLookup.isEmpty() && this.tableLookup.isEmpty() && this.typeLookup.isEmpty() && this.charsetLookup.isEmpty() && this.collationLookup.isEmpty() && this.specificRoutineLookup.isEmpty();
    }

    public SchemaObjectSet getObjectSet(int n) {
        switch (n) {
            case 7: {
                return this.sequenceLookup;
            }
            case 3: 
            case 4: {
                return this.tableLookup;
            }
            case 14: {
                return this.charsetLookup;
            }
            case 15: {
                return this.collationLookup;
            }
            case 17: {
                return this.procedureLookup;
            }
            case 16: {
                return this.functionLookup;
            }
            case 18: {
                return this.functionLookup;
            }
            case 24: {
                return this.specificRoutineLookup;
            }
            case 12: 
            case 13: {
                return this.typeLookup;
            }
            case 6: {
                return this.assertionLookup;
            }
            case 8: {
                return this.triggerLookup;
            }
            case 32: {
                return this.conditionLookup;
            }
            case 31: {
                return this.moduleLookup;
            }
            case 29: {
                return this.referenceLookup;
            }
            case 20: {
                return this.indexLookup;
            }
            case 5: {
                return this.constraintLookup;
            }
        }
        throw Error.runtimeError(201, "Schema");
    }

    public Iterator schemaObjectIterator(int n) {
        switch (n) {
            case 7: {
                return this.sequenceLookup.map.values().iterator();
            }
            case 3: 
            case 4: {
                return this.tableLookup.map.values().iterator();
            }
            case 14: {
                return this.charsetLookup.map.values().iterator();
            }
            case 15: {
                return this.collationLookup.map.values().iterator();
            }
            case 17: {
                return this.procedureLookup.map.values().iterator();
            }
            case 16: {
                return this.functionLookup.map.values().iterator();
            }
            case 18: {
                Iterator iterator = this.functionLookup.map.values().iterator();
                return new WrapperIterator(iterator, this.procedureLookup.map.values().iterator());
            }
            case 24: {
                return this.specificRoutineLookup.map.values().iterator();
            }
            case 12: 
            case 13: {
                return this.typeLookup.map.values().iterator();
            }
            case 6: {
                return this.assertionLookup.map.values().iterator();
            }
            case 32: {
                return this.conditionLookup.map.values().iterator();
            }
            case 31: {
                return this.moduleLookup.map.values().iterator();
            }
            case 8: {
                return this.triggerLookup.map.values().iterator();
            }
            case 29: {
                return this.referenceLookup.map.values().iterator();
            }
            case 20: {
                return this.indexLookup.map.values().iterator();
            }
            case 5: {
                return this.constraintLookup.map.values().iterator();
            }
        }
        throw Error.runtimeError(201, "Schema");
    }

    SchemaObject findAnySchemaObjectForSynonym(String string) {
        int[] nArray = new int[]{7, 3, 18};
        for (int i = 0; i < nArray.length; ++i) {
            SchemaObject schemaObject = this.findSchemaObject(string, nArray[i]);
            if (schemaObject == null) continue;
            return schemaObject;
        }
        return null;
    }

    ReferenceObject findReference(String string, int n) {
        ReferenceObject referenceObject = (ReferenceObject)this.referenceList.get(string);
        if (referenceObject == null) {
            return null;
        }
        int n2 = referenceObject.getTarget().type;
        if (n2 == n) {
            return referenceObject;
        }
        switch (n) {
            case 3: {
                if (n2 != 4) break;
                return referenceObject;
            }
            case 18: {
                if (n2 != 16 && n2 != 17) break;
                return referenceObject;
            }
        }
        return null;
    }

    SchemaObject findSchemaObject(String string, int n) {
        SchemaObjectSet schemaObjectSet = null;
        switch (n) {
            case 7: {
                return this.sequenceLookup.getObject(string);
            }
            case 3: 
            case 4: {
                return this.tableLookup.getObject(string);
            }
            case 14: {
                return this.charsetLookup.getObject(string);
            }
            case 15: {
                return this.collationLookup.getObject(string);
            }
            case 17: {
                return this.procedureLookup.getObject(string);
            }
            case 16: {
                return this.functionLookup.getObject(string);
            }
            case 18: {
                SchemaObject schemaObject = this.procedureLookup.getObject(string);
                if (schemaObject == null) {
                    schemaObject = this.functionLookup.getObject(string);
                }
                return schemaObject;
            }
            case 24: {
                return this.specificRoutineLookup.getObject(string);
            }
            case 32: {
                return this.conditionLookup.getObject(string);
            }
            case 31: {
                return this.moduleLookup.getObject(string);
            }
            case 12: 
            case 13: {
                return this.typeLookup.getObject(string);
            }
            case 20: {
                schemaObjectSet = this.indexLookup;
                HsqlNameManager.HsqlName hsqlName = schemaObjectSet.getName(string);
                if (hsqlName == null) {
                    return null;
                }
                Table table = (Table)this.tableList.get(hsqlName.parent.name);
                return table.getIndex(string);
            }
            case 5: {
                schemaObjectSet = this.constraintLookup;
                HsqlNameManager.HsqlName hsqlName = schemaObjectSet.getName(string);
                if (hsqlName == null) {
                    return null;
                }
                Table table = (Table)this.tableList.get(hsqlName.parent.name);
                if (table == null) {
                    return null;
                }
                return table.getConstraint(string);
            }
            case 8: {
                schemaObjectSet = this.triggerLookup;
                HsqlNameManager.HsqlName hsqlName = schemaObjectSet.getName(string);
                if (hsqlName == null) {
                    return null;
                }
                Table table = (Table)this.tableList.get(hsqlName.parent.name);
                return table.getTrigger(string);
            }
            case 29: {
                return this.referenceLookup.getObject(string);
            }
        }
        throw Error.runtimeError(201, "SchemaManager");
    }

    public void addSchemaObject(HsqlNameManager hsqlNameManager, SchemaObject schemaObject, boolean bl) {
        HsqlNameManager.HsqlName hsqlName = schemaObject.getName();
        SchemaObjectSet schemaObjectSet = this.getObjectSet(hsqlName.type);
        switch (hsqlName.type) {
            case 16: 
            case 17: {
                RoutineSchema routineSchema = (RoutineSchema)schemaObjectSet.getObject(hsqlName.name);
                if (routineSchema == null) {
                    routineSchema = new RoutineSchema(hsqlName.type, hsqlName);
                    routineSchema.addSpecificRoutine(hsqlNameManager, (Routine)schemaObject, bl);
                    schemaObjectSet.checkAdd(hsqlName);
                    SchemaObjectSet schemaObjectSet2 = this.getObjectSet(24);
                    schemaObjectSet2.checkAdd(((Routine)schemaObject).getSpecificName());
                    schemaObjectSet.add(routineSchema, bl);
                    schemaObjectSet2.add(schemaObject, bl);
                } else {
                    SchemaObjectSet schemaObjectSet3 = this.getObjectSet(24);
                    HsqlNameManager.HsqlName hsqlName2 = ((Routine)schemaObject).getSpecificName();
                    if (hsqlName2 != null) {
                        schemaObjectSet3.checkAdd(hsqlName2);
                    }
                    routineSchema.addSpecificRoutine(hsqlNameManager, (Routine)schemaObject, bl);
                    schemaObjectSet3.add(schemaObject, bl);
                }
                return;
            }
        }
        schemaObjectSet.add(schemaObject, bl);
    }

    void release() {
        for (int i = 0; i < this.tableList.size(); ++i) {
            Table table = (Table)this.tableList.get(i);
            table.terminateTriggers();
        }
        this.triggerLookup = null;
        this.indexLookup = null;
        this.constraintLookup = null;
        this.charsetLookup = null;
        this.collationLookup = null;
        this.procedureLookup = null;
        this.functionLookup = null;
        this.specificRoutineLookup = null;
        this.conditionLookup = null;
        this.moduleLookup = null;
        this.sequenceLookup = null;
        this.tableLookup = null;
        this.typeLookup = null;
        this.tableList.clear();
        this.sequenceList.clear();
        this.referenceList.clear();
    }
}

