/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.util.BitSet;
import java.util.Date;
import java.util.LinkedList;
import org.traccar.BaseProtocolDecoder;
import org.traccar.Protocol;
import org.traccar.helper.BitUtil;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.Position;
import org.traccar.session.DeviceSession;

public class RadarProtocolDecoder
extends BaseProtocolDecoder {
    public static final int MSG_TRACKING = 76;

    public RadarProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        ByteBuf buf = (ByteBuf)msg;
        buf.readUnsignedByte();
        buf.readUnsignedByte();
        String serialNumber = String.valueOf(buf.readUnsignedInt());
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, serialNumber);
        if (deviceSession == null) {
            return null;
        }
        buf.readUnsignedByte();
        buf.readUnsignedInt();
        short type = buf.readUnsignedByte();
        buf.readUnsignedShort();
        if (type == 76) {
            buf.readUnsignedShort();
            buf.readUnsignedShort();
            int count = buf.readUnsignedShort();
            buf.readUnsignedShort();
            LinkedList<Position> positions = new LinkedList<Position>();
            for (int index = 0; index < count; ++index) {
                int i;
                int flags;
                Position position = new Position(this.getProtocolName());
                position.setDeviceId(deviceSession.getDeviceId());
                position.set("event", buf.readUnsignedShort());
                short maskLength = buf.readUnsignedByte();
                BitSet mask = BitSet.valueOf(buf.nioBuffer(buf.readerIndex(), (int)maskLength));
                buf.skipBytes((int)maskLength);
                buf.readUnsignedShort();
                if (mask.get(0)) {
                    position.setDeviceTime(new Date(buf.readUnsignedInt() * 1000L));
                }
                if (mask.get(1)) {
                    position.setFixTime(new Date(buf.readUnsignedInt() * 1000L));
                }
                if (mask.get(2)) {
                    position.setLatitude((double)buf.readInt() / 360000.0);
                }
                if (mask.get(3)) {
                    position.setLongitude((double)buf.readInt() / 360000.0);
                }
                if (mask.get(4)) {
                    position.setSpeed(UnitsConverter.knotsFromKph(buf.readUnsignedShort()));
                }
                if (mask.get(5)) {
                    position.setCourse((double)buf.readUnsignedShort() * 0.1);
                }
                if (mask.get(6)) {
                    position.setAltitude(buf.readShort());
                }
                if (mask.get(7)) {
                    flags = buf.readUnsignedByte();
                    position.setValid(BitUtil.check(flags, 0));
                    position.set("sat", BitUtil.from(flags, 4));
                }
                if (mask.get(8)) {
                    long flags2 = buf.readUnsignedInt();
                    position.set("ignition", BitUtil.check(flags2, 0));
                    position.set("charge", BitUtil.check(flags2, 1));
                    position.set("motion", BitUtil.check(flags2, 2));
                    for (int i2 = 0; i2 < 3; ++i2) {
                        position.set("in" + i2, BitUtil.check(flags2, 4 + i2));
                    }
                }
                if (mask.get(9)) {
                    flags = buf.readUnsignedShort();
                    position.set("blocked", BitUtil.check(flags, 0));
                    position.set("in0", BitUtil.check(flags, 4));
                }
                for (i = 10; i <= 14; ++i) {
                    if (!mask.get(i)) continue;
                    buf.readUnsignedShort();
                }
                if (mask.get(15)) {
                    position.set("odometer", buf.readUnsignedInt() * 100L);
                }
                if (mask.get(16)) {
                    buf.readUnsignedInt();
                }
                for (i = 17; i <= 27; ++i) {
                    if (!mask.get(i)) continue;
                    buf.readUnsignedByte();
                }
                for (i = 28; i <= 37; i += 2) {
                    if (mask.get(i)) {
                        buf.skipBytes(12);
                    }
                    if (!mask.get(i + 1)) continue;
                    buf.readUnsignedByte();
                }
                if (mask.get(38)) {
                    buf.skipBytes(6);
                }
                if (mask.get(39)) {
                    buf.readUnsignedShort();
                }
                if (mask.get(40)) {
                    buf.readShort();
                }
                if (mask.get(41)) {
                    buf.readShort();
                }
                if (mask.get(42)) {
                    buf.readShort();
                }
                if (mask.get(43)) {
                    buf.skipBytes(10);
                }
                if (mask.get(44)) {
                    buf.readUnsignedShort();
                }
                for (i = 45; i <= 49; ++i) {
                    if (!mask.get(i)) continue;
                    buf.readUnsignedByte();
                }
                if (mask.get(50)) {
                    buf.readShort();
                }
                if (mask.get(51)) {
                    buf.readUnsignedInt();
                }
                if (mask.get(52)) {
                    buf.readUnsignedInt();
                }
                if (position.getDeviceTime() == null || position.getFixTime() == null) continue;
                positions.add(position);
            }
            return positions.isEmpty() ? null : positions;
        }
        return null;
    }
}

