/*
 * Decompiled with CFR 0.152.
 */
package liquibase.parser.core.sql;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Optional;
import liquibase.Scope;
import liquibase.change.core.RawSQLChange;
import liquibase.changelog.ChangeLogHistoryServiceFactory;
import liquibase.changelog.ChangeLogParameters;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.changelog.RanChangeSet;
import liquibase.changeset.ChangeSetService;
import liquibase.changeset.ChangeSetServiceFactory;
import liquibase.database.Database;
import liquibase.database.ObjectQuotingStrategy;
import liquibase.exception.ChangeLogParseException;
import liquibase.exception.LiquibaseException;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.parser.ChangeLogParser;
import liquibase.resource.Resource;
import liquibase.resource.ResourceAccessor;
import liquibase.snapshot.SnapshotControl;
import liquibase.snapshot.SnapshotGeneratorFactory;
import liquibase.structure.core.Column;
import liquibase.structure.core.Table;
import liquibase.util.ExceptionUtil;
import liquibase.util.StreamUtil;
import org.apache.commons.lang3.StringUtils;

public class SqlChangeLogParser
implements ChangeLogParser {
    @Override
    public boolean supports(String changeLogFile, ResourceAccessor resourceAccessor) {
        return changeLogFile.toLowerCase().endsWith(".sql");
    }

    @Override
    public int getPriority() {
        return 1;
    }

    @Override
    public DatabaseChangeLog parse(String physicalChangeLogLocation, ChangeLogParameters changeLogParameters, ResourceAccessor resourceAccessor) throws ChangeLogParseException {
        DatabaseChangeLog changeLog = new DatabaseChangeLog();
        changeLog.setPhysicalFilePath(physicalChangeLogLocation);
        RawSQLChange change = new RawSQLChange();
        try {
            Resource sqlResource = resourceAccessor.getExisting(physicalChangeLogLocation);
            String sql = StreamUtil.readStreamAsString(sqlResource.openInputStream());
            if (StringUtils.isEmpty((CharSequence)sql)) {
                String message = String.format("Unable to parse empty file: '%s'", physicalChangeLogLocation);
                Scope.getCurrentScope().getLog(this.getClass()).warning(message);
                throw new ChangeLogParseException(message);
            }
            change.setSql(sql);
        }
        catch (IOException e) {
            throw new ChangeLogParseException(e);
        }
        change.setSplitStatements(false);
        change.setStripComments(false, true);
        Database database = Scope.getCurrentScope().getDatabase();
        ChangeSetServiceFactory factory = ChangeSetServiceFactory.getInstance();
        ChangeSetService service = factory.createChangeSetService();
        ChangeSet changeSet = service.createChangeSet(this.generateId(physicalChangeLogLocation, database), "includeAll", false, false, physicalChangeLogLocation, null, null, null, null, true, ObjectQuotingStrategy.LEGACY, changeLog);
        changeSet.addChange(change);
        changeLog.addChangeSet(changeSet);
        ExceptionUtil.doSilently(() -> Scope.getCurrentScope().getAnalyticsEvent().incrementSqlChangelogCount());
        return changeLog;
    }

    private String generateId(String physicalChangeLogLocation, Database database) {
        if (database == null || SqlChangeLogParser.isOldFormat(database)) {
            return "raw";
        }
        ArrayList<Object> ranChangeSets = new ArrayList();
        try {
            ranChangeSets = new ArrayList<RanChangeSet>(Scope.getCurrentScope().getSingleton(ChangeLogHistoryServiceFactory.class).getChangeLogService(database).getRanChangeSets());
        }
        catch (Exception dbe) {
            return "raw";
        }
        String interimId = "raw_" + DatabaseChangeLog.normalizePath(physicalChangeLogLocation).replace("/", "_");
        Optional<RanChangeSet> ranChangeSet = ranChangeSets.stream().filter(rc -> rc.getId().equals(interimId) && rc.getAuthor().equals("includeAll") && rc.getChangeLog().equals(physicalChangeLogLocation)).findFirst();
        if (ranChangeSet.isPresent()) {
            return interimId;
        }
        return "raw";
    }

    private static boolean isOldFormat(Database database) {
        Table changeLogTable = null;
        try {
            changeLogTable = SnapshotGeneratorFactory.getInstance().getDatabaseChangeLogTable(new SnapshotControl(database, false, Table.class, Column.class), database);
        }
        catch (LiquibaseException e) {
            throw new UnexpectedLiquibaseException(e);
        }
        return changeLogTable != null && changeLogTable.getColumn("ORDEREXECUTED") == null;
    }
}

