/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.attributes.nodes;

import jadx.api.CommentsLevel;
import jadx.api.plugins.input.data.attributes.IJadxAttrType;
import jadx.api.plugins.input.data.attributes.IJadxAttribute;
import jadx.core.dex.attributes.AType;
import jadx.core.utils.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class JadxCommentsAttr
implements IJadxAttribute {
    private final Map<CommentsLevel, List<String>> comments = new EnumMap<CommentsLevel, List<String>>(CommentsLevel.class);

    public void add(CommentsLevel level, String comment) {
        this.comments.computeIfAbsent(level, l -> new ArrayList()).add(comment);
    }

    public List<String> formatAndFilter(CommentsLevel level) {
        if (level == CommentsLevel.NONE || level == CommentsLevel.USER_ONLY) {
            return Collections.emptyList();
        }
        return this.comments.entrySet().stream().filter(e -> ((CommentsLevel)((Object)((Object)e.getKey()))).filter(level)).flatMap(e -> {
            String levelName = ((CommentsLevel)((Object)((Object)e.getKey()))).name();
            return ((List)e.getValue()).stream().map(v -> "JADX " + levelName + ": " + v);
        }).distinct().sorted().collect(Collectors.toList());
    }

    public Map<CommentsLevel, List<String>> getComments() {
        return this.comments;
    }

    public IJadxAttrType<JadxCommentsAttr> getAttrType() {
        return AType.JADX_COMMENTS;
    }

    public String toString() {
        return "JadxCommentsAttr{\n " + Utils.listToString(this.comments.entrySet(), "\n ", e -> e.getKey() + ": \n -> " + Utils.listToString((Iterable)e.getValue(), "\n -> ")) + '}';
    }
}

