/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.io;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.function.Function;
import javax.annotation.Nullable;

@FunctionalInterface
public interface IoFunction<T, R> {
    @Nullable
    public R apply(@Nullable T var1) throws IOException;

    public static <T, R> Function<T, R> wrap(IoFunction<T, R> function) {
        return t -> {
            try {
                return function.apply(t);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        };
    }
}

