/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.universe.maven.repo;

import java.util.Collections;
import java.util.List;
import org.eclipse.aether.util.version.GenericVersionScheme;
import org.eclipse.aether.version.Version;
import org.jboss.galleon.universe.maven.MavenUniverseException;
import org.jboss.galleon.universe.maven.repo.MavenArtifactVersion;
import org.jboss.galleon.universe.maven.repo.MavenArtifactVersionRange;
import org.jboss.galleon.util.CollectionUtils;
import org.jboss.galleon.util.StringUtils;

public class MavenArtifactVersionRangeParser {
    private int i;

    public MavenArtifactVersionRange parseRange(String rangeStr) throws MavenUniverseException {
        this.i = 0;
        List<MavenArtifactVersionRange> ranges = null;
        block4: while (this.i < rangeStr.length()) {
            char ch = rangeStr.charAt(this.i++);
            switch (ch) {
                case '(': 
                case '[': {
                    MavenArtifactVersionRange range = this.parsedRangeStart(rangeStr, ch);
                    if (ranges != null) {
                        ranges = CollectionUtils.add(ranges, range);
                        continue block4;
                    }
                    if (this.i < rangeStr.length()) {
                        ranges = CollectionUtils.add(Collections.emptyList(), range);
                        continue block4;
                    }
                    return range;
                }
                case ',': {
                    continue block4;
                }
            }
            throw MavenArtifactVersionRangeParser.unexpectedChar(rangeStr, ch, this.i - 1);
        }
        if (ranges == null) {
            throw new MavenUniverseException("Could not determine parse any version range in '" + rangeStr + "'");
        }
        return new RangeCollection(ranges);
    }

    private MavenArtifactVersionRange parsedRangeStart(String rangeStr, char trigger) throws MavenUniverseException {
        int startIndex = this.i;
        while (this.i < rangeStr.length()) {
            char ch = rangeStr.charAt(this.i++);
            switch (ch) {
                case ',': {
                    MavenArtifactVersion boundVersion = this.i == startIndex + 1 ? null : new MavenArtifactVersion(rangeStr.substring(startIndex, this.i - 1));
                    return new SimpleVersionRange(new Bound(boundVersion, trigger != '('), this.parseBound(rangeStr));
                }
                case ')': {
                    if (trigger != '(') {
                        throw this.boundNotClosed(rangeStr, trigger, startIndex - 1, ')');
                    }
                    MavenArtifactVersion boundVersion = this.i == startIndex + 1 ? null : new MavenArtifactVersion(rangeStr.substring(startIndex, this.i - 1));
                    return new SingleVersionRange(boundVersion, false);
                }
                case ']': {
                    if (trigger != '[') {
                        throw this.boundNotClosed(rangeStr, trigger, startIndex - 1, ']');
                    }
                    MavenArtifactVersion boundVersion = this.i == startIndex + 1 ? null : new MavenArtifactVersion(rangeStr.substring(startIndex, this.i - 1));
                    return new SingleVersionRange(boundVersion, true);
                }
                case '(': 
                case '[': {
                    throw MavenArtifactVersionRangeParser.unexpectedChar(rangeStr, ch, this.i - 1);
                }
            }
        }
        throw this.rangeNotComplete(rangeStr, startIndex);
    }

    private Bound parseBound(String rangeStr) throws MavenUniverseException {
        int startIndex = this.i;
        while (this.i < rangeStr.length()) {
            char ch = rangeStr.charAt(this.i++);
            switch (ch) {
                case ')': {
                    MavenArtifactVersion boundVersion = this.i == startIndex + 1 ? null : new MavenArtifactVersion(rangeStr.substring(startIndex, this.i - 1));
                    return new Bound(boundVersion, false);
                }
                case ']': {
                    MavenArtifactVersion boundVersion = this.i == startIndex + 1 ? null : new MavenArtifactVersion(rangeStr.substring(startIndex, this.i - 1));
                    return new Bound(boundVersion, true);
                }
                case '(': 
                case ',': 
                case '[': {
                    throw MavenArtifactVersionRangeParser.unexpectedChar(rangeStr, ch, this.i - 1);
                }
            }
        }
        throw MavenArtifactVersionRangeParser.boundNotClosed(rangeStr, startIndex);
    }

    private MavenUniverseException rangeNotComplete(String rangeStr, int startIndex) {
        return new MavenUniverseException("Version range started at index " + startIndex + " in " + rangeStr + " is not complete");
    }

    private static MavenUniverseException unexpectedChar(String rangeStr, char ch, int index) {
        return new MavenUniverseException("Unexpected character " + ch + " at index " + index + " in " + rangeStr);
    }

    private MavenUniverseException boundNotClosed(String rangeStr, char trigger, int startIndex, char ending) {
        return new MavenUniverseException("The bound started by '" + trigger + "' at index " + startIndex + " in " + rangeStr + " is closed with '" + ending + "'");
    }

    private static MavenUniverseException boundNotClosed(String rangeStr, int startIndex) {
        return new MavenUniverseException("Bound start at index " + startIndex + " in " + rangeStr + " is missing closing ')' or ']'");
    }

    public static void main(String[] args) throws Exception {
        GenericVersionScheme scheme = new GenericVersionScheme();
        Version v = scheme.parseVersion("1.0.0.Deta3");
        Version v2 = scheme.parseVersion("1.0.0.Beta2");
        System.out.println(v2.compareTo(v));
        MavenArtifactVersion v1 = new MavenArtifactVersion("1.0.0.Alpha1-SNAPSHOT");
        MavenArtifactVersionRangeParser parser = new MavenArtifactVersionRangeParser();
        MavenArtifactVersionRange range = parser.parseRange("[1.0-alpha,2.0-alpha)");
        System.out.println(range);
        System.out.println(range.includesVersion(v1));
    }

    private static class RangeCollection
    implements MavenArtifactVersionRange {
        private final List<MavenArtifactVersionRange> ranges;

        private RangeCollection(List<MavenArtifactVersionRange> ranges) {
            this.ranges = ranges;
        }

        @Override
        public boolean includesVersion(MavenArtifactVersion version) {
            for (MavenArtifactVersionRange range : this.ranges) {
                if (!range.includesVersion(version)) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            StringUtils.append(buf, this.ranges);
            return buf.toString();
        }
    }

    private static class SimpleVersionRange
    implements MavenArtifactVersionRange {
        private final Bound left;
        private final Bound right;

        SimpleVersionRange(Bound left, Bound right) {
            this.left = left;
            this.right = right;
        }

        @Override
        public boolean includesVersion(MavenArtifactVersion version) {
            return !this.left.fallsLower(version) && !this.right.fallsHigher(version);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            if (this.left.included) {
                buf.append('[');
            } else {
                buf.append('(');
            }
            if (this.left.v != null) {
                buf.append(this.left.v);
            }
            buf.append(',');
            if (this.right.v != null) {
                buf.append(this.right.v);
            }
            if (this.right.included) {
                buf.append(']');
            } else {
                buf.append(')');
            }
            return buf.toString();
        }
    }

    private static class SingleVersionRange
    implements MavenArtifactVersionRange {
        private final MavenArtifactVersion version;
        private final boolean included;

        SingleVersionRange(MavenArtifactVersion version, boolean included) {
            this.version = version;
            this.included = included;
        }

        @Override
        public boolean includesVersion(MavenArtifactVersion version) {
            return !(this.version.compareTo(version) == 0 ^ this.included);
        }

        public String toString() {
            if (this.included) {
                return '[' + this.version.toString() + ']';
            }
            return '(' + this.version.toString() + ')';
        }
    }

    private static class Bound {
        private final MavenArtifactVersion v;
        private final boolean included;

        Bound(MavenArtifactVersion v, boolean included) {
            this.v = v;
            this.included = included;
        }

        boolean fallsLower(MavenArtifactVersion version) {
            if (this.v == null) {
                return false;
            }
            int i = this.v.compareTo(version);
            if (i == 0) {
                return !this.included;
            }
            return i > 0;
        }

        boolean fallsHigher(MavenArtifactVersion version) {
            if (this.v == null) {
                return false;
            }
            int i = this.v.compareTo(version);
            if (i == 0) {
                return !this.included;
            }
            return i < 0;
        }
    }
}

