#!/bin/sh
#
# This file is part of sudognu.
#
# Copyright (C) 2007-2009 Jens Baaran, Germany.
#
# THERE IS NO WARRANTY FOR THIS PROGRAM, TO THE EXTENT PERMITTED
# BY APPLICABLE LAW.
#
# See the GPL Version 2 (http://www.gnu.org/licenses/gpl.html)
# or the file COPYING for details
# ******************************************************************************
set -f
TMPDIR=./tmp
CGISUDOKU=/usr/local/bin/sudognu

cat <<- END
	Content-type: text/html
	
	<html>
	<head>
	  <title>Creating sudokus ...</title>
	  <style type="text/css">
		body      { background-color:white; color:black; margin-top:4ex; }
	  </style>
	</head>
	<body>
END

echo "  <p>"
rm -f `find $TMPDIR -mmin +20 -name *.pdf`
rm -f `find $TMPDIR -mmin +20 -name *.svg`
fn=$TMPDIR/`date +%M-%S`
echo "  </p>"

echo "  <h3>Sudokus are being created ...</h3>"
echo "  <pre>"
$CGISUDOKU -c -o $fn 2>&1
echo
echo "  </pre>"

echo "  <h3>Sudokus</h3>"
if test -f "$fn".pdf
then
	echo "  <p><a href=\"$fn.pdf\">pdf file with four sudokus</a></p>"
fi
if test -f "$fn".svg
then
	echo "  <p><a href=\"$fn.svg\">svg file with four sudokus</a></p>"
fi

echo "</body>"
echo "</html>"

