// Generated by gmmproc 2.50.0 -- DO NOT MODIFY!
#ifndef _GSTREAMERMM_MEMORY_H
#define _GSTREAMERMM_MEMORY_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* gstreamermm - a C++ wrapper for gstreamer
 *
 * Copyright 2008-2016 The gstreamermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gst/gst.h>
#include <gstreamermm/miniobject.h>
#include <gstreamermm/mapinfo.h>


namespace Gst
{

/** @addtogroup gstreamermmEnums gstreamermm Enums and Flags */

/** 
 *  @var MemoryFlags MEMORY_FLAG_READONLY
 * Memory is readonly. It is not allowed to map the
 * memory with Gst::MAP_WRITE.
 * 
 *  @var MemoryFlags MEMORY_FLAG_NO_SHARE
 * Memory must not be shared. Copies will have to be
 * made when this memory needs to be shared between buffers.
 * 
 *  @var MemoryFlags MEMORY_FLAG_ZERO_PREFIXED
 * The memory prefix is filled with 0 bytes.
 * 
 *  @var MemoryFlags MEMORY_FLAG_ZERO_PADDED
 * The memory padding is filled with 0 bytes.
 * 
 *  @var MemoryFlags MEMORY_FLAG_PHYSICALLY_CONTIGUOUS
 * The memory is physically contiguous. (Since 1.2).
 * 
 *  @var MemoryFlags MEMORY_FLAG_NOT_MAPPABLE
 * The memory can't be mapped via Gst::Memory::map() without any preconditions. (Since 1.2).
 * 
 *  @var MemoryFlags MEMORY_FLAG_LAST
 * First flag that can be used for custom purposes.
 * 
 *  @enum MemoryFlags
 * 
 * Flags for wrapped memory.
 *
 * @ingroup gstreamermmEnums
 * @par Bitwise operators:
 * <tt>%MemoryFlags operator|(MemoryFlags, MemoryFlags)</tt><br>
 * <tt>%MemoryFlags operator&(MemoryFlags, MemoryFlags)</tt><br>
 * <tt>%MemoryFlags operator^(MemoryFlags, MemoryFlags)</tt><br>
 * <tt>%MemoryFlags operator~(MemoryFlags)</tt><br>
 * <tt>%MemoryFlags& operator|=(MemoryFlags&, MemoryFlags)</tt><br>
 * <tt>%MemoryFlags& operator&=(MemoryFlags&, MemoryFlags)</tt><br>
 * <tt>%MemoryFlags& operator^=(MemoryFlags&, MemoryFlags)</tt><br>
 */
enum MemoryFlags
{
  MEMORY_FLAG_READONLY = GST_MINI_OBJECT_FLAG_LOCK_READONLY,
  MEMORY_FLAG_NO_SHARE = (GST_MINI_OBJECT_FLAG_LAST << 0),
  MEMORY_FLAG_ZERO_PREFIXED = (GST_MINI_OBJECT_FLAG_LAST << 1),
  MEMORY_FLAG_ZERO_PADDED = (GST_MINI_OBJECT_FLAG_LAST << 2),
  MEMORY_FLAG_PHYSICALLY_CONTIGUOUS = (GST_MINI_OBJECT_FLAG_LAST << 3),
  MEMORY_FLAG_NOT_MAPPABLE = (GST_MINI_OBJECT_FLAG_LAST << 4),
  MEMORY_FLAG_LAST = (GST_MINI_OBJECT_FLAG_LAST << 16)
};

/** @ingroup gstreamermmEnums */
inline MemoryFlags operator|(MemoryFlags lhs, MemoryFlags rhs)
  { return static_cast<MemoryFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup gstreamermmEnums */
inline MemoryFlags operator&(MemoryFlags lhs, MemoryFlags rhs)
  { return static_cast<MemoryFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup gstreamermmEnums */
inline MemoryFlags operator^(MemoryFlags lhs, MemoryFlags rhs)
  { return static_cast<MemoryFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup gstreamermmEnums */
inline MemoryFlags operator~(MemoryFlags flags)
  { return static_cast<MemoryFlags>(~static_cast<unsigned>(flags)); }

/** @ingroup gstreamermmEnums */
inline MemoryFlags& operator|=(MemoryFlags& lhs, MemoryFlags rhs)
  { return (lhs = static_cast<MemoryFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup gstreamermmEnums */
inline MemoryFlags& operator&=(MemoryFlags& lhs, MemoryFlags rhs)
  { return (lhs = static_cast<MemoryFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup gstreamermmEnums */
inline MemoryFlags& operator^=(MemoryFlags& lhs, MemoryFlags rhs)
  { return (lhs = static_cast<MemoryFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }

} // namespace Gst

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gst::MemoryFlags> : public Glib::Value_Flags<Gst::MemoryFlags>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gst
{


class Allocator;

/**
 * GstMemory is a lightweight refcounted object that wraps a region of memory.
 * They are typically used to manage the data of a Gst::Buffer.
 *
 * A GstMemory object has an allocated region of memory of maxsize. The maximum
 * size does not change during the lifetime of the memory object. The memory
 * also has an offset and size property that specifies the valid range of memory
 * in the allocated region.
 *
 * Memory is usually created by allocators with a Gst::Allocator::alloc()
 * method call.
 *
 * New memory can be created with Gst::Memory::create() that wraps the memory
 * allocated elsewhere.
 *
 * The size of the memory can be retrieved and changed with get_sizes()
 * and resize() respectively.
 *
 * Getting access to the data of the memory is performed with map().
 * The call will return a pointer to offset bytes into the region of memory.
 * After the memory access is completed, unmap() should be called.
 *
 * Memory can be copied with copy(), which will return a writable
 * copy. share() will create a new memory block that shares the
 * memory with an existing memory block at a custom offset and with a custom
 * size.
 *
 * Memory can be efficiently merged when is_span() returns %TRUE.
 *
 * Last reviewed on 2016-06-05 (1.8.0)
 */
class Memory : public MiniObject
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  using CppObjectType = Memory;
  using BaseObjectType = GstMemory;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


  /** Increment the reference count for this object.
   * You should never need to do this manually - use the object via a RefPtr instead.
   */
  void reference()   const;

  /** Decrement the reference count for this object.
   * You should never need to do this manually - use the object via a RefPtr instead.
   */
  void unreference() const;

  ///Provides access to the underlying C instance.
  GstMemory*       gobj();

  ///Provides access to the underlying C instance.
  const GstMemory* gobj() const;

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GstMemory* gobj_copy() const;

  Memory() = delete;

  // noncopyable
  Memory(const Memory&) = delete;
  Memory& operator=(const Memory&) = delete;

protected:
  // Do not derive this.  Gst::Memory can neither be constructed nor deleted.

  void operator delete(void*, std::size_t);

private:

  
public:

  /*
   * Allocate a new memory block that wraps the given @a data.
   *
   * @param flags: Gst::MemoryFlags.
   * @param data Data to wrap.
   * @param maxsize Allocated size of @a data.
   * @param offset Offset in @data.
   * @param size Size of valid data.
   *
   * @returns a new #Gst::Memory.
   */
  static Glib::RefPtr<Memory> create(Gst::MemoryFlags flags, gpointer data, gsize maxsize, gsize offset, gsize size);

  /** Get the maximum size allocated.
   */
  gsize get_maxsize() const;

  /** Get the alignment of the memory.
   */
  gsize get_align() const;

  /** Get the offset where valid data starts.
   */
  gsize get_offset() const;

  /** Get the size of valid data.
   */
  gsize get_size() const;

  /** Get parent memory block.
   */
  Glib::RefPtr<Gst::Memory> get_parent();
  Glib::RefPtr<const Gst::Memory> get_parent() const;

  /** Get the Gst::Allocator.
   */
  Glib::RefPtr<Gst::Allocator> get_allocator();
  Glib::RefPtr<const Gst::Allocator> get_allocator() const;

  
  /** Check if @a mem if allocated with an allocator for @a mem_type.
   * 
   * @param mem_type A memory type.
   * @return <tt>true</tt> if @a mem was allocated from an allocator for @a mem_type.
   */
  bool is_type(const Glib::ustring& mem_type) const;
  
  /** Return a shared copy of @a size bytes from @a mem starting from @a offset. No
   * memory copy is performed and the memory region is simply shared. The result
   * is guaranteed to be non-writable. @a size can be set to -1 to return a shared
   * copy from @a offset to the end of the memory region.
   * 
   * @param offset Offset to share from.
   * @param size Size to share, or -1 to share to the end of the memory region.
   * @return A new Gst::Memory.
   */
  Glib::RefPtr<Gst::Memory> share(gssize offset, gssize size);
  
  /** Resize the memory region. @a mem should be writable and offset + size should be
   * less than the maxsize of @a mem.
   * 
   * Gst::MEMORY_FLAG_ZERO_PREFIXED and Gst::MEMORY_FLAG_ZERO_PADDED will be
   * cleared when offset or padding is increased respectively.
   * 
   * @param offset A new offset.
   * @param size A new size.
   */
  void resize(gssize offset, gsize size);
  
  /** Check if @a mem1 and mem2 share the memory with a common parent memory object
   * and that the memory is contiguous.
   * 
   * If this is the case, the memory of @a mem1 and @a mem2 can be merged
   * efficiently by performing share() on the parent object from
   * the returned @a offset.
   * 
   * @param mem2 A Gst::Memory.
   * @param offset A pointer to a result offset.
   * @return <tt>true</tt> if the memory is contiguous and of a common parent.
   */
  bool is_span(const Glib::RefPtr<Gst::Memory>& mem2, gsize& offset);
  
  /** Fill @a info with the pointer and sizes of the memory in @a mem that can be
   * accessed according to @a flags.
   * 
   * This function can return <tt>false</tt> for various reasons:
   * - the memory backed by @a mem is not accessible with the given @a flags.
   * - the memory was already mapped with a different mapping.
   * 
   *  @a info and its contents remain valid for as long as @a mem is valid and
   * until unmap() is called.
   * 
   * For each map() call, a corresponding unmap() call
   * should be done.
   * 
   * @param info Pointer for info.
   * @param flags Mapping flags.
   * @return <tt>true</tt> if the map operation was successful.
   */
  bool map(Gst::MapInfo& info, Gst::MapFlags flags);
  
  /** Release the memory obtained with map()
   * 
   * @param info A Gst::MapInfo.
   */
  void unmap(Gst::MapInfo& info);
  
  /** Return a copy of @a size bytes from @a mem starting from @a offset. This copy is
   * guaranteed to be writable. @a size can be set to -1 to return a copy
   * from @a offset to the end of the memory region.
   * 
   * @param offset Offset to copy from.
   * @param size Size to copy, or -1 to copy to the end of the memory region.
   * @return A new Gst::Memory.
   */
  Glib::RefPtr<Gst::Memory> copy(gssize offset, gssize size);
  
  /** Initializes a newly allocated @a mem with the given parameters. This function
   * will call Gst::MiniObject::init() with the default memory parameters.
   * 
   * @param flags Gst::MemoryFlags.
   * @param allocator The Gst::Allocator.
   * @param parent The parent of @a mem.
   * @param maxsize The total size of the memory.
   * @param align The alignment of the memory.
   * @param offset The offset in the memory.
   * @param size The size of valid data in the memory.
   */
  void init(Gst::MemoryFlags flags, const Glib::RefPtr<Gst::Allocator>& allocator, const Glib::RefPtr<Gst::Memory>& parent, gsize maxsize, gsize align, gsize offset, gsize size);
  
  /** Get the current @a size, @a offset and @a maxsize of @a mem.
   * 
   * @param offset Pointer to offset.
   * @param maxsize Pointer to maxsize.
   * @return The current sizes of @a mem.
   */
  gsize get_sizes(gsize& offset, gsize& maxsize);

  /** Create a Gst::Memory object that is mapped with @a flags. If @a mem is mappable
   * with @a flags, this function returns the mapped @a mem directly. Otherwise a
   * mapped copy of @a mem is returned.
   *
   * @param info Pointer for info.
   * @param flags Mapping flags.
   *
   * @return a Gst::Memory object mapped.
   */
  Glib::RefPtr<Gst::Memory> make_mapped(Gst::MapInfo& info, Gst::MapFlags flags);
  

};

}//namespace Gst


namespace Glib
{

  /** A Glib::wrap() method for this object.
   *
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gst::Memory
   */
  Glib::RefPtr<Gst::Memory> wrap(GstMemory* object, bool take_copy = false);

} // namespace Glib


#endif /* _GSTREAMERMM_MEMORY_H */

