/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.tools.doclets.debugdoclet;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.RootDoc;
import com.sun.javadoc.Tag;
import java.io.PrintStream;
import java.util.Arrays;

public class DebugDoclet {
    private PrintStream out = System.out;

    public static boolean start(RootDoc rootDoc) {
        new DebugDoclet().run(rootDoc);
        return true;
    }

    private void printHeader(String header) {
        this.out.println();
        this.out.println("******** " + header + " ********");
        this.out.println();
    }

    private void printSubHeader(String header) {
        this.out.println();
        this.out.println("======== " + header + " ========");
        this.out.println();
    }

    private void printSub2Header(String header) {
        this.out.println();
        this.out.println("-------- " + header + " --------");
        this.out.println();
    }

    private void run(RootDoc rootDoc) {
        this.printHeader("Overview");
        this.printSubHeader("Specified Packages");
        Object[] specifiedPackages = rootDoc.specifiedPackages();
        Arrays.sort(specifiedPackages);
        int i = 0;
        while (i < specifiedPackages.length) {
            this.out.println(specifiedPackages[i].name());
            ++i;
        }
        this.printSubHeader("Specified Classes");
        Object[] specifiedClasses = rootDoc.specifiedClasses();
        Arrays.sort(specifiedClasses);
        int i2 = 0;
        while (i2 < specifiedClasses.length) {
            this.out.println(specifiedClasses[i2].qualifiedTypeName());
            ++i2;
        }
        this.printSubHeader("Classes");
        Object[] classes = rootDoc.classes();
        Arrays.sort(classes);
        int i3 = 0;
        while (i3 < classes.length) {
            this.out.println(classes[i3].qualifiedTypeName());
            ++i3;
        }
        this.printHeader("Class Detail");
        i3 = 0;
        while (i3 < classes.length) {
            this.printSubHeader(classes[i3].qualifiedTypeName());
            this.printTags(classes[i3].firstSentenceTags());
            this.printSub2Header("Methods");
            MethodDoc[] methods = classes[i3].methods();
            int j = 0;
            while (j < methods.length) {
                this.out.println("name: \"" + methods[j].name() + "\"");
                this.out.println("signature: \"" + methods[j].signature() + "\"");
                this.out.println("modifiers: \"" + methods[j].modifiers() + "\"");
                this.out.print("throws: ");
                ClassDoc[] thrownExceptions = methods[j].thrownExceptions();
                int k = 0;
                while (k < thrownExceptions.length) {
                    if (k > 0) {
                        this.out.print(", ");
                    }
                    this.out.print(thrownExceptions[k].qualifiedTypeName());
                    ++k;
                }
                this.out.println();
                ++j;
            }
            this.printSub2Header("Fields");
            FieldDoc[] fields = classes[i3].fields();
            int j2 = 0;
            while (j2 < fields.length) {
                this.out.println("name: \"" + fields[j2].name() + "\"");
                this.out.println("modifiers: \"" + fields[j2].modifiers() + "\"");
                this.out.println();
                ++j2;
            }
            this.printSub2Header("Serializable Fields");
            FieldDoc[] sfields = classes[i3].serializableFields();
            int j3 = 0;
            while (j3 < sfields.length) {
                this.out.println("name: \"" + sfields[j3].name() + "\"");
                this.out.println("modifiers: \"" + sfields[j3].modifiers() + "\"");
                this.out.println();
                ++j3;
            }
            ++i3;
        }
    }

    private void printTag(Tag tag) {
        if (tag.text() != null) {
            System.out.println(tag.text());
        }
    }

    private void printTags(Tag[] tags) {
        int i = 0;
        while (i < tags.length) {
            this.out.println("Tag #" + (i + 1) + ":");
            this.printTag(tags[i]);
            ++i;
        }
    }
}

