/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JPanel;
import javax.swing.SpinnerDateModel;
import javax.swing.SpinnerListModel;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.SpinnerUI;
import javax.swing.text.DateFormatter;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.NumberFormatter;

public class JSpinner
extends JComponent {
    private SpinnerModel model;
    private JComponent editor;
    private static final long serialVersionUID = 3412663575706551720L;

    public JSpinner() {
        this(new SpinnerNumberModel());
    }

    public JSpinner(SpinnerModel model) {
        this.model = model;
        this.editor = this.createEditor(model);
        model.addChangeListener(new ModelListener());
        this.updateUI();
    }

    public void commitEdit() throws ParseException {
        if (this.editor instanceof DefaultEditor) {
            ((DefaultEditor)this.editor).commitEdit();
        }
    }

    public JComponent getEditor() {
        return this.editor;
    }

    public void setEditor(JComponent editor) {
        if (editor == null) {
            throw new IllegalArgumentException("editor may not be null");
        }
        JComponent oldEditor = this.editor;
        if (oldEditor instanceof DefaultEditor) {
            ((DefaultEditor)oldEditor).dismiss(this);
        } else if (oldEditor instanceof ChangeListener) {
            this.removeChangeListener((ChangeListener)((Object)oldEditor));
        }
        this.editor = editor;
        this.firePropertyChange("editor", oldEditor, editor);
    }

    public SpinnerModel getModel() {
        return this.model;
    }

    public void setModel(SpinnerModel newModel) {
        if (newModel == null) {
            throw new IllegalArgumentException();
        }
        if (this.model == newModel) {
            return;
        }
        SpinnerModel oldModel = this.model;
        this.model = newModel;
        this.firePropertyChange("model", oldModel, newModel);
        this.setEditor(this.createEditor(this.model));
    }

    public Object getNextValue() {
        return this.model.getNextValue();
    }

    public Object getPreviousValue() {
        return this.model.getPreviousValue();
    }

    public SpinnerUI getUI() {
        return (SpinnerUI)this.ui;
    }

    public Object getValue() {
        return this.model.getValue();
    }

    public void setValue(Object value) {
        this.model.setValue(value);
    }

    public String getUIClassID() {
        return "SpinnerUI";
    }

    public void updateUI() {
        this.setUI((SpinnerUI)UIManager.getUI(this));
    }

    public void setUI(SpinnerUI ui) {
        super.setUI(ui);
    }

    public void addChangeListener(ChangeListener listener) {
        this.listenerList.add(ChangeListener.class, listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.listenerList.remove(ChangeListener.class, listener);
    }

    public ChangeListener[] getChangeListeners() {
        return (ChangeListener[])this.listenerList.getListeners(ChangeListener.class);
    }

    protected void fireStateChanged() {
        ChangeEvent evt = new ChangeEvent(this);
        ChangeListener[] listeners = this.getChangeListeners();
        int i = 0;
        while (i < listeners.length) {
            listeners[i].stateChanged(evt);
            ++i;
        }
    }

    protected JComponent createEditor(SpinnerModel model) {
        if (model instanceof SpinnerDateModel) {
            return new DateEditor(this);
        }
        if (model instanceof SpinnerNumberModel) {
            return new NumberEditor(this);
        }
        if (model instanceof SpinnerListModel) {
            return new ListEditor(this);
        }
        return new DefaultEditor(this);
    }

    public static class DateEditor
    extends DefaultEditor {
        private static final long serialVersionUID = -4279356973770397815L;

        public DateEditor(JSpinner spinner) {
            super(spinner);
            DateEditorFormatter nef = new DateEditorFormatter();
            nef.setMinimum(this.getModel().getStart());
            nef.setMaximum(this.getModel().getEnd());
            this.ftf.setFormatterFactory(new DefaultFormatterFactory(nef));
        }

        public DateEditor(JSpinner spinner, String dateFormatPattern) {
            super(spinner);
            DateEditorFormatter nef = new DateEditorFormatter(dateFormatPattern);
            nef.setMinimum(this.getModel().getStart());
            nef.setMaximum(this.getModel().getEnd());
            this.ftf.setFormatterFactory(new DefaultFormatterFactory(nef));
        }

        public SimpleDateFormat getFormat() {
            DateFormatter formatter = (DateFormatter)this.ftf.getFormatter();
            return (SimpleDateFormat)formatter.getFormat();
        }

        public SpinnerDateModel getModel() {
            return (SpinnerDateModel)this.getSpinner().getModel();
        }
    }

    static class DateEditorFormatter
    extends DateFormatter {
        public DateEditorFormatter() {
            super(DateFormat.getInstance());
        }

        public DateEditorFormatter(String dateFormatPattern) {
            super(new SimpleDateFormat(dateFormatPattern));
        }
    }

    public static class DefaultEditor
    extends JPanel
    implements ChangeListener,
    PropertyChangeListener,
    LayoutManager {
        private JSpinner spinner;
        JFormattedTextField ftf;
        private static final long serialVersionUID = -5317788736173368172L;

        public DefaultEditor(JSpinner spinner) {
            this.setLayout(this);
            this.spinner = spinner;
            this.ftf = new JFormattedTextField();
            this.add(this.ftf);
            this.ftf.setValue(spinner.getValue());
            this.ftf.addPropertyChangeListener(this);
            if (this.getComponentOrientation().isLeftToRight()) {
                this.ftf.setHorizontalAlignment(4);
            } else {
                this.ftf.setHorizontalAlignment(2);
            }
            spinner.addChangeListener(this);
        }

        public JSpinner getSpinner() {
            return this.spinner;
        }

        public void commitEdit() throws ParseException {
        }

        public void dismiss(JSpinner spinner) {
            spinner.removeChangeListener(this);
        }

        public JFormattedTextField getTextField() {
            return this.ftf;
        }

        public void layoutContainer(Container parent) {
            Insets insets = this.getInsets();
            Dimension size = this.getSize();
            this.ftf.setBounds(insets.left, insets.top, size.width - insets.left - insets.right, size.height - insets.top - insets.bottom);
        }

        public Dimension minimumLayoutSize(Container parent) {
            Insets insets = this.getInsets();
            Dimension minSize = this.ftf.getMinimumSize();
            return new Dimension(minSize.width + insets.left + insets.right, minSize.height + insets.top + insets.bottom);
        }

        public Dimension preferredLayoutSize(Container parent) {
            Insets insets = this.getInsets();
            Dimension prefSize = this.ftf.getPreferredSize();
            return new Dimension(prefSize.width + insets.left + insets.right, prefSize.height + insets.top + insets.bottom);
        }

        public void propertyChange(PropertyChangeEvent event) {
            if (event.getSource() == this.ftf && event.getPropertyName().equals("value")) {
                this.spinner.getModel().setValue(event.getNewValue());
            }
        }

        public void stateChanged(ChangeEvent event) {
            this.ftf.setValue(this.spinner.getValue());
        }

        public void removeLayoutComponent(Component child) {
        }

        public void addLayoutComponent(String name, Component child) {
        }
    }

    public static class ListEditor
    extends DefaultEditor {
        public ListEditor(JSpinner spinner) {
            super(spinner);
        }

        public SpinnerListModel getModel() {
            return (SpinnerListModel)this.getSpinner().getModel();
        }
    }

    class ModelListener
    implements ChangeListener {
        public void stateChanged(ChangeEvent event) {
            JSpinner.this.fireStateChanged();
        }
    }

    public static class NumberEditor
    extends DefaultEditor {
        private static final long serialVersionUID = 3791956183098282942L;

        public NumberEditor(JSpinner spinner) {
            super(spinner);
            NumberEditorFormatter nef = new NumberEditorFormatter();
            nef.setMinimum(this.getModel().getMinimum());
            nef.setMaximum(this.getModel().getMaximum());
            this.ftf.setFormatterFactory(new DefaultFormatterFactory(nef));
        }

        public NumberEditor(JSpinner spinner, String decimalFormatPattern) {
            super(spinner);
            NumberEditorFormatter nef = new NumberEditorFormatter(decimalFormatPattern);
            nef.setMinimum(this.getModel().getMinimum());
            nef.setMaximum(this.getModel().getMaximum());
            this.ftf.setFormatterFactory(new DefaultFormatterFactory(nef));
        }

        public DecimalFormat getFormat() {
            NumberFormatter formatter = (NumberFormatter)this.ftf.getFormatter();
            return (DecimalFormat)formatter.getFormat();
        }

        public SpinnerNumberModel getModel() {
            return (SpinnerNumberModel)this.getSpinner().getModel();
        }
    }

    static class NumberEditorFormatter
    extends NumberFormatter {
        public NumberEditorFormatter() {
            super(NumberFormat.getInstance());
        }

        public NumberEditorFormatter(String decimalFormatPattern) {
            super(new DecimalFormat(decimalFormatPattern));
        }
    }
}

