/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.AbstractListModel;
import javax.swing.MutableComboBoxModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultComboBoxModel
extends AbstractListModel
implements MutableComboBoxModel,
Serializable {
    private static final long serialVersionUID = 6698657703676921904L;
    private Vector list;
    private Object selectedItem = null;

    public DefaultComboBoxModel() {
        this.list = new Vector();
    }

    public DefaultComboBoxModel(Object[] items) {
        this.list = new Vector<Object>(Arrays.asList(items));
        if (this.list.size() > 0) {
            this.selectedItem = this.list.get(0);
        }
    }

    public DefaultComboBoxModel(Vector<?> vector) {
        this.list = vector;
        if (this.getSize() > 0) {
            this.selectedItem = vector.get(0);
        }
    }

    @Override
    public void addElement(Object object) {
        this.list.addElement(object);
        int index = this.list.size() - 1;
        this.fireIntervalAdded(this, index, index);
        if (this.list.size() == 1 && this.selectedItem == null) {
            this.setSelectedItem(object);
        }
    }

    @Override
    public void removeElementAt(int index) {
        int selected = this.getIndexOf(this.selectedItem);
        if (selected == index) {
            if (selected > 0) {
                this.setSelectedItem(this.getElementAt(selected - 1));
            } else {
                this.setSelectedItem(this.getElementAt(selected + 1));
            }
        }
        this.list.removeElementAt(index);
        this.fireIntervalRemoved(this, index, index);
    }

    @Override
    public void insertElementAt(Object object, int index) {
        this.list.insertElementAt(object, index);
        this.fireIntervalAdded(this, index, index);
    }

    @Override
    public void removeElement(Object object) {
        int index = this.getIndexOf(object);
        if (index != -1) {
            this.removeElementAt(index);
        }
    }

    public void removeAllElements() {
        this.selectedItem = null;
        int size = this.getSize();
        if (size > 0) {
            this.list.clear();
            this.fireIntervalRemoved(this, 0, size - 1);
        }
    }

    @Override
    public int getSize() {
        return this.list.size();
    }

    @Override
    public void setSelectedItem(Object object) {
        if (this.selectedItem == null && object == null) {
            return;
        }
        if (this.selectedItem != null && this.selectedItem.equals(object)) {
            return;
        }
        if (object != null && this.getIndexOf(object) == -1) {
            return;
        }
        this.selectedItem = object;
        this.fireContentsChanged(this, -1, -1);
    }

    @Override
    public Object getSelectedItem() {
        return this.selectedItem;
    }

    @Override
    public Object getElementAt(int index) {
        if (index < 0 || index >= this.list.size()) {
            return null;
        }
        return this.list.elementAt(index);
    }

    public int getIndexOf(Object object) {
        return this.list.indexOf(object);
    }
}

