/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Formatter;
import java.util.Locale;

public class PrintWriter
extends Writer {
    private boolean autoflush;
    private boolean error;
    private boolean closed;
    protected Writer out;
    private static final char[] line_separator = System.getProperty("line.separator", "\n").toCharArray();

    public PrintWriter(Writer wr) {
        super(wr.lock);
        this.out = wr;
    }

    public PrintWriter(Writer wr, boolean autoflush) {
        super(wr.lock);
        this.out = wr;
        this.autoflush = autoflush;
    }

    public PrintWriter(OutputStream out) {
        this.out = new OutputStreamWriter(out);
        this.lock = this.out;
    }

    public PrintWriter(OutputStream out, boolean autoflush) {
        this(out);
        this.autoflush = autoflush;
    }

    public PrintWriter(String file) throws FileNotFoundException {
        this(new FileOutputStream(file));
    }

    public PrintWriter(String file, String enc) throws FileNotFoundException, UnsupportedEncodingException {
        this(new OutputStreamWriter((OutputStream)new FileOutputStream(file), enc));
    }

    public PrintWriter(File file) throws FileNotFoundException {
        this(new FileOutputStream(file));
    }

    public PrintWriter(File file, String enc) throws FileNotFoundException, UnsupportedEncodingException {
        this(new OutputStreamWriter((OutputStream)new FileOutputStream(file), enc));
    }

    protected void setError() {
        this.error = true;
    }

    public boolean checkError() {
        if (!this.closed) {
            this.flush();
        }
        return this.error;
    }

    public void flush() {
        try {
            this.out.flush();
        }
        catch (IOException iOException) {
            this.error = true;
        }
    }

    public void close() {
        try {
            this.out.close();
            this.closed = true;
        }
        catch (IOException iOException) {
            this.error = true;
        }
    }

    public void print(String str) {
        this.write(str == null ? "null" : str);
    }

    public void print(char ch) {
        this.write(ch);
    }

    public void print(char[] charArray) {
        this.write(charArray, 0, charArray.length);
    }

    public void print(boolean bool) {
        this.write(bool ? "true" : "false");
    }

    public void print(int inum) {
        this.write(Integer.toString(inum));
    }

    public void print(long lnum) {
        this.write(Long.toString(lnum));
    }

    public void print(float fnum) {
        this.write(Float.toString(fnum));
    }

    public void print(double dnum) {
        this.write(Double.toString(dnum));
    }

    public void print(Object obj) {
        this.write(obj == null ? "null" : obj.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println() {
        Object object = this.lock;
        synchronized (object) {
            try {
                this.write(line_separator, 0, line_separator.length);
                if (this.autoflush) {
                    this.out.flush();
                }
            }
            catch (IOException iOException) {
                this.error = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(boolean bool) {
        Object object = this.lock;
        synchronized (object) {
            this.print(bool);
            this.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(int inum) {
        Object object = this.lock;
        synchronized (object) {
            this.print(inum);
            this.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(long lnum) {
        Object object = this.lock;
        synchronized (object) {
            this.print(lnum);
            this.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(float fnum) {
        Object object = this.lock;
        synchronized (object) {
            this.print(fnum);
            this.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(double dnum) {
        Object object = this.lock;
        synchronized (object) {
            this.print(dnum);
            this.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(Object obj) {
        Object object = this.lock;
        synchronized (object) {
            this.print(obj);
            this.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(String str) {
        Object object = this.lock;
        synchronized (object) {
            this.print(str);
            this.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(char ch) {
        Object object = this.lock;
        synchronized (object) {
            this.print(ch);
            this.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(char[] charArray) {
        Object object = this.lock;
        synchronized (object) {
            this.print(charArray);
            this.println();
        }
    }

    public void write(int ch) {
        try {
            this.out.write(ch);
        }
        catch (IOException iOException) {
            this.error = true;
        }
    }

    public void write(char[] charArray, int offset, int count) {
        try {
            this.out.write(charArray, offset, count);
        }
        catch (IOException iOException) {
            this.error = true;
        }
    }

    public void write(String str, int offset, int count) {
        try {
            this.out.write(str, offset, count);
        }
        catch (IOException iOException) {
            this.error = true;
        }
    }

    public void write(char[] charArray) {
        this.write(charArray, 0, charArray.length);
    }

    public void write(String str) {
        this.write(str, 0, str.length());
    }

    public PrintWriter append(char c) {
        this.write(c);
        return this;
    }

    public PrintWriter append(CharSequence cs) {
        this.write(cs == null ? "null" : cs.toString());
        return this;
    }

    public PrintWriter append(CharSequence cs, int start, int end) {
        this.write(cs == null ? "null" : cs.subSequence(start, end).toString());
        return this;
    }

    public PrintWriter printf(String format, Object ... args) {
        return this.format(format, args);
    }

    public PrintWriter printf(Locale locale, String format, Object ... args) {
        return this.format(locale, format, args);
    }

    public PrintWriter format(String format, Object ... args) {
        return this.format(Locale.getDefault(), format, args);
    }

    public PrintWriter format(Locale locale, String format, Object ... args) {
        Formatter f = new Formatter(this, locale);
        f.format(format, args);
        return this;
    }
}

